/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Type;

public class CfConstClass
extends CfInstruction {
    private final DexType type;

    public CfConstClass(DexType type) {
        this.type = type;
    }

    public DexType getType() {
        return this.type;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitLdcInsn(Type.getObjectType(this.getInternalName(lens)));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    private String getInternalName(NamingLens lens) {
        switch (this.type.toShorty()) {
            case 'L': 
            case '[': {
                return lens.lookupInternalName(this.type);
            }
            case 'Z': {
                return "java/lang/Boolean/TYPE";
            }
            case 'B': {
                return "java/lang/Byte/TYPE";
            }
            case 'S': {
                return "java/lang/Short/TYPE";
            }
            case 'C': {
                return "java/lang/Character/TYPE";
            }
            case 'I': {
                return "java/lang/Integer/TYPE";
            }
            case 'F': {
                return "java/lang/Float/TYPE";
            }
            case 'J': {
                return "java/lang/Long/TYPE";
            }
            case 'D': {
                return "java/lang/Double/TYPE";
            }
        }
        throw new Unreachable("Unexpected type in const-class: " + this.type);
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        registry.registerConstClass(this.type);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        builder.addConstClass(state.push((DexType)builder.appView.dexItemFactory().classType).register, this.type);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        return inliningConstraints.forConstClass(this.type, invocationContext);
    }
}

