/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.Version;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationWriter;
import shadow.bundletool.com.android.tools.r8.dex.Marker;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.analysis.ClassInitializerAssertionEnablingAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.PrefixRewritingMapper;
import shadow.bundletool.com.android.tools.r8.ir.optimize.AssertionsRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import shadow.bundletool.com.android.tools.r8.naming.PrefixRewritingNamingLens;
import shadow.bundletool.com.android.tools.r8.origin.CommandLineOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

@Keep
public final class D8 {
    private D8() {
    }

    public static void run(D8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withD8CompilationHandler(command.getReporter(), () -> {
            try {
                D8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    public static void run(D8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withD8CompilationHandler(command.getReporter(), () -> D8.run(app, options, executor));
    }

    private static void run(String[] args) throws CompilationFailedException {
        D8Command command = (D8Command)D8Command.parse(args, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            System.out.println(D8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("D8 " + Version.getVersionString());
            return;
        }
        InternalOptions options = command.getInternalOptions();
        AndroidApp app = command.getInputApp();
        D8.runForTesting(app, options);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(D8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        ExceptionUtils.withMainProgramHandler(() -> D8.run(args));
    }

    static void runForTesting(AndroidApp inputApp, InternalOptions options) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withD8CompilationHandler(options.reporter, () -> {
            try {
                D8.run(inputApp, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    private static void run(AndroidApp inputApp, InternalOptions options, ExecutorService executor) throws IOException {
        Timing timing = new Timing("D8");
        try {
            CfgPrinter printer;
            options.disableGlobalOptimizations();
            DexApplication app = new ApplicationReader(inputApp, options, timing).read(executor);
            PrefixRewritingMapper rewritePrefix = options.desugaredLibraryConfiguration.createPrefixRewritingMapper(options.itemFactory);
            AppInfo appInfo = new AppInfo(app);
            CfgPrinter cfgPrinter = printer = options.printCfg ? new CfgPrinter() : null;
            if (AssertionsRewriter.isEnabled(options)) {
                ClassInitializerAssertionEnablingAnalysis analysis = new ClassInitializerAssertionEnablingAnalysis(appInfo.dexItemFactory(), OptimizationFeedbackSimple.getInstance());
                for (DexProgramClass dexProgramClass : appInfo.classes()) {
                    if (!dexProgramClass.hasClassInitializer()) continue;
                    analysis.processNewlyLiveMethod(dexProgramClass.getClassInitializer());
                }
            }
            IRConverter converter = new IRConverter(AppView.createForD8(appInfo, options, rewritePrefix), timing, printer);
            app = converter.convert(app, executor);
            if (options.printCfg) {
                if (options.printCfgFile == null || options.printCfgFile.isEmpty()) {
                    System.out.print(printer.toString());
                } else {
                    Throwable throwable = null;
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(options.printCfgFile), StandardCharsets.UTF_8);){
                        writer.write(printer.toString());
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
            }
            inputApp.closeInternalArchiveProviders();
            if (options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                options.methodsFilter.forEach(m -> System.out.println("  - " + m));
            }
            boolean hasClassResources = false;
            for (DexProgramClass dexProgramClass : app.classes()) {
                if (!dexProgramClass.originatesFromClassResource()) continue;
                hasClassResources = true;
                break;
            }
            Marker marker = options.getMarker(Marker.Tool.D8);
            HashSet<Marker> markers = new HashSet<Marker>(app.dexItemFactory.extractMarkers());
            if (marker != null && hasClassResources) {
                markers.add(marker);
            }
            new ApplicationWriter(app, null, options, marker == null ? null : ImmutableList.copyOf(markers), GraphLense.getIdentityLense(), PrefixRewritingNamingLens.createPrefixRewritingNamingLens(options, rewritePrefix), null).write(executor);
            options.printWarnings();
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            options.signalFinishedToConsumers();
            if (options.printTimes) {
                timing.report();
            }
        }
    }

    static DexApplication optimize(DexApplication application, AppInfo appInfo, InternalOptions options, Timing timing, ExecutorService executor) throws IOException, ExecutionException {
        CfgPrinter printer = options.printCfg ? new CfgPrinter() : null;
        IRConverter converter = new IRConverter(appInfo, options, timing, printer);
        application = converter.convert(application, executor);
        if (options.printCfg) {
            if (options.printCfgFile == null || options.printCfgFile.isEmpty()) {
                System.out.print(printer.toString());
            } else {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(options.printCfgFile), StandardCharsets.UTF_8);){
                    writer.write(printer.toString());
                }
            }
        }
        return application;
    }
}

