/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.Keep;

@Keep
public final class ByteDataView {
    private byte[] buffer;
    private final int offset;
    private final int length;

    public static ByteDataView of(byte[] data2) {
        return new ByteDataView(data2, 0, data2.length);
    }

    public ByteDataView(byte[] buffer, int offset, int length) {
        assert (offset >= 0);
        assert (length >= 0);
        assert (offset + length <= buffer.length);
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getBuffer() {
        assert (this.buffer != null);
        return this.buffer;
    }

    public int getOffset() {
        assert (this.buffer != null);
        return this.offset;
    }

    public int getLength() {
        assert (this.buffer != null);
        return this.length;
    }

    public byte[] copyByteData() {
        return Arrays.copyOfRange(this.buffer, this.offset, this.offset + this.length);
    }

    public void invalidate() {
        this.buffer = null;
    }
}

