/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.AssertionsConfiguration;
import shadow.bundletool.com.android.tools.r8.BaseCommand;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommand;
import shadow.bundletool.com.android.tools.r8.JdkClassFileProvider;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class BaseCompilerCommandParser<C extends BaseCompilerCommand, B extends BaseCompilerCommand.Builder<C, B>> {
    static final Iterable<String> ASSERTIONS_USAGE_MESSAGE = Arrays.asList("  --force-enable-assertions[:[<class name>|<package name>...]]", "  --force-ea[:[<class name>|<package name>...]]", "                          # Forcefully enable javac generated assertion code.", "  --force-disable-assertions[:[<class name>|<package name>...]]", "  --force-da[:[<class name>|<package name>...]]", "                          # Forcefully disable javac generated assertion code. This", "                          # is the default handling of javac assertion code when", "                          # generating DEX file format.", "  --force-passthrough-assertions[:[<class name>|<package name>...]]", "  --force-pa[:[<class name>|<package name>...]]", "                          # Don't change javac generated assertion code. This", "                          # is the default handling of javac assertion code when", "                          # generating class file format.");
    private static String PACKAGE_ASSERTION_POSTFIX = "...";

    void parseMinApi(B builder, String minApiString, Origin origin) {
        int minApi;
        try {
            minApi = Integer.parseInt(minApiString);
        }
        catch (NumberFormatException e) {
            ((BaseCommand.Builder)builder).error(new StringDiagnostic("Invalid argument to --min-api: " + minApiString, origin));
            return;
        }
        if (minApi < 1) {
            ((BaseCommand.Builder)builder).error(new StringDiagnostic("Invalid argument to --min-api: " + minApiString, origin));
            return;
        }
        ((BaseCompilerCommand.Builder)builder).setMinApiLevel(minApi);
    }

    private void addAssertionTransformation(B builder, AssertionsConfiguration.AssertionTransformation transformation, String scope) {
        if (scope == null) {
            ((BaseCompilerCommand.Builder)builder).addAssertionsConfiguration(b -> b.setTransformation(transformation).setScopeAll().build());
        } else {
            assert (scope.length() > 0);
            if (scope.endsWith(PACKAGE_ASSERTION_POSTFIX)) {
                ((BaseCompilerCommand.Builder)builder).addAssertionsConfiguration(b -> b.setTransformation(transformation).setScopePackage(scope.substring(0, scope.length() - PACKAGE_ASSERTION_POSTFIX.length())).build());
            } else {
                ((BaseCompilerCommand.Builder)builder).addAssertionsConfiguration(b -> b.setTransformation(transformation).setScopeClass(scope).build());
            }
        }
    }

    boolean tryParseAssertionArgument(B builder, String arg, Origin origin) {
        String FORCE_ENABLE_ASSERTIONS = "--force-enable-assertions";
        String FORCE_EA = "--force-ea";
        String FORCE_DISABLE_ASSERTIONS = "--force-disable-assertions";
        String FORCE_DA = "--force-da";
        String FORCE_PASSTHROUGH_ASSERTIONS = "--force-passthrough-assertions";
        String FORCE_PA = "--force-pa";
        AssertionsConfiguration.AssertionTransformation transformation = null;
        String remaining = null;
        if (arg.startsWith(FORCE_ENABLE_ASSERTIONS)) {
            transformation = AssertionsConfiguration.AssertionTransformation.ENABLE;
            remaining = arg.substring(FORCE_ENABLE_ASSERTIONS.length());
        } else if (arg.startsWith(FORCE_EA)) {
            transformation = AssertionsConfiguration.AssertionTransformation.ENABLE;
            remaining = arg.substring(FORCE_EA.length());
        } else if (arg.startsWith(FORCE_DISABLE_ASSERTIONS)) {
            transformation = AssertionsConfiguration.AssertionTransformation.DISABLE;
            remaining = arg.substring(FORCE_DISABLE_ASSERTIONS.length());
        } else if (arg.startsWith(FORCE_DA)) {
            transformation = AssertionsConfiguration.AssertionTransformation.DISABLE;
            remaining = arg.substring(FORCE_DA.length());
        } else if (arg.startsWith(FORCE_PASSTHROUGH_ASSERTIONS)) {
            transformation = AssertionsConfiguration.AssertionTransformation.PASSTHROUGH;
            remaining = arg.substring(FORCE_PASSTHROUGH_ASSERTIONS.length());
        } else if (arg.startsWith(FORCE_PA)) {
            transformation = AssertionsConfiguration.AssertionTransformation.PASSTHROUGH;
            remaining = arg.substring(FORCE_PA.length());
        }
        if (transformation != null) {
            if (remaining.length() == 0) {
                this.addAssertionTransformation(builder, transformation, null);
                return true;
            }
            if (remaining.length() == 1 || remaining.charAt(0) != ':') {
                return false;
            }
            String classOrPackageScope = remaining.substring(1);
            if (classOrPackageScope.contains(";") || classOrPackageScope.contains("[") || classOrPackageScope.contains("/")) {
                ((BaseCommand.Builder)builder).error(new StringDiagnostic("Illegal assertion scope: " + classOrPackageScope, origin));
            }
            this.addAssertionTransformation(builder, transformation, remaining.substring(1));
            return true;
        }
        return false;
    }

    private static boolean isJdkHome(Path home) {
        Path jrtFsJar = home.resolve("lib").resolve("jrt-fs.jar");
        if (Files.exists(jrtFsJar, new LinkOption[0])) {
            return true;
        }
        Path rtJar = home.resolve("jre").resolve("lib").resolve("rt.jar");
        if (Files.exists(rtJar, new LinkOption[0])) {
            return true;
        }
        rtJar = home.resolve("lib").resolve("rt.jar");
        return Files.exists(rtJar, new LinkOption[0]);
    }

    static void addLibraryArgument(BaseCommand.Builder builder, Origin origin, String arg) {
        Path path = Paths.get(arg, new String[0]);
        if (BaseCompilerCommandParser.isJdkHome(path)) {
            try {
                builder.addLibraryResourceProvider(JdkClassFileProvider.fromJdkHome(path));
            }
            catch (IOException e) {
                builder.error(new ExceptionDiagnostic(e, origin));
            }
        } else {
            builder.addLibraryFiles(path);
        }
    }
}

