/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.Targeting;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;

public final class TextureCompressionUtils {
    public static final ImmutableBiMap<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias, String> TEXTURE_COMPRESSION_FORMAT_TO_MANIFEST_VALUE = ImmutableBiMap.builder().put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ASTC, (Object)"GL_KHR_texture_compression_astc_ldr").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ATC, (Object)"GL_AMD_compressed_ATC_texture").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.DXT1, (Object)"GL_EXT_texture_compression_dxt1").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ETC1_RGB8, (Object)"GL_OES_compressed_ETC1_RGB8_texture").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.LATC, (Object)"GL_EXT_texture_compression_latc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.PALETTED, (Object)"GL_OES_compressed_paletted_texture").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.PVRTC, (Object)"GL_IMG_texture_compression_pvrtc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.S3TC, (Object)"GL_EXT_texture_compression_s3tc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.THREE_DC, (Object)"GL_AMD_compressed_3DC_texture").build();
    public static final ImmutableMap<String, Targeting.TextureCompressionFormatTargeting> TEXTURE_TO_TARGETING = new ImmutableMap.Builder().put((Object)"astc", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ASTC)).put((Object)"atc", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ATC)).put((Object)"dxt1", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.DXT1)).put((Object)"latc", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.LATC)).put((Object)"paletted", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.PALETTED)).put((Object)"pvrtc", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.PVRTC)).put((Object)"etc1", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ETC1_RGB8)).put((Object)"etc2", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ETC2)).put((Object)"s3tc", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.S3TC)).put((Object)"3dc", (Object)TextureCompressionUtils.textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.THREE_DC)).build();
    public static final ImmutableBiMap<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias, String> TARGETING_TO_TEXTURE = ImmutableBiMap.builder().put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ASTC, (Object)"astc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ATC, (Object)"atc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.DXT1, (Object)"dxt1").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ETC1_RGB8, (Object)"etc1").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ETC2, (Object)"etc2").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.LATC, (Object)"latc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.PALETTED, (Object)"paletted").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.PVRTC, (Object)"pvrtc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.S3TC, (Object)"s3tc").put((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.THREE_DC, (Object)"3dc").build();

    public static Optional<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias> textureCompressionFormat(String glExtension) {
        return Optional.ofNullable(TEXTURE_COMPRESSION_FORMAT_TO_MANIFEST_VALUE.inverse().get((Object)glExtension));
    }

    private static Targeting.TextureCompressionFormatTargeting textureCompressionFormat(Targeting.TextureCompressionFormat.TextureCompressionFormatAlias alias) {
        return Targeting.TextureCompressionFormatTargeting.newBuilder().addValue(Targeting.TextureCompressionFormat.newBuilder().setAlias(alias)).build();
    }

    public static ImmutableList<Targeting.TextureCompressionFormat.TextureCompressionFormatAlias> textureCompressionFormatsForGl(int glVersion) {
        if (glVersion >= 196608) {
            return ImmutableList.of((Object)((Object)Targeting.TextureCompressionFormat.TextureCompressionFormatAlias.ETC2));
        }
        return ImmutableList.of();
    }

    private TextureCompressionUtils() {
    }
}

