/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.zip;

import com.android.tools.build.bundletool.utils.zip.OutputBuilder;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBuilder
extends OutputBuilder {
    @Override
    public Path writeTo(Path target) throws IOException {
        Path tempFile = Files.createTempFile("ZipBuilder-", ".zip.tmp", new FileAttribute[0]);
        try {
            try (ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(tempFile.toFile()));){
                for (Map.Entry entry : this.entries.entrySet()) {
                    String path = (String)entry.getKey();
                    InputStream content = ((OutputBuilder.InputStreamSupplier)entry.getValue()).get();
                    Throwable throwable = null;
                    try {
                        Preconditions.checkState((!path.endsWith("/") || content.read() == -1 ? 1 : 0) != 0, (String)"Directory entries are supposed to have empty content, but '%s' does not.", (Object)path);
                        outZip.putNextEntry(new ZipEntry(path));
                        ByteStreams.copy((InputStream)content, (OutputStream)outZip);
                        outZip.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (content == null) continue;
                        if (throwable != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        content.close();
                    }
                }
            }
            Files.move(tempFile, target, new CopyOption[0]);
        }
        catch (IOException e) {
            Files.deleteIfExists(tempFile);
            throw e;
        }
        return target;
    }
}

