/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.flags;

import com.android.tools.build.bundletool.utils.flags.FlagParser;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class Flag<T> {
    protected final String name;

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Flag<Path> path(String name) {
        return new PathFlag(name);
    }

    public static Flag<ImmutableList<Path>> paths(String name) {
        return new FlagList<Path>(new PathFlag(name));
    }

    public static Flag<ImmutableList<String>> strings(String name) {
        return new FlagList<String>(new StringFlag(name));
    }

    public static Flag<String> string(String name) {
        return new StringFlag(name);
    }

    public static Flag<Boolean> booleanFlag(String name) {
        return new BooleanFlag(name);
    }

    public static <T extends Enum<T>> Flag<ImmutableList<T>> enums(String name, Class<T> enumClass) {
        return new FlagList<T>(new EnumFlag<T>(name, enumClass));
    }

    public final T getRequiredValue(ParsedFlags flags) {
        return this.value(flags).orElseThrow(() -> new RequiredFlagNotSetException(this.name));
    }

    public final Optional<T> value(ParsedFlags flags) {
        return flags.getFlagValue(this.name).map(this::parse);
    }

    protected abstract T parse(String var1);

    Flag(String name) {
        this.name = name;
    }

    public static final class RequiredFlagNotSetException
    extends FlagParser.FlagParseException {
        RequiredFlagNotSetException(String flagName) {
            super(String.format("Missing the required --%s flag.", flagName));
        }
    }

    static class EnumFlag<T extends Enum<T>>
    extends Flag<T> {
        private Class<T> enumType;

        public EnumFlag(String name, Class<T> enumType) {
            super(name);
            this.enumType = enumType;
        }

        @Override
        protected T parse(String value) {
            try {
                return Enum.valueOf(this.enumType, value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new FlagParser.FlagParseException(String.format("Not a valid enum value: %s. Expected one of: %s", value, Arrays.stream(this.enumType.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "))));
            }
        }
    }

    static class FlagList<T>
    extends Flag<ImmutableList<T>> {
        private Flag<T> singleFlag;

        FlagList(Flag<T> singleFlag) {
            super(singleFlag.name);
            this.singleFlag = singleFlag;
        }

        @Override
        protected ImmutableList<T> parse(String value) {
            if (value.isEmpty()) {
                return ImmutableList.of();
            }
            return (ImmutableList)Arrays.asList(value.split(",")).stream().map(this.singleFlag::parse).collect(ImmutableList.toImmutableList());
        }
    }

    static class StringFlag
    extends Flag<String> {
        public StringFlag(String name) {
            super(name);
        }

        @Override
        protected String parse(String value) {
            return value;
        }
    }

    static class PathFlag
    extends Flag<Path> {
        public PathFlag(String name) {
            super(name);
        }

        @Override
        protected Path parse(String value) {
            return Paths.get(value, new String[0]);
        }
    }

    static class BooleanFlag
    extends Flag<Boolean> {
        public BooleanFlag(String name) {
            super(name);
        }

        @Override
        protected Boolean parse(String value) {
            if (value != null) {
                if (value.isEmpty() || value.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
            }
            throw new FlagParser.FlagParseException(String.format("Error while parsing the boolean flag --%s. Expected values: [<empty>|true|false] but found: %s.", this.name, MoreObjects.firstNonNull((Object)value, (Object)"null")));
        }
    }
}

