/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ModuleSplitOnDisk;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.GraphicsApiAssetsSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.SameTargetingMerger;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.android.tools.build.bundletool.splitters.TextureCompressionFormatAssetsSplitter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ModuleSplitter {
    private final BundleModule module;
    private final ImmutableList<SplittingDimension> splittingDimensions;

    public ModuleSplitter(BundleModule module, ImmutableList<SplittingDimension> splittingDimensions) {
        this.splittingDimensions = splittingDimensions;
        this.module = module;
    }

    public ImmutableList<ModuleSplitOnDisk> splitModule(Path outputDirectory) {
        ImmutableList.Builder splits = new ImmutableList.Builder();
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline();
        splits.addAll(resourcesPipeline.split(ModuleSplit.forResources(this.module)));
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline();
        splits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(this.module)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline();
        splits.addAll(assetsPipeline.split(ModuleSplit.forAssets(this.module)));
        splits.add((Object)ModuleSplit.forCode(this.module));
        splits.add((Object)ModuleSplit.forRoot(this.module));
        ImmutableCollection<ModuleSplit> mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)splits.build());
        ImmutableList defaultTargetingSplits = (ImmutableList)mergedSplits.stream().filter(split -> split.getTargeting().equals(Targeting.SplitTargeting.getDefaultInstance())).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((defaultTargetingSplits.size() == 1 ? 1 : 0) != 0, (Object)"Expected one split with default targeting");
        return (ImmutableList)mergedSplits.stream().map(split -> this.writeSplit(this.module, outputDirectory, (ModuleSplit)split)).collect(ImmutableList.toImmutableList());
    }

    private SplittingPipeline createResourcesSplittingPipeline() {
        ImmutableList.Builder resourceSplitters = new ImmutableList.Builder();
        if (this.splittingDimensions.contains((Object)SplittingDimension.DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter());
        }
        if (this.splittingDimensions.contains((Object)SplittingDimension.LANGUAGE)) {
            resourceSplitters.add((Object)new LanguageResourcesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline() {
        ImmutableList.Builder nativeSplitters = new ImmutableList.Builder();
        if (this.splittingDimensions.contains((Object)SplittingDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline() {
        ImmutableList.Builder assetsSplitters = new ImmutableList.Builder();
        if (this.splittingDimensions.contains((Object)SplittingDimension.GRAPHICS_API)) {
            assetsSplitters.add((Object)GraphicsApiAssetsSplitter.create());
        }
        if (this.splittingDimensions.contains((Object)SplittingDimension.TEXTURE_COMPRESSION_FORMAT)) {
            assetsSplitters.add((Object)TextureCompressionFormatAssetsSplitter.create());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    public ModuleSplitOnDisk writeSplit(BundleModule module, Path outputDirectory, ModuleSplit split) {
        Path outputPath = outputDirectory.resolve(module.getName() + "-" + split.getSuffix() + ".zip");
        return split.writeTo(outputPath);
    }

    public static enum SplittingDimension {
        ABI,
        DENSITY,
        LANGUAGE,
        GRAPHICS_API,
        TEXTURE_COMPRESSION_FORMAT;


        public static String getValues(String delimiter) {
            return Arrays.stream(SplittingDimension.values()).map(Enum::name).collect(Collectors.joining(delimiter));
        }
    }
}

