/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Files;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.manifest.ProtoManifest;
import com.android.tools.build.bundletool.model.AutoValue_BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

@AutoValue
public abstract class BundleModule {
    public static final String MANIFEST_FILENAME = "AndroidManifest.xml";
    public static final Path ASSETS_DIRECTORY = Paths.get("assets", new String[0]);
    public static final Path DEX_DIRECTORY = Paths.get("dex", new String[0]);
    public static final Path LIB_DIRECTORY = Paths.get("lib", new String[0]);
    public static final Path MANIFEST_DIRECTORY = Paths.get("manifest", new String[0]);
    public static final Path RESOURCES_DIRECTORY = Paths.get("res", new String[0]);
    public static final Path ROOT_DIRECTORY = Paths.get("root", new String[0]);
    public static final Path ASSETS_PROTO_PATH = Paths.get("assets.pb", new String[0]);
    public static final Path MANIFEST_PATH = MANIFEST_DIRECTORY.resolve("AndroidManifest.xml");
    public static final Path NATIVE_PROTO_PATH = Paths.get("native.pb", new String[0]);
    public static final Path RESOURCES_PROTO_PATH = Paths.get("resources.pb", new String[0]);

    public abstract BundleModuleName getName();

    public abstract ImmutableMap<Path, ModuleEntry> getEntries();

    public abstract Optional<ModuleEntry> getManifestEntry();

    public abstract Optional<ModuleEntry> getResourcesProtoEntry();

    public boolean isBaseModule() {
        return "base".equals(this.getName().getName());
    }

    public abstract Optional<ModuleEntry> getAssetsConfigEntry();

    public abstract Optional<ModuleEntry> getNativeConfigEntry();

    public Optional<Files.Assets> getAssetsConfig() {
        if (!this.getAssetsConfigEntry().isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.Assets.parseFrom(this.getAssetsConfigEntry().get().getContent()));
        }
        catch (IOException e) {
            throw new ValidationException(e, "Error while reading the assets.pb file in the module '%s'.", this.getName());
        }
    }

    public Optional<Files.NativeLibraries> getNativeConfig() {
        if (!this.getNativeConfigEntry().isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.NativeLibraries.parseFrom(this.getNativeConfigEntry().get().getContent()));
        }
        catch (IOException e) {
            throw new ValidationException(e, "Error while reading the native.pb file in the module '%s'.", this.getName());
        }
    }

    public Optional<Resources.ResourceTable> getResourceTable() {
        if (!this.getResourcesProtoEntry().isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Resources.ResourceTable.parseFrom((InputStream)this.getResourcesProtoEntry().get().getContent()));
        }
        catch (IOException e) {
            throw new ValidationException(e, "Error while reading the resources.pb file in the module '%s'.", this.getName());
        }
    }

    public AndroidManifest getManifest() {
        ModuleEntry manifestEntry = this.getManifestEntry().orElseThrow(() -> new ValidationException("Module '%s' does not contain a manifest.", this.getName()));
        try {
            return ProtoManifest.create(Resources.XmlNode.parseFrom((InputStream)manifestEntry.getContent()));
        }
        catch (IOException e) {
            throw new ValidationException(e, "Error while reading the AndroidManifest.xml from the module '%s'.", this.getName());
        }
    }

    public Stream<ModuleEntry> findEntries(Predicate<Path> pathPredicate) {
        return this.getEntries().values().stream().filter(entry -> pathPredicate.test(entry.getPath()));
    }

    public Stream<ModuleEntry> findEntriesUnderPath(String path) {
        return this.findEntries(p -> p.startsWith(path));
    }

    public Stream<ModuleEntry> findEntriesUnderPath(Path path) {
        return this.findEntries(p -> p.startsWith(path));
    }

    public static Builder builder() {
        return new AutoValue_BundleModule.Builder();
    }

    public static abstract class Builder {
        public abstract Builder setName(BundleModuleName var1);

        abstract ImmutableMap.Builder<Path, ModuleEntry> entriesBuilder();

        abstract Builder setManifestEntry(ModuleEntry var1);

        abstract Builder setResourcesProtoEntry(ModuleEntry var1);

        abstract Builder setAssetsConfigEntry(ModuleEntry var1);

        abstract Builder setNativeConfigEntry(ModuleEntry var1);

        public Builder addEntries(Collection<ModuleEntry> entries) {
            entries.forEach(this::addEntry);
            return this;
        }

        public Builder addEntry(ModuleEntry moduleEntry) {
            if (moduleEntry.getPath().equals(MANIFEST_PATH)) {
                return this.setManifestEntry(moduleEntry);
            }
            if (moduleEntry.getPath().equals(RESOURCES_PROTO_PATH)) {
                return this.setResourcesProtoEntry(moduleEntry);
            }
            if (moduleEntry.getPath().equals(ASSETS_PROTO_PATH)) {
                return this.setAssetsConfigEntry(moduleEntry);
            }
            if (moduleEntry.getPath().equals(NATIVE_PROTO_PATH)) {
                return this.setNativeConfigEntry(moduleEntry);
            }
            this.entriesBuilder().put((Object)Paths.get(moduleEntry.getZipEntry().getName(), new String[0]), (Object)moduleEntry);
            return this;
        }

        public abstract BundleModule build();
    }
}

