/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.tools.build.bundletool.AutoValue_ValidateBundleCommand;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.google.auto.value.AutoValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.ZipException;

@AutoValue
public abstract class ValidateBundleCommand {
    public static final String COMMAND_NAME = "validate";
    private static final Flag<Path> BUNDLE_FLAG = Flag.path("bundle");

    public abstract Path getBundlePath();

    public abstract Boolean getPrintOutput();

    public static Builder builder() {
        return new AutoValue_ValidateBundleCommand.Builder().setPrintOutput(false);
    }

    public static ValidateBundleCommand fromFlags(ParsedFlags flags) {
        Builder builder = ValidateBundleCommand.builder().setBundlePath(BUNDLE_FLAG.getRequiredValue(flags)).setPrintOutput(true);
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public AppBundle execute() throws CommandExecutionException {
        AppBundle appBundle;
        this.validateInput();
        try {
            appBundle = new AppBundleValidator().validate(this.getBundlePath());
        }
        catch (ZipException e) {
            throw new CommandExecutionException(e, "Zip error while opening the bundle", new Object[0]);
        }
        catch (FileNotFoundException e) {
            throw new CommandExecutionException(e, "Bundle file not found", new Object[0]);
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "I/O error while processing the bundle", new Object[0]);
        }
        if (this.getPrintOutput().booleanValue()) {
            this.printBundleSummary(appBundle);
        }
        return appBundle;
    }

    private void validateInput() {
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
    }

    private void printBundleSummary(AppBundle appBundle) {
        System.out.printf("App Bundle information\n", new Object[0]);
        System.out.printf("------------\n", new Object[0]);
        System.out.printf("Modules:\n", new Object[0]);
        for (Map.Entry<BundleModuleName, BundleModule> moduleEntry : appBundle.getModules().entrySet()) {
            System.out.printf("\tModule: %s\n", moduleEntry.getKey());
            this.printModuleSummary(moduleEntry.getValue());
        }
    }

    private void printModuleSummary(BundleModule bundleModule) {
        for (ModuleEntry entry : bundleModule.getEntries().values()) {
            System.out.printf("\t\tFile: %s\n", entry.getPath().toString());
        }
    }

    public static void help() {
        System.out.printf("bundletool %s --%s=<bundle.zip>\n", COMMAND_NAME, BUNDLE_FLAG);
        System.out.println("Verifies the bundle is valid and prints out information about it.");
        System.out.println();
        System.out.printf("--%s: Path to the App Bundle.\n", BUNDLE_FLAG);
    }

    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setPrintOutput(Boolean var1);

        public abstract ValidateBundleCommand build();
    }
}

