/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.DiagnosticsLevel;
import com.android.tools.r8.errors.DesugarDiagnostic;
import com.android.tools.r8.errors.UnsupportedFeatureDiagnostic;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class D8DiagnosticsHandler
implements DiagnosticsHandler {
    private final MessageReceiver messageReceiver;
    private final String toolTag;
    private final Set<String> pendingHints = new HashSet<String>();

    public D8DiagnosticsHandler(MessageReceiver messageReceiver) {
        this(messageReceiver, "D8");
    }

    public D8DiagnosticsHandler(MessageReceiver messageReceiver, String toolTag) {
        this.messageReceiver = messageReceiver;
        this.toolTag = toolTag;
    }

    public static Origin getOrigin(ClassFileEntry entry) {
        Path root = entry.getInput().getPath();
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return new ArchiveEntryOrigin(entry.getRelativePath(), new PathOrigin(root));
        }
        return new PathOrigin(root.resolve(entry.getRelativePath()));
    }

    public static Origin getOrigin(DexArchiveEntry entry) {
        Path root = entry.getDexArchive().getRootPath();
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return new ArchiveEntryOrigin(entry.getRelativePathInArchive(), new PathOrigin(root));
        }
        return new PathOrigin(root.resolve(entry.getRelativePathInArchive()));
    }

    @Override
    public void error(Diagnostic warning) {
        this.messageReceiver.receiveMessage(this.convertToMessage(Message.Kind.ERROR, warning));
    }

    @Override
    public void warning(Diagnostic warning) {
        this.messageReceiver.receiveMessage(this.convertToMessage(Message.Kind.WARNING, warning));
    }

    @Override
    public void info(Diagnostic info) {
        this.messageReceiver.receiveMessage(this.convertToMessage(Message.Kind.INFO, info));
    }

    @Override
    public DiagnosticsLevel modifyDiagnosticsLevel(DiagnosticsLevel level, Diagnostic diagnostic) {
        if (diagnostic instanceof DesugarDiagnostic) {
            return DiagnosticsLevel.INFO;
        }
        if (diagnostic instanceof UnsupportedFeatureDiagnostic) {
            return DiagnosticsLevel.ERROR;
        }
        return level;
    }

    public Set<String> getPendingHints() {
        return this.pendingHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHint(String hint) {
        Set<String> set = this.pendingHints;
        synchronized (set) {
            this.pendingHints.add(hint);
        }
    }

    protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
        String textMessage = diagnostic.getDiagnosticMessage();
        Origin origin2 = diagnostic.getOrigin();
        Position positionInOrigin = diagnostic.getPosition();
        return this.convertToMessage(kind, textMessage, origin2, positionInOrigin);
    }

    protected Message convertToMessage(Message.Kind kind, String textMessage, Origin origin2, Position positionInOrigin) {
        SourceFilePosition position;
        if (origin2 instanceof PathOrigin) {
            TextPosition endTextPosition;
            TextPosition startTextPosition;
            File originFile = ((PathOrigin)origin2).getPath().toFile();
            if (positionInOrigin instanceof TextRange) {
                TextRange textRange = (TextRange)positionInOrigin;
                startTextPosition = textRange.getStart();
                endTextPosition = textRange.getEnd();
            } else if (positionInOrigin instanceof TextPosition) {
                endTextPosition = startTextPosition = (TextPosition)positionInOrigin;
            } else {
                startTextPosition = null;
                endTextPosition = null;
            }
            if (startTextPosition != null) {
                int endColumn;
                int endLine;
                int startColumn;
                int startLine = startTextPosition.getLine();
                if (startLine != -1) {
                    --startLine;
                }
                if ((startColumn = startTextPosition.getColumn()) != -1) {
                    --startColumn;
                }
                if ((endLine = endTextPosition.getLine()) != -1) {
                    --endLine;
                }
                if ((endColumn = endTextPosition.getColumn()) != -1) {
                    --endColumn;
                }
                position = new SourceFilePosition(originFile, new SourcePosition(startLine, startColumn, D8DiagnosticsHandler.toIntOffset(startTextPosition.getOffset()), endLine, endColumn, D8DiagnosticsHandler.toIntOffset(endTextPosition.getOffset())));
            } else {
                position = new SourceFilePosition(originFile, SourcePosition.UNKNOWN);
            }
        } else if (origin2.parent() instanceof PathOrigin) {
            File originFile = ((PathOrigin)origin2.parent()).getPath().toFile();
            position = new SourceFilePosition(originFile, SourcePosition.UNKNOWN);
        } else {
            position = SourceFilePosition.UNKNOWN;
            if (origin2 != Origin.unknown()) {
                textMessage = origin2.toString() + ": " + (String)textMessage;
            }
        }
        return new Message(kind, (String)textMessage, (String)textMessage, this.toolTag, position, new SourceFilePosition[0]);
    }

    private static int toIntOffset(long offset) {
        if (offset >= 0L && offset <= Integer.MAX_VALUE) {
            return (int)offset;
        }
        return -1;
    }
}

