/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerOutput;
import com.android.builder.merge.IncrementalFileMergerState;
import com.android.ide.common.resources.FileStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class IncrementalFileMerger {
    private IncrementalFileMerger() {
    }

    public static IncrementalFileMergerState merge(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output2, IncrementalFileMergerState state, Predicate<String> noCompressPredicate) {
        IncrementalFileMergerState.Builder newState = new IncrementalFileMergerState.Builder(state);
        newState.setInputNames((List<String>)IncrementalFileMerger.getInputNames(inputs));
        List inputNames = inputs.stream().map(IncrementalFileMergerInput::getName).collect(Collectors.toList());
        try (Closer closer = Closer.create();){
            inputs.forEach(it -> {
                it.open();
                closer.register((Closeable)it);
            });
            output2.open();
            closer.register((Closeable)output2);
            if (inputNames.equals(state.getInputNames())) {
                IncrementalFileMerger.mergeNoChangedInputs(inputs, output2, state, newState, noCompressPredicate);
            } else {
                IncrementalFileMerger.mergeChangedInputs(inputs, output2, state, newState, noCompressPredicate);
            }
        }
        catch (IOException e10) {
            throw new UncheckedIOException(e10);
        }
        return newState.build();
    }

    private static void mergeNoChangedInputs(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output2, IncrementalFileMergerState state, IncrementalFileMergerState.Builder newState, Predicate<String> noCompressPredicate) {
        HashSet impactedPaths = new HashSet();
        inputs.forEach(i10 -> impactedPaths.addAll(i10.getUpdatedPaths()));
        for (String path : impactedPaths) {
            ImmutableList<String> prevInputNames = state.inputsFor(path);
            List<IncrementalFileMergerInput> inputsForFile = IncrementalFileMerger.getInputsForFile(path, inputs, state);
            IncrementalFileMerger.updateChangedFile(inputsForFile, prevInputNames, output2, path, newState, !noCompressPredicate.test(path));
        }
    }

    private static void mergeChangedInputs(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output2, IncrementalFileMergerState state, IncrementalFileMergerState.Builder newState, Predicate<String> noCompressPredicate) {
        ArrayList<String> allNames = new ArrayList<String>((Collection<String>)state.getInputNames());
        List<String> newInputNameList = inputs.stream().map(IncrementalFileMergerInput::getName).peek(n10 -> {
            if (!allNames.contains(n10)) {
                allNames.add((String)n10);
            }
        }).collect(Collectors.toList());
        newState.setInputNames(allNames);
        HashSet maybeImpactedPaths = new HashSet();
        state.getInputNames().forEach(n10 -> maybeImpactedPaths.addAll(state.filesOf((String)n10)));
        inputs.forEach(i10 -> maybeImpactedPaths.addAll(i10.getUpdatedPaths()));
        for (String path : maybeImpactedPaths) {
            ImmutableList<String> prevInputNames = state.inputsFor(path);
            List<IncrementalFileMergerInput> inputsForFile = IncrementalFileMerger.getInputsForFile(path, inputs, state);
            boolean changed = false;
            if (prevInputNames.size() != inputsForFile.size()) {
                changed = true;
            }
            for (int i11 = 0; !changed && i11 < prevInputNames.size(); ++i11) {
                if (((String)prevInputNames.get(i11)).equals(inputsForFile.get(i11).getName())) continue;
                changed = true;
            }
            if (!changed && inputsForFile.stream().anyMatch(i10 -> i10.getFileStatus(path) != null)) {
                changed = true;
            }
            if (!changed) continue;
            IncrementalFileMerger.updateChangedFile(inputsForFile, prevInputNames, output2, path, newState, !noCompressPredicate.test(path));
        }
        newState.setInputNames(newInputNameList);
    }

    private static void updateChangedFile(List<IncrementalFileMergerInput> inputsForFile, ImmutableList<String> prevInputNames, IncrementalFileMergerOutput output2, String path, IncrementalFileMergerState.Builder newState, boolean compress) {
        if (inputsForFile.isEmpty()) {
            output2.remove(path);
            newState.remove(path);
        } else if (prevInputNames.isEmpty()) {
            output2.create(path, (List<IncrementalFileMergerInput>)ImmutableList.copyOf(inputsForFile), compress);
            newState.set(path, (List<String>)IncrementalFileMerger.getInputNames(inputsForFile));
        } else {
            output2.update(path, (List<String>)prevInputNames, (List<IncrementalFileMergerInput>)ImmutableList.copyOf(inputsForFile), compress);
            newState.set(path, (List<String>)IncrementalFileMerger.getInputNames(inputsForFile));
        }
    }

    private static List<IncrementalFileMergerInput> getInputsForFile(String path, List<IncrementalFileMergerInput> inputs, IncrementalFileMergerState state) {
        return inputs.stream().filter(i10 -> {
            FileStatus status = i10.getFileStatus(path);
            if (status != null) {
                return status != FileStatus.REMOVED;
            }
            if (state.getInputNames().isEmpty()) {
                return false;
            }
            if (state.getInputNames().contains((Object)i10.getName())) {
                return state.inputsFor(path).contains((Object)i10.getName());
            }
            return i10.getAllPaths().contains((Object)path);
        }).collect(Collectors.toList());
    }

    private static ImmutableList<String> getInputNames(List<IncrementalFileMergerInput> inputs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        inputs.forEach(i10 -> builder.add((Object)i10.getName()));
        return builder.build();
    }
}

