/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForRetraceApi;
import com.android.tools.r8.internal.Cm;
import com.android.tools.r8.internal.Fm;
import com.android.tools.r8.internal.TX;
import com.android.tools.r8.internal.le;
import com.android.tools.r8.internal.r2;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.references.PrimitiveReference;
import com.android.tools.r8.references.TypeReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

@Keep
@KeepForRetraceApi
public final class Reference {
    public static PrimitiveReference BOOL = PrimitiveReference.a;
    public static PrimitiveReference BYTE = PrimitiveReference.b;
    public static PrimitiveReference CHAR = PrimitiveReference.c;
    public static PrimitiveReference SHORT = PrimitiveReference.d;
    public static PrimitiveReference INT = PrimitiveReference.e;
    public static PrimitiveReference FLOAT = PrimitiveReference.f;
    public static PrimitiveReference LONG = PrimitiveReference.g;
    public static PrimitiveReference DOUBLE = PrimitiveReference.h;

    public static TypeReference returnTypeFromDescriptor(String descriptor) {
        String string;
        return descriptor.equals("V") ? null : Reference.typeFromDescriptor(string);
    }

    public static TypeReference returnTypeFromTypeName(String typename) {
        String string;
        return typename.equals("void") ? null : Reference.typeFromTypeName(string);
    }

    public static TypeReference typeFromDescriptor(String descriptor) {
        String string;
        char c10 = descriptor.charAt(0);
        if (c10 != 'L') {
            if (c10 != '[') {
                return Reference.primitiveFromDescriptor(string);
            }
            return Reference.arrayFromDescriptor(string);
        }
        return Reference.classFromDescriptor(string);
    }

    public static TypeReference typeFromTypeName(String typeName) {
        return Reference.typeFromDescriptor(le.z(typeName));
    }

    private static TypeReference a(Class clazz) {
        return Reference.typeFromDescriptor(le.z(clazz.getTypeName()));
    }

    public static PrimitiveReference primitiveFromDescriptor(String descriptor) {
        PrimitiveReference primitiveReference;
        String string;
        if (!PrimitiveReference.i && string.length() != 1) {
            throw new AssertionError();
        }
        switch (string.charAt(0)) {
            default: {
                throw new TX(r2.a("Invalid primitive descriptor: ", string));
            }
            case 'Z': {
                primitiveReference = PrimitiveReference.a;
                break;
            }
            case 'S': {
                primitiveReference = PrimitiveReference.d;
                break;
            }
            case 'J': {
                primitiveReference = PrimitiveReference.g;
                break;
            }
            case 'I': {
                primitiveReference = PrimitiveReference.e;
                break;
            }
            case 'F': {
                primitiveReference = PrimitiveReference.f;
                break;
            }
            case 'D': {
                primitiveReference = PrimitiveReference.h;
                break;
            }
            case 'C': {
                primitiveReference = PrimitiveReference.c;
                break;
            }
            case 'B': {
                primitiveReference = PrimitiveReference.b;
            }
        }
        return primitiveReference;
    }

    public static ClassReference classFromDescriptor(String descriptor) {
        return ClassReference.a(descriptor);
    }

    public static ClassReference classFromBinaryName(String binaryName) {
        return Reference.classFromDescriptor(le.k(binaryName));
    }

    public static ClassReference classFromTypeName(String typeName) {
        return Reference.classFromDescriptor(le.z(typeName));
    }

    public static ClassReference classFromClass(Class<?> clazz) {
        return Reference.classFromTypeName(clazz.getTypeName());
    }

    public static ArrayReference arrayFromDescriptor(String descriptor) {
        return ArrayReference.a(descriptor);
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayReference array(TypeReference baseType, int dimensions) {
        void var1_1;
        return ArrayReference.a(baseType, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodReference method(ClassReference holderClass, String methodName, List<TypeReference> formalTypes, TypeReference returnType) {
        void var3_3;
        void var1_1;
        ClassReference classReference;
        Fm fm2;
        fm2 = Fm.a(fm2);
        return new MethodReference(classReference, (String)var1_1, fm2, (TypeReference)var3_3);
    }

    public static MethodReference methodFromMethod(Method method) {
        Object object;
        Method method2 = method;
        String string = method2.getName();
        Object object2 = method2.getDeclaringClass();
        Object object3 = method2.getParameterTypes();
        object = ((Method)object).getReturnType();
        Cm cm2 = Fm.g();
        int n10 = ((Class<?>[])object3).length;
        for (int i10 = 0; i10 < n10; ++i10) {
            cm2.b(Reference.a(object3[i10]));
        }
        object2 = Reference.classFromClass(object2);
        object3 = cm2.a();
        object = object == Void.TYPE ? null : Reference.a((Class)object);
        return Reference.method((ClassReference)object2, string, object3, (TypeReference)object);
    }

    public static MethodReference methodFromMethod(Constructor<?> method) {
        Constructor<?> constructor = method;
        GenericDeclaration genericDeclaration = constructor.getDeclaringClass();
        Class<?>[] classArray = constructor.getParameterTypes();
        Cm cm2 = Fm.g();
        int n10 = classArray.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            cm2.b(Reference.a(classArray[i10]));
        }
        return Reference.method(Reference.classFromClass(genericDeclaration), "<init>", cm2.a(), null);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodReference methodFromDescriptor(String classDescriptor, String methodName, String methodDescriptor) {
        void var1_1;
        ClassReference classReference;
        Object object;
        Object object2 = Fm.g();
        String[] stringArray = le.e(methodDescriptor);
        int n10 = stringArray.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            ((Cm)object2).b(Reference.typeFromDescriptor(stringArray[i10]));
        }
        object = le.r((String)object);
        classReference = Reference.classFromDescriptor((String)((Object)classReference));
        object2 = ((Cm)object2).a();
        object = ((String)object).equals("V") ? null : Reference.typeFromDescriptor((String)object);
        return Reference.method(classReference, (String)var1_1, (List<TypeReference>)object2, (TypeReference)object);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodReference methodFromDescriptor(ClassReference classReference, String methodName, String methodDescriptor) {
        void var1_1;
        ClassReference classReference2;
        Object object;
        Object object2 = Fm.g();
        String[] stringArray = le.e(methodDescriptor);
        int n10 = stringArray.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            ((Cm)object2).b(Reference.typeFromDescriptor(stringArray[i10]));
        }
        object = le.r((String)object);
        object2 = ((Cm)object2).a();
        object = ((String)object).equals("V") ? null : Reference.typeFromDescriptor((String)object);
        return Reference.method(classReference2, (String)var1_1, (List<TypeReference>)object2, (TypeReference)object);
    }

    public static MethodReference classConstructor(ClassReference type) {
        return Reference.method(type, "<clinit>", Collections.emptyList(), null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldReference field(ClassReference holderClass, String fieldName, TypeReference fieldType) {
        void var2_2;
        void var1_1;
        ClassReference classReference;
        return new FieldReference(classReference, (String)var1_1, (TypeReference)var2_2);
    }

    public static FieldReference fieldFromField(Field field) {
        Field field2 = field;
        AnnotatedElement annotatedElement = field2.getDeclaringClass();
        String string = field2.getName();
        Class<?> clazz = field2.getType();
        return Reference.field(Reference.classFromClass(annotatedElement), string, Reference.a(clazz));
    }

    public static PackageReference packageFromString(String packageName) {
        String string;
        return new PackageReference(string);
    }

    public static PackageReference packageFromPackage(Package pkg) {
        Package package_;
        return new PackageReference(package_.getName());
    }
}

