/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.errors.IssueReporter;
import com.android.manifmerger.PlaceholderHandler;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class DefaultManifestParser
implements ManifestAttributeSupplier {
    private static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final Object lock;
    private final File manifestFile;
    private final Map<Attribute, String> attributeValues = Maps.newEnumMap(Attribute.class);
    private final IssueReporter issueReporter;
    private boolean initialized = false;
    private BooleanSupplier canParseManifest;
    private boolean isManifestFileRequired;

    public DefaultManifestParser(File manifestFile, BooleanSupplier canParseManifest, boolean isManifestFileRequired, IssueReporter issueReporter) {
        this.manifestFile = manifestFile;
        this.canParseManifest = canParseManifest;
        this.isManifestFileRequired = isManifestFileRequired;
        this.issueReporter = issueReporter;
    }

    @Override
    public boolean isManifestFileRequired() {
        return this.isManifestFileRequired;
    }

    @Override
    public String getPackage() {
        this.init();
        return this.attributeValues.get((Object)Attribute.PACKAGE);
    }

    @Override
    public String getSplit() {
        this.init();
        return this.attributeValues.get((Object)Attribute.SPLIT);
    }

    @Override
    public Object getMinSdkVersion() {
        this.init();
        String minSdkVersion = this.attributeValues.get((Object)Attribute.MIN_SDK_VERSION);
        return DefaultManifestParser.parseIntValueOrDefault(minSdkVersion, minSdkVersion, null);
    }

    @Override
    public Object getTargetSdkVersion() {
        this.init();
        String targetSdkVersion = this.attributeValues.get((Object)Attribute.TARGET_SDK_VERSION);
        return DefaultManifestParser.parseIntValueOrDefault(targetSdkVersion, targetSdkVersion, null);
    }

    @Override
    public String getInstrumentationRunner() {
        this.init();
        return this.attributeValues.get((Object)Attribute.INST_NAME);
    }

    @Override
    public String getTargetPackage() {
        this.init();
        return this.attributeValues.get((Object)Attribute.INST_TARGET_PKG);
    }

    @Override
    public Boolean getFunctionalTest() {
        this.init();
        String functionalTest = this.attributeValues.get((Object)Attribute.INST_FUNCTIONAL_TEST);
        return DefaultManifestParser.parseBoolean(functionalTest);
    }

    @Override
    public Boolean getHandleProfiling() {
        this.init();
        String handleProfiling = this.attributeValues.get((Object)Attribute.INST_HANDLE_PROF);
        return DefaultManifestParser.parseBoolean(handleProfiling);
    }

    @Override
    public String getTestLabel() {
        this.init();
        return this.attributeValues.get((Object)Attribute.INST_LABEL);
    }

    @Override
    public Boolean getExtractNativeLibs() {
        this.init();
        String extractNativeLibs = this.attributeValues.get((Object)Attribute.APP_EXTRACT_NATIVE_LIBS);
        return DefaultManifestParser.parseBoolean(extractNativeLibs);
    }

    @Override
    public Boolean getUseEmbeddedDex() {
        this.init();
        String useEmbeddedDex = this.attributeValues.get((Object)Attribute.APP_USE_EMBEDDED_DEX);
        return DefaultManifestParser.parseBoolean(useEmbeddedDex);
    }

    private static Object parseIntValueOrDefault(String value, Object ifNotInt, Object ifNull) {
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ignored) {
                return ifNotInt;
            }
        }
        return ifNull;
    }

    private static Boolean parseBoolean(String value) {
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = lock;
        synchronized (object) {
            if (!this.canParseManifest.getAsBoolean() && this.issueReporter != null) {
                String stackTrace = Joiner.on((String)"\n").join((Object[])Thread.currentThread().getStackTrace());
                this.issueReporter.reportWarning(IssueReporter.Type.MANIFEST_PARSED_DURING_CONFIGURATION, "The manifest is being parsed during configuration. Please either remove android.disableConfigurationManifestParsing from build.gradle or remove any build configuration rules that read the android manifest file.\n" + stackTrace);
            }
            if (!this.initialized) {
                if (!this.manifestFile.isFile()) {
                    if (this.isManifestFileRequired) {
                        throw new RuntimeException("Manifest file does not exist: " + this.manifestFile.getAbsolutePath());
                    }
                    return;
                }
                DefaultHandler handler = new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (uri == null || uri.isEmpty()) {
                            if ("manifest".equals(localName)) {
                                DefaultManifestParser.this.putValue(Attribute.SPLIT, attributes.getValue("", "split"));
                                DefaultManifestParser.this.putValue(Attribute.PACKAGE, attributes.getValue("", "package"));
                                DefaultManifestParser.this.putValue(Attribute.VERSION_CODE, attributes.getValue("http://schemas.android.com/apk/res/android", "versionCode"));
                                DefaultManifestParser.this.putValue(Attribute.VERSION_NAME, attributes.getValue("http://schemas.android.com/apk/res/android", "versionName"));
                            } else if ("instrumentation".equals(localName)) {
                                DefaultManifestParser.this.putValue(Attribute.INST_LABEL, attributes.getValue("http://schemas.android.com/apk/res/android", "label"));
                                DefaultManifestParser.this.putValue(Attribute.INST_FUNCTIONAL_TEST, attributes.getValue("http://schemas.android.com/apk/res/android", "functionalTest"));
                                DefaultManifestParser.this.putValue(Attribute.INST_NAME, attributes.getValue("http://schemas.android.com/apk/res/android", "name"));
                                DefaultManifestParser.this.putValue(Attribute.INST_HANDLE_PROF, attributes.getValue("http://schemas.android.com/apk/res/android", "handleProfiling"));
                                DefaultManifestParser.this.putValue(Attribute.INST_TARGET_PKG, attributes.getValue("http://schemas.android.com/apk/res/android", "targetPackage"));
                            } else if ("uses-sdk".equals(localName)) {
                                DefaultManifestParser.this.putValue(Attribute.MIN_SDK_VERSION, attributes.getValue("http://schemas.android.com/apk/res/android", "minSdkVersion"));
                                DefaultManifestParser.this.putValue(Attribute.TARGET_SDK_VERSION, attributes.getValue("http://schemas.android.com/apk/res/android", "targetSdkVersion"));
                            } else if ("application".equals(localName)) {
                                DefaultManifestParser.this.putValue(Attribute.APP_EXTRACT_NATIVE_LIBS, attributes.getValue("http://schemas.android.com/apk/res/android", "extractNativeLibs"));
                                DefaultManifestParser.this.putValue(Attribute.APP_USE_EMBEDDED_DEX, attributes.getValue("http://schemas.android.com/apk/res/android", "useEmbeddedDex"));
                            }
                        }
                    }
                };
                try {
                    SAXParser saxParser = XmlUtils.createSaxParser((SAXParserFactory)PARSER_FACTORY);
                    saxParser.parse(this.manifestFile, handler);
                    this.initialized = true;
                }
                catch (Exception e10) {
                    throw new RuntimeException(e10);
                }
            }
        }
    }

    private void putValue(Attribute attribute, String value) {
        if (value != null && !PlaceholderHandler.isPlaceHolder((String)value)) {
            this.attributeValues.put(attribute, value);
        }
    }

    static {
        XmlUtils.configureSaxFactory((SAXParserFactory)PARSER_FACTORY, (boolean)true, (boolean)false);
        lock = new Object();
    }

    static enum Attribute {
        SPLIT,
        PACKAGE,
        VERSION_CODE,
        VERSION_NAME,
        INST_LABEL,
        INST_FUNCTIONAL_TEST,
        INST_NAME,
        INST_HANDLE_PROF,
        INST_TARGET_PKG,
        MIN_SDK_VERSION,
        TARGET_SDK_VERSION,
        APP_EXTRACT_NATIVE_LIBS,
        APP_USE_EMBEDDED_DEX;

    }
}

