/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\t\u001a\u00020\f\u00a8\u0006\r"}, d2={"getNoCompressRegex", "", "noCompressList", "", "makeCompileCommand", "Lcom/google/common/collect/ImmutableList;", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "makeConvertCommand", "config", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "makeLinkCommand", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "builder"})
@JvmName(name="AaptV2CommandBuilder")
public final class AaptV2CommandBuilder {
    @NotNull
    public static final ImmutableList<String> makeCompileCommand(@NotNull CompileResourceRequest request) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        if (request.isPseudoLocalize()) {
            parameters.add((Object)"--pseudo-localize");
        }
        if (!request.isPngCrunching()) {
            String string = request.getInputFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.inputFile.path");
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            boolean bl2 = false;
            String string2 = string;
            boolean bl3 = false;
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
            String lowerName = string3;
            if (StringsKt.endsWith$default((String)lowerName, (String)".png", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)lowerName, (String)".9.png", (boolean)false, (int)2, null)) {
                parameters.add((Object)"--no-crunch");
            }
        }
        if (request.getPartialRFile() != null) {
            stringArray = new String[2];
            stringArray[0] = "--output-text-symbols";
            File file = request.getPartialRFile();
            Intrinsics.checkNotNull((Object)file);
            stringArray[1] = file.getAbsolutePath();
            parameters.add((Object[])stringArray);
        }
        parameters.add((Object)"--legacy");
        stringArray = new String[]{"-o", request.getOutputDirectory().getAbsolutePath()};
        parameters.add((Object[])stringArray);
        parameters.add((Object)request.getInputFile().getAbsolutePath());
        stringArray = request.getSourcePath();
        boolean bl4 = false;
        boolean bl5 = false;
        Object it2 = stringArray;
        boolean bl6 = false;
        parameters.add((Object)"--source-path");
        parameters.add(it2);
        stringArray = parameters.build();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parameters.build()");
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<String> makeLinkCommand(@NotNull AaptPackageConfig config) throws AaptException {
        Iterable<String> densityResSplits;
        List<String> additionalParameters;
        Object splitter;
        Object[] split2;
        Object[] e102;
        Object[] objectArray;
        File resourceOutputApk;
        ImmutableList.Builder builder;
        block64: {
            Object[] objectArray2;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            builder = ImmutableList.builder();
            if (config.getVerbose()) {
                builder.add((Object)"-v");
            }
            if (config.getGenerateProtos()) {
                builder.add((Object)"--proto-format");
            }
            if (config.getExcludeSources()) {
                if (!config.getGenerateProtos()) {
                    throw new AaptException("AAPT2 only supports excluding sources when building for a bundle.");
                }
                builder.add((Object)"--exclude-sources");
            }
            if (config.getMergeOnly()) {
                builder.add((Object)"--merge-only");
            } else {
                Object[] objectArray3 = new String[]{"-I", (String)Preconditions.checkNotNull((Object)config.getAndroidJarPath())};
                builder.add(objectArray3);
            }
            Iterable $this$forEach$iv = (Iterable)config.getImports();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                objectArray2 = new String[]{"-I", file.getAbsolutePath()};
                builder.add(objectArray2);
            }
            File manifestFile = config.getManifestFile();
            Preconditions.checkNotNull((Object)manifestFile);
            Object[] $i$f$forEach22 = new String[]{"--manifest", manifestFile.getAbsolutePath()};
            builder.add($i$f$forEach22);
            resourceOutputApk = config.getResourceOutputApk();
            FileUtils.mkdirs((File)resourceOutputApk.getParentFile());
            Object[] objectArray4 = new String[]{"-o", resourceOutputApk.getAbsolutePath()};
            builder.add(objectArray4);
            if (!config.getResourceDirs().isEmpty()) {
                try {
                    if (config.isListResourceFiles()) {
                        Object element$iv;
                        File file = config.getIntermediateDir();
                        Intrinsics.checkNotNull((Object)file);
                        File resourceListFile = new File(file, "resources-list-for-" + resourceOutputApk.getName() + ".txt");
                        FileUtils.deleteIfExists((File)resourceListFile);
                        Files.createDirectories(config.getIntermediateDir().toPath(), new FileAttribute[0]);
                        for (Object dir2 : config.getResourceDirs()) {
                            Closeable bl2 = new FileOutputStream(resourceListFile);
                            boolean bl3 = false;
                            boolean bl4 = false;
                            Throwable throwable = null;
                            try {
                                FileOutputStream fos = (FileOutputStream)bl2;
                                boolean bl5 = false;
                                Closeable closeable = new PrintWriter(fos);
                                int n10 = 0;
                                boolean bl6 = false;
                                objectArray = null;
                                try {
                                    void $this$forEach$iv2;
                                    Iterable $this$sortedBy$iv;
                                    void $this$filterTo$iv$iv;
                                    Iterable $this$filter$iv;
                                    PrintWriter pw2 = (PrintWriter)closeable;
                                    boolean bl7 = false;
                                    Object[] objectArray5 = ((File)dir2).listFiles();
                                    Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"dir.listFiles()");
                                    objectArray5 = objectArray5;
                                    boolean $i$f$filter = false;
                                    Iterator iterator = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList();
                                    boolean $i$f$filterTo = false;
                                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                                        File it2 = (File)element$iv$iv;
                                        boolean bl8 = false;
                                        if (!it2.isFile()) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    boolean $i$f$sortedBy = false;
                                    boolean bl9 = false;
                                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                        public final int compare(T a10, T b10) {
                                            boolean bl2 = false;
                                            File it2 = (File)a10;
                                            boolean bl3 = false;
                                            Comparable comparable = (Comparable)((Object)it2.getPath());
                                            it2 = (File)b10;
                                            Comparable comparable2 = comparable;
                                            bl3 = false;
                                            String string = it2.getPath();
                                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                                        }
                                    });
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv2 : $this$forEach$iv2) {
                                        File it3 = (File)element$iv2;
                                        boolean bl10 = false;
                                        pw2.print(Intrinsics.stringPlus((String)it3.getAbsolutePath(), (Object)" "));
                                    }
                                    pw2 = Unit.INSTANCE;
                                }
                                catch (Throwable pw2) {
                                    objectArray = pw2;
                                    throw pw2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)objectArray);
                                }
                                fos = Unit.INSTANCE;
                            }
                            catch (Throwable fos) {
                                throwable = fos;
                                throw fos;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)bl2, (Throwable)throwable);
                            }
                        }
                        element$iv = new String[]{"-R", Intrinsics.stringPlus((String)"@", (Object)resourceListFile.getAbsolutePath())};
                        builder.add(element$iv);
                        break block64;
                    }
                    for (File dir : config.getResourceDirs()) {
                        void $this$forEach$iv3;
                        Iterable $this$sortedBy$iv;
                        Iterator $this$filterTo$iv$iv22;
                        Iterable $this$filter$iv;
                        Object dir2;
                        dir2 = dir.listFiles();
                        Intrinsics.checkNotNullExpressionValue((Object)dir2, (String)"dir.listFiles()");
                        dir2 = (Object[])dir2;
                        boolean $i$f$filter = false;
                        objectArray2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (void element$iv$iv : $this$filterTo$iv$iv22) {
                            File it4 = (File)element$iv$iv;
                            boolean bl11 = false;
                            if (!it4.isFile()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$sortedBy = false;
                        boolean $this$filterTo$iv$iv22 = false;
                        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a10, T b10) {
                                boolean bl2 = false;
                                File it2 = (File)a10;
                                boolean bl3 = false;
                                Comparable comparable = (Comparable)((Object)it2.getPath());
                                it2 = (File)b10;
                                Comparable comparable2 = comparable;
                                bl3 = false;
                                String string = it2.getPath();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                            }
                        });
                        boolean $i$f$forEach = false;
                        $this$filterTo$iv$iv22 = $this$forEach$iv3.iterator();
                        while ($this$filterTo$iv$iv22.hasNext()) {
                            Object element$iv = $this$filterTo$iv$iv22.next();
                            File it5 = (File)element$iv;
                            boolean bl12 = false;
                            Object[] objectArray6 = new String[]{"-R", it5.getAbsolutePath()};
                            builder.add(objectArray6);
                        }
                    }
                }
                catch (IOException e102) {
                    throw new AaptException(Intrinsics.stringPlus((String)"Failed to walk paths ", (Object)Joiner.on((char)File.pathSeparatorChar).join((Iterable)config.getResourceDirs())), e102);
                }
            }
        }
        builder.add((Object)"--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            e102 = new Object[]{"--java", config.getSourceOutputDir().getAbsolutePath()};
            builder.add(e102);
        }
        if (config.getProguardOutputFile() != null) {
            e102 = new String[]{"--proguard", config.getProguardOutputFile().getAbsolutePath()};
            builder.add(e102);
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            e102 = new String[]{"--proguard-main-dex", config.getMainDexListProguardOutputFile().getAbsolutePath()};
            builder.add(e102);
        }
        if (config.getSplits() != null) {
            for (Object[] split2 : config.getSplits()) {
                splitter = File.pathSeparator;
                Object[] $i$f$forEach = new String[]{"--split", resourceOutputApk.toString() + '_' + split2 + splitter + split2};
                builder.add($i$f$forEach);
            }
        }
        if (!config.getVariantType().isNestedComponent() && config.getCustomPackageForR() != null) {
            e102 = new String[]{"--custom-package", config.getCustomPackageForR()};
            builder.add(e102);
        }
        boolean generateFinalIds = true;
        if (config.getVariantType().isAar()) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.add((Object)"--non-final-ids");
        }
        split2 = new String[]{"-0", "apk"};
        builder.add(split2);
        Collection<String> noCompressList = Objects.requireNonNull(config.getOptions()).getNoCompress();
        if (noCompressList != null) {
            splitter = noCompressList;
            boolean $i$f$forEach = false;
            if (!splitter.isEmpty()) {
                boolean bl13;
                Object[] $this$any$iv;
                block65: {
                    $this$any$iv = (Object[])noCompressList;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl13 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it6 = (String)element$iv;
                            boolean bl14 = false;
                            if (!Strings.isNullOrEmpty((String)it6)) continue;
                            bl13 = true;
                            break block65;
                        }
                        bl13 = false;
                    }
                }
                if (bl13) {
                    builder.add((Object)"--no-compress");
                } else {
                    $this$any$iv = new String[]{"--no-compress-regex", AaptV2CommandBuilder.getNoCompressRegex(noCompressList)};
                    builder.add($this$any$iv);
                }
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addAll((Iterable)additionalParameters);
        }
        ArrayList resourceConfigs = new ArrayList((Collection)config.getResourceConfigs());
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        String preferredDensity = config.getPreferredDensity();
        Iterable<String> iterable = densityResSplits = config.getSplits() != null ? AaptUtils.getDensityResConfigs((Iterable)config.getSplits()) : (Iterable<String>)ImmutableList.of();
        if ((preferredDensity != null || densityResSplits.iterator().hasNext()) && !densityResourceConfigs.isEmpty()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle";
            objectArray = new Object[]{Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)};
            boolean bl15 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new AaptException(string2);
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.");
        }
        if (!otherResourceConfigs.isEmpty() && config.getSplits() != null) {
            Iterable<String> nonDensitySplits = AaptUtils.getNonDensityResConfigs((Iterable)config.getSplits());
            otherResourceConfigs.addAll(Lists.newArrayList(nonDensitySplits));
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            Object[] objectArray7 = new String[]{"-c", joiner.join((Iterable)otherResourceConfigs)};
            builder.add(objectArray7);
        }
        if (preferredDensity != null) {
            Object[] joiner = new String[]{"--preferred-density", preferredDensity};
            builder.add(joiner);
        }
        if (config.getSymbolOutputDir() != null) {
            File rDotTxt = new File(config.getSymbolOutputDir(), "R.txt");
            Object[] objectArray8 = new String[]{"--output-text-symbols", rDotTxt.getAbsolutePath()};
            builder.add(objectArray8);
        }
        if (config.getPackageId() != null) {
            if (config.getAllowReservedPackageId()) {
                builder.add((Object)"--allow-reserved-package-id");
            }
            String[] stringArray = new String[]{"--package-id", Intrinsics.stringPlus((String)"0x", (Object)Integer.toHexString(config.getPackageId()))};
            builder.add((Object[])stringArray);
            for (File dependentFeature : config.getDependentFeatures()) {
                objectArray = new String[]{"-I", dependentFeature.getAbsolutePath()};
                builder.add(objectArray);
            }
        } else if (!config.getDependentFeatures().isEmpty()) {
            throw new AaptException("Dependent features configured but no package ID was set.");
        }
        builder.add((Object)"--no-version-vectors");
        if (config.getUseConditionalKeepRules()) {
            builder.add((Object)"--proguard-conditional-keep-rules");
        }
        if (config.getUseMinimalKeepRules()) {
            builder.add((Object)"--proguard-minimal-keep-rules");
        }
        if (config.isStaticLibrary()) {
            builder.add((Object)"--static-lib");
            if (!config.getStaticLibraryDependencies().isEmpty()) {
                throw new AaptException("Static libraries to link against should be passed as imports");
            }
        } else {
            for (File file : config.getStaticLibraryDependencies()) {
                builder.add((Object)file.getAbsolutePath());
            }
        }
        builder.add((Object)"--no-proguard-location-reference");
        if (config.getEmitStableIdsFile() != null) {
            Object[] objectArray9 = new String[]{"--emit-ids", config.getEmitStableIdsFile().getAbsolutePath()};
            builder.add(objectArray9);
        }
        if (config.getConsumeStableIdsFile() != null) {
            Object[] objectArray10 = new String[]{"--stable-ids", config.getConsumeStableIdsFile().getAbsolutePath()};
            builder.add(objectArray10);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    @NotNull
    public static final ImmutableList<String> makeConvertCommand(@NotNull AaptConvertConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"--output-format");
        if (config.getConvertToProtos()) {
            builder.add((Object)"proto");
        } else {
            builder.add((Object)"binary");
        }
        FileUtils.mkdirs((File)config.getOutputFile().getParentFile());
        builder.add((Object)"-o").add((Object)config.getOutputFile().getAbsolutePath());
        builder.add((Object)config.getInputFile().getAbsolutePath());
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    private static final String getNoCompressRegex(Collection<String> noCompressList) {
        return "((" + Joiner.on((String)"$)|(").join((Iterable)PackagingUtils.getNoCompressForAapt(noCompressList)) + "$))";
    }
}

