/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.NativeLibraryAbiPredicate;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.internal.packaging.ApkFlinger;
import com.android.builder.internal.packaging.DexIncrementalRenameManager;
import com.android.builder.internal.packaging.PackagedFileUpdate;
import com.android.builder.internal.packaging.PackagedFileUpdates;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kotlin.text.StringsKt;

public class IncrementalPackager
implements Closeable {
    private ApkCreator mApkCreator;
    private final ApkCreatorFactory.CreationData mCreationData;
    private final ApkCreatorFactory mApkCreatorFactory;
    private boolean mIsDebuggableBuild;
    private boolean mClosed;
    private final ApkCreatorType mApkCreatorType;
    private final DexIncrementalRenameManager mDexRenamer;
    private final NativeLibraryAbiPredicate mAbiPredicate;
    private final Map<RelativeFile, FileStatus> mChangedDexFiles;
    private final Map<RelativeFile, FileStatus> mChangedJavaResources;
    private final List<SerializableChange> mChangedAssets;
    private final Map<RelativeFile, FileStatus> mChangedAndroidResources;
    private final Map<RelativeFile, FileStatus> mChangedNativeLibs;

    private ApkCreator getApkCreator() {
        if (this.mApkCreator == null) {
            switch (this.mApkCreatorType) {
                case APK_Z_FILE_CREATOR: {
                    this.mApkCreator = this.mApkCreatorFactory.make(this.mCreationData);
                    break;
                }
                case APK_FLINGER: {
                    int compressionLevel = this.mIsDebuggableBuild ? 1 : -1;
                    this.mApkCreator = new ApkFlinger(this.mCreationData, compressionLevel, !this.mIsDebuggableBuild);
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected apkCreatorType");
                }
            }
        }
        return this.mApkCreator;
    }

    public IncrementalPackager(ApkCreatorFactory.CreationData creationData, File intermediateDir, ApkCreatorFactory factory, boolean apkFormatIsFile, Set<String> acceptedAbis, boolean jniDebugMode, boolean debuggableBuild, ApkCreatorType apkCreatorType, Map<RelativeFile, FileStatus> changedDexFiles, Map<RelativeFile, FileStatus> changedJavaResources, List<SerializableChange> changedAssets, Map<RelativeFile, FileStatus> changedAndroidResources, Map<RelativeFile, FileStatus> changedNativeLibs) throws IOException {
        if (!intermediateDir.isDirectory()) {
            throw new IllegalArgumentException("!intermediateDir.isDirectory(): " + intermediateDir);
        }
        IncrementalPackager.checkOutputFile(creationData.getApkPath());
        this.mCreationData = creationData;
        this.mApkCreatorFactory = factory;
        this.mIsDebuggableBuild = debuggableBuild;
        this.mClosed = false;
        this.mApkCreatorType = !apkFormatIsFile ? ApkCreatorType.APK_Z_FILE_CREATOR : apkCreatorType;
        this.mChangedDexFiles = changedDexFiles;
        this.mChangedJavaResources = changedJavaResources;
        this.mChangedAssets = changedAssets;
        this.mChangedAndroidResources = changedAndroidResources;
        this.mChangedNativeLibs = changedNativeLibs;
        this.mDexRenamer = new DexIncrementalRenameManager(intermediateDir);
        this.mAbiPredicate = new NativeLibraryAbiPredicate(acceptedAbis, jniDebugMode);
    }

    public void updateFiles() throws IOException {
        ArrayList<PackagedFileUpdate> packagedFileUpdates = new ArrayList<PackagedFileUpdate>();
        packagedFileUpdates.addAll(this.mDexRenamer.update(this.mChangedDexFiles));
        packagedFileUpdates.addAll(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(this.mChangedJavaResources, rf -> !rf.getRelativePath().endsWith(".class"))));
        packagedFileUpdates.addAll(PackagedFileUpdates.fromIncrementalRelativeFileSet(this.mChangedAndroidResources));
        packagedFileUpdates.addAll(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(this.mChangedNativeLibs, rf -> this.mAbiPredicate.test(rf.getRelativePath()))));
        this.deleteFiles(packagedFileUpdates);
        this.updateSingleEntryJars(this.mChangedAssets);
        this.addFiles(packagedFileUpdates);
    }

    private void updateSingleEntryJars(Collection<SerializableChange> changes) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"IncrementalPackager has already been closed.");
        Predicate<SerializableChange> deletePredicate = this.mApkCreatorType == ApkCreatorType.APK_FLINGER ? it -> it.getFileStatus() == FileStatus.REMOVED || it.getFileStatus() == FileStatus.CHANGED : it -> it.getFileStatus() == FileStatus.REMOVED;
        Iterable deletedJars = changes.stream().filter(deletePredicate).map(SerializableChange::getNormalizedPath).collect(Collectors.toList());
        for (String deletedJar : deletedJars) {
            Preconditions.checkState((boolean)deletedJar.endsWith(".jar"));
            this.getApkCreator().deleteFile(StringsKt.removeSuffix((String)deletedJar, (CharSequence)".jar"));
        }
        Predicate<SerializableChange> isNewOrChanged = it -> it.getFileStatus() == FileStatus.NEW || it.getFileStatus() == FileStatus.CHANGED;
        Iterable addedJars = changes.stream().filter(isNewOrChanged).map(SerializableChange::getFile).collect(Collectors.toList());
        for (File addedJar : addedJars) {
            this.getApkCreator().writeZip(addedJar, null, null);
        }
    }

    private void deleteFiles(Collection<PackagedFileUpdate> updates) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"IncrementalPackager has already been closed.");
        Predicate<PackagedFileUpdate> deletePredicate = this.mApkCreatorType == ApkCreatorType.APK_FLINGER ? p4 -> p4.getStatus() == FileStatus.REMOVED || p4.getStatus() == FileStatus.CHANGED : p4 -> p4.getStatus() == FileStatus.REMOVED;
        Iterable deletedPaths = updates.stream().filter(deletePredicate).map(PackagedFileUpdate::getName).collect(Collectors.toList());
        for (String deletedPath : deletedPaths) {
            this.getApkCreator().deleteFile(deletedPath);
        }
    }

    private void addFiles(Collection<PackagedFileUpdate> updates) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"IncrementalPackager has already been closed.");
        Predicate<PackagedFileUpdate> isNewOrChanged = pfu -> pfu.getStatus() == FileStatus.NEW || pfu.getStatus() == FileStatus.CHANGED;
        Iterable newOrChangedNonArchiveFiles = updates.stream().filter(pfu -> pfu.getSource().getType() == RelativeFile.Type.DIRECTORY && isNewOrChanged.test((PackagedFileUpdate)pfu)).collect(Collectors.toList());
        for (PackagedFileUpdate rf : newOrChangedNonArchiveFiles) {
            File out = rf.getSource().getFile();
            this.getApkCreator().writeFile(out, rf.getName());
        }
        Iterable newOrChangedArchiveFiles = updates.stream().filter(pfu -> pfu.getSource().getType() == RelativeFile.Type.JAR && isNewOrChanged.test((PackagedFileUpdate)pfu)).collect(Collectors.toList());
        Set archives = StreamSupport.stream(newOrChangedArchiveFiles.spliterator(), false).map(pfu -> pfu.getSource().getBase()).collect(Collectors.toSet());
        HashSet names = Sets.newHashSet((Iterable)Iterables.transform((Iterable)newOrChangedArchiveFiles, PackagedFileUpdate::getName));
        HashMap pathNameMap = Maps.newHashMap();
        for (PackagedFileUpdate archiveUpdate : newOrChangedArchiveFiles) {
            pathNameMap.put(archiveUpdate.getSource().getRelativePath(), archiveUpdate.getName());
        }
        for (File arch : archives) {
            this.getApkCreator().writeZip(arch, pathNameMap::get, name -> !names.contains(name));
        }
    }

    private static void checkOutputFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException(String.format("'%s' is a directory", file.getAbsolutePath()));
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new IOException(String.format("'%s' is not writeable", file.getAbsolutePath()));
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()));
                }
                if (!file.delete()) {
                    throw new IOException(String.format("Failed to delete newly created '%s'", file.getAbsolutePath()));
                }
            }
            catch (IOException e4) {
                throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()), e4);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        try (Closer closer = Closer.create();){
            if (!this.mCreationData.isIncremental()) {
                this.getApkCreator();
            }
            closer.register((Closeable)this.mApkCreator);
            closer.register((Closeable)this.mDexRenamer);
            this.mClosed = true;
        }
    }
}

