/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.MutabilityControl;
import com.android.dx.util.ToHuman;
import java.util.Arrays;

public class FixedSizeList
extends MutabilityControl
implements ToHuman {
    private Object[] arr;

    public FixedSizeList(int size) {
        super(size != 0);
        try {
            this.arr = new Object[size];
        }
        catch (NegativeArraySizeException ex) {
            throw new IllegalArgumentException("size < 0");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FixedSizeList list = (FixedSizeList)other;
        return Arrays.equals(this.arr, list.arr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    public String toString() {
        String name = this.getClass().getName();
        return this.toString0(name.substring(name.lastIndexOf(46) + 1) + '{', ", ", "}", false);
    }

    @Override
    public String toHuman() {
        String name = this.getClass().getName();
        return this.toString0(name.substring(name.lastIndexOf(46) + 1) + '{', ", ", "}", true);
    }

    public String toString(String prefix, String separator, String suffix) {
        return this.toString0(prefix, separator, suffix, false);
    }

    public String toHuman(String prefix, String separator, String suffix) {
        return this.toString0(prefix, separator, suffix, true);
    }

    public final int size() {
        return this.arr.length;
    }

    public void shrinkToFit() {
        int sz = this.arr.length;
        int newSz = 0;
        for (int i4 = 0; i4 < sz; ++i4) {
            if (this.arr[i4] == null) continue;
            ++newSz;
        }
        if (sz == newSz) {
            return;
        }
        this.throwIfImmutable();
        Object[] newa = new Object[newSz];
        int at = 0;
        for (int i5 = 0; i5 < sz; ++i5) {
            Object one = this.arr[i5];
            if (one == null) continue;
            newa[at] = one;
            ++at;
        }
        this.arr = newa;
        if (newSz == 0) {
            this.setImmutable();
        }
    }

    protected final Object get0(int n4) {
        try {
            Object result = this.arr[n4];
            if (result == null) {
                throw new NullPointerException("unset: " + n4);
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.throwIndex(n4);
        }
    }

    protected final Object getOrNull0(int n4) {
        return this.arr[n4];
    }

    protected final void set0(int n4, Object obj) {
        this.throwIfImmutable();
        try {
            this.arr[n4] = obj;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.throwIndex(n4);
        }
    }

    private Object throwIndex(int n4) {
        if (n4 < 0) {
            throw new IndexOutOfBoundsException("n < 0");
        }
        throw new IndexOutOfBoundsException("n >= size()");
    }

    private String toString0(String prefix, String separator, String suffix, boolean human) {
        int len = this.arr.length;
        StringBuilder sb = new StringBuilder(len * 10 + 10);
        if (prefix != null) {
            sb.append(prefix);
        }
        for (int i4 = 0; i4 < len; ++i4) {
            if (i4 != 0 && separator != null) {
                sb.append(separator);
            }
            if (human) {
                sb.append(((ToHuman)this.arr[i4]).toHuman());
                continue;
            }
            sb.append(this.arr[i4]);
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

