/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexClasses;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.utils.FieldSignatureEquivalence;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.SingletonEquivalence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StaticClassMerger {
    private static final int HEURISTIC_FOR_CAPACITY_OF_REPRESENTATIVES = 30;
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final MainDexClasses mainDexClasses;
    private final Equivalence<DexField> fieldEquivalence;
    private final Equivalence<DexMethod> methodEquivalence;
    private final Map<MergeGroup.Key, Representative> representatives = new HashMap<MergeGroup.Key, Representative>();
    private final BiMap<DexField, DexField> fieldMapping = HashBiMap.create();
    private final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private int numberOfMergedClasses = 0;

    public StaticClassMerger(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, InternalOptions options, MainDexClasses mainDexClasses) {
        this.appView = appView;
        if (options.getProguardConfiguration().isOverloadAggressivelyWithoutUseUniqueClassMemberNames()) {
            this.fieldEquivalence = FieldSignatureEquivalence.getEquivalenceIgnoreName();
            this.methodEquivalence = MethodSignatureEquivalence.getEquivalenceIgnoreName();
        } else {
            this.fieldEquivalence = new SingletonEquivalence<DexField>();
            this.methodEquivalence = MethodJavaSignatureEquivalence.getEquivalenceIgnoreName();
        }
        this.mainDexClasses = mainDexClasses;
    }

    public GraphLense run() {
        for (DexProgramClass clazz : this.appView.appInfo().app.classesWithDeterministicOrder()) {
            MergeGroup group = this.satisfiesMergeCriteria(clazz);
            if (group == MergeGroup.DONT_MERGE) continue;
            this.merge(clazz, group);
        }
        return this.buildGraphLense();
    }

    private GraphLense buildGraphLense() {
        if (!this.fieldMapping.isEmpty() || !this.methodMapping.isEmpty()) {
            BiMap<DexField, DexField> originalFieldSignatures = this.fieldMapping.inverse();
            BiMap<DexMethod, DexMethod> originalMethodSignatures = this.methodMapping.inverse();
            return new GraphLense.NestedGraphLense(ImmutableMap.of(), this.methodMapping, this.fieldMapping, originalFieldSignatures, originalMethodSignatures, this.appView.graphLense(), this.appView.dexItemFactory());
        }
        return this.appView.graphLense();
    }

    private MergeGroup satisfiesMergeCriteria(DexProgramClass clazz) {
        if (this.appView.appInfo().neverMerge.contains(clazz.type)) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.staticFields().size() + clazz.directMethods().size() + clazz.virtualMethods().size() == 0) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.instanceFields().size() > 0) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.staticFields().stream().anyMatch(field -> this.appView.appInfo().isPinned(field.field))) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.directMethods().stream().anyMatch(DexEncodedMethod::isInitializer)) {
            return MergeGroup.DONT_MERGE;
        }
        if (!clazz.virtualMethods().stream().allMatch(DexEncodedMethod::isPrivateMethod)) {
            return MergeGroup.DONT_MERGE;
        }
        if (Streams.stream(clazz.methods()).anyMatch(method -> method.accessFlags.isNative() || this.appView.appInfo().isPinned(method.method) || this.appView.appInfo().alwaysInline.contains(method.method) || this.appView.appInfo().noSideEffects.keySet().contains(method.method))) {
            return MergeGroup.DONT_MERGE;
        }
        if (clazz.classInitializationMayHaveSideEffects(this.appView.appInfo())) {
            return MergeGroup.DONT_MERGE;
        }
        if (!this.mainDexClasses.isEmpty()) {
            if (this.mainDexClasses.getRoots().contains(clazz.type)) {
                return MergeGroup.MAIN_DEX_ROOTS;
            }
            if (this.mainDexClasses.getDependencies().contains(clazz.type)) {
                return MergeGroup.MAIN_DEX_DEPENDENCIES;
            }
        }
        return MergeGroup.NOT_MAIN_DEX;
    }

    private boolean isValidRepresentative(DexProgramClass clazz) {
        return !clazz.isInterface();
    }

    private boolean merge(DexProgramClass clazz, MergeGroup group) {
        assert (this.satisfiesMergeCriteria(clazz) == group);
        assert (group != MergeGroup.DONT_MERGE);
        String pkg = clazz.type.getPackageDescriptor();
        return this.mayMergeAcrossPackageBoundaries(clazz) ? this.mergeGlobally(clazz, pkg, group) : this.mergeInsidePackage(clazz, pkg, group);
    }

    private boolean mergeGlobally(DexProgramClass clazz, String pkg, MergeGroup group) {
        Representative globalRepresentative = this.representatives.get(group.globalKey());
        if (globalRepresentative == null) {
            if (this.isValidRepresentative(clazz)) {
                this.setRepresentative(group.globalKey(), this.getOrCreateRepresentative(group.key(pkg), clazz));
            } else {
                this.clearRepresentative(group.globalKey());
            }
            return false;
        }
        globalRepresentative.include(clazz);
        if (globalRepresentative.isFull()) {
            if (this.isValidRepresentative(clazz)) {
                this.setRepresentative(group.globalKey(), this.getOrCreateRepresentative(group.key(pkg), clazz));
            } else {
                this.clearRepresentative(group.globalKey());
            }
            return false;
        }
        this.moveMembersFromSourceToTarget(clazz, globalRepresentative.clazz);
        return true;
    }

    private boolean mergeInsidePackage(DexProgramClass clazz, String pkg, MergeGroup group) {
        MergeGroup.Key key = group.key(pkg);
        Representative packageRepresentative = this.representatives.get(key);
        if (packageRepresentative != null) {
            if (this.isValidRepresentative(clazz) && clazz.accessFlags.isMoreVisibleThan(((Representative)packageRepresentative).clazz.accessFlags)) {
                Representative newRepresentative = this.getOrCreateRepresentative(key, clazz);
                newRepresentative.include(packageRepresentative.clazz);
                if (!newRepresentative.isFull()) {
                    this.setRepresentative(group.key(pkg), newRepresentative);
                    this.moveMembersFromSourceToTarget(packageRepresentative.clazz, clazz);
                    return true;
                }
                return false;
            }
            packageRepresentative.include(clazz);
            if (!packageRepresentative.isFull()) {
                this.moveMembersFromSourceToTarget(clazz, packageRepresentative.clazz);
                return true;
            }
        }
        if (this.isValidRepresentative(clazz)) {
            this.setRepresentative(key, this.getOrCreateRepresentative(key, clazz));
        }
        return false;
    }

    private Representative getOrCreateRepresentative(MergeGroup.Key key, DexProgramClass clazz) {
        Representative globalRepresentative = this.representatives.get(key.getMergeGroup().globalKey());
        if (globalRepresentative != null && globalRepresentative.clazz == clazz) {
            return globalRepresentative;
        }
        Representative packageRepresentative = this.representatives.get(key);
        if (packageRepresentative != null && packageRepresentative.clazz == clazz) {
            return packageRepresentative;
        }
        return new Representative(clazz);
    }

    private void setRepresentative(MergeGroup.Key key, Representative representative) {
        assert (this.isValidRepresentative(representative.clazz));
        this.representatives.put(key, representative);
    }

    private void clearRepresentative(MergeGroup.Key key) {
        this.representatives.remove(key);
    }

    private boolean mayMergeAcrossPackageBoundaries(DexProgramClass clazz) {
        if (!clazz.accessFlags.isPublic()) {
            return false;
        }
        if (!clazz.directMethods().stream().allMatch(method -> method.accessFlags.isPrivate() || method.accessFlags.isPublic())) {
            return false;
        }
        if (!clazz.staticFields().stream().allMatch(field -> field.accessFlags.isPrivate() || field.accessFlags.isPublic())) {
            return false;
        }
        assert (clazz.instanceFields().size() == 0);
        assert (clazz.virtualMethods().stream().allMatch(method -> method.accessFlags.isPrivate()));
        VerticalClassMerger.IllegalAccessDetector registry = new VerticalClassMerger.IllegalAccessDetector(this.appView, clazz);
        for (DexEncodedMethod method2 : clazz.methods()) {
            registry.setContext(method2);
            method2.registerCodeReferences(registry);
            if (!registry.foundIllegalAccess()) continue;
            return false;
        }
        return true;
    }

    private void moveMembersFromSourceToTarget(DexProgramClass sourceClass, DexProgramClass targetClass) {
        assert (targetClass.accessFlags.isAtLeastAsVisibleAs(sourceClass.accessFlags));
        assert (sourceClass.instanceFields().size() == 0);
        assert (targetClass.instanceFields().size() == 0);
        ++this.numberOfMergedClasses;
        targetClass.appendDirectMethods(this.mergeMethods(sourceClass.directMethods(), targetClass.directMethods(), targetClass));
        targetClass.appendVirtualMethods(this.mergeMethods(sourceClass.virtualMethods(), targetClass.virtualMethods(), targetClass));
        targetClass.setStaticFields(this.mergeFields(sourceClass.staticFields(), targetClass.staticFields(), targetClass));
        sourceClass.setDirectMethods(DexEncodedMethod.EMPTY_ARRAY);
        sourceClass.setVirtualMethods(DexEncodedMethod.EMPTY_ARRAY);
        sourceClass.setStaticFields(DexEncodedField.EMPTY_ARRAY);
    }

    private List<DexEncodedMethod> mergeMethods(List<DexEncodedMethod> sourceMethods, List<DexEncodedMethod> targetMethods, DexProgramClass targetClass) {
        MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        Set existingMethods = targetMethods.stream().map(targetMethod -> equivalence.wrap(targetMethod.method)).collect(Collectors.toSet());
        Predicate<DexMethod> availableMethodSignatures = method -> !existingMethods.contains(equivalence.wrap(method));
        ArrayList<DexEncodedMethod> newMethods = new ArrayList<DexEncodedMethod>(sourceMethods.size());
        for (DexEncodedMethod sourceMethod : sourceMethods) {
            DexEncodedMethod sourceMethodAfterMove = this.renameMethodIfNeeded(sourceMethod, targetClass, availableMethodSignatures);
            newMethods.add(sourceMethodAfterMove);
            DexMethod originalMethod = this.methodMapping.inverse().getOrDefault(sourceMethod.method, sourceMethod.method);
            this.methodMapping.forcePut(originalMethod, sourceMethodAfterMove.method);
            existingMethods.add(equivalence.wrap(sourceMethodAfterMove.method));
        }
        return newMethods;
    }

    private DexEncodedField[] mergeFields(List<DexEncodedField> sourceFields, List<DexEncodedField> targetFields, DexProgramClass targetClass) {
        DexEncodedField[] result = new DexEncodedField[sourceFields.size() + targetFields.size()];
        int index = 0;
        for (DexEncodedField targetField2 : targetFields) {
            result[index++] = targetField2;
        }
        FieldSignatureEquivalence equivalence = FieldSignatureEquivalence.get();
        Set existingFields = targetFields.stream().map(targetField -> equivalence.wrap(targetField.field)).collect(Collectors.toSet());
        Predicate<DexField> availableFieldSignatures = field -> !existingFields.contains(equivalence.wrap(field));
        for (DexEncodedField sourceField : sourceFields) {
            DexEncodedField sourceFieldAfterMove = this.renameFieldIfNeeded(sourceField, targetClass, availableFieldSignatures);
            result[index++] = sourceFieldAfterMove;
            DexField originalField = this.fieldMapping.inverse().getOrDefault(sourceField.field, sourceField.field);
            this.fieldMapping.forcePut(originalField, sourceFieldAfterMove.field);
            existingFields.add(equivalence.wrap(sourceFieldAfterMove.field));
        }
        assert (index == result.length);
        return result;
    }

    private DexEncodedMethod renameMethodIfNeeded(DexEncodedMethod method, DexProgramClass targetClass, Predicate<DexMethod> availableMethodSignatures) {
        assert (!method.accessFlags.isConstructor());
        DexString oldName = method.method.name;
        DexMethod newSignature = this.appView.dexItemFactory().createMethod(targetClass.type, method.method.proto, oldName);
        if (!availableMethodSignatures.test(newSignature)) {
            int count = 1;
            do {
                DexString newName = this.appView.dexItemFactory().createString(oldName.toSourceString() + count);
                newSignature = this.appView.dexItemFactory().createMethod(targetClass.type, method.method.proto, newName);
                ++count;
            } while (!availableMethodSignatures.test(newSignature));
        }
        return method.toTypeSubstitutedMethod(newSignature);
    }

    private DexEncodedField renameFieldIfNeeded(DexEncodedField field, DexProgramClass targetClass, Predicate<DexField> availableFieldSignatures) {
        DexString oldName = field.field.name;
        DexField newSignature = this.appView.dexItemFactory().createField(targetClass.type, field.field.type, oldName);
        if (!availableFieldSignatures.test(newSignature)) {
            int count = 1;
            do {
                DexString newName = this.appView.dexItemFactory().createString(oldName.toSourceString() + count);
                newSignature = this.appView.dexItemFactory().createField(targetClass.type, field.field.type, newName);
                ++count;
            } while (!availableFieldSignatures.test(newSignature));
        }
        return field.toTypeSubstitutedField(newSignature);
    }

    private class Representative {
        private final DexProgramClass clazz;
        private final HashMultiset<Equivalence.Wrapper<DexField>> fieldBuckets = HashMultiset.create();
        private final HashMultiset<Equivalence.Wrapper<DexMethod>> methodBuckets = HashMultiset.create();

        public Representative(DexProgramClass clazz) {
            this.clazz = clazz;
            this.include(clazz);
        }

        public void include(DexProgramClass clazz) {
            Equivalence.Wrapper<Descriptor> wrapper;
            for (DexEncodedField field : clazz.fields()) {
                wrapper = StaticClassMerger.this.fieldEquivalence.wrap(field.field);
                this.fieldBuckets.add(wrapper);
            }
            for (DexEncodedMethod method : clazz.methods()) {
                wrapper = StaticClassMerger.this.methodEquivalence.wrap(method.method);
                this.methodBuckets.add(wrapper);
            }
        }

        public boolean isFull() {
            int numberOfNamesNeeded = 1;
            for (Multiset.Entry entry : this.fieldBuckets.entrySet()) {
                numberOfNamesNeeded = Math.max(entry.getCount(), numberOfNamesNeeded);
            }
            for (Multiset.Entry entry : this.methodBuckets.entrySet()) {
                numberOfNamesNeeded = Math.max(entry.getCount(), numberOfNamesNeeded);
            }
            return numberOfNamesNeeded > 30;
        }
    }

    static final class MergeGroup
    extends Enum<MergeGroup> {
        public static final /* enum */ MergeGroup MAIN_DEX_ROOTS = new MergeGroup();
        public static final /* enum */ MergeGroup MAIN_DEX_DEPENDENCIES = new MergeGroup();
        public static final /* enum */ MergeGroup NOT_MAIN_DEX = new MergeGroup();
        public static final /* enum */ MergeGroup DONT_MERGE = new MergeGroup();
        private static final String GLOBAL = "<global>";
        private static Key mainDexRootsGlobalKey;
        private static Key mainDexDependenciesGlobalKey;
        private static Key notMainDexGlobalKey;
        private static final /* synthetic */ MergeGroup[] $VALUES;

        public static MergeGroup[] values() {
            return (MergeGroup[])$VALUES.clone();
        }

        public static MergeGroup valueOf(String name) {
            return Enum.valueOf(MergeGroup.class, name);
        }

        public Key globalKey() {
            switch (this) {
                case NOT_MAIN_DEX: {
                    return notMainDexGlobalKey;
                }
                case MAIN_DEX_ROOTS: {
                    return mainDexRootsGlobalKey;
                }
                case MAIN_DEX_DEPENDENCIES: {
                    return mainDexDependenciesGlobalKey;
                }
            }
            throw new Unreachable("Unexpected MergeGroup value");
        }

        public Key key(String pkg) {
            assert (this != DONT_MERGE);
            return new Key(this, pkg);
        }

        public String toString() {
            switch (this) {
                case NOT_MAIN_DEX: {
                    return "outside main dex";
                }
                case MAIN_DEX_ROOTS: {
                    return "main dex roots";
                }
                case MAIN_DEX_DEPENDENCIES: {
                    return "main dex dependencies";
                }
            }
            assert (this == DONT_MERGE);
            return "don't merge";
        }

        static {
            $VALUES = new MergeGroup[]{MAIN_DEX_ROOTS, MAIN_DEX_DEPENDENCIES, NOT_MAIN_DEX, DONT_MERGE};
            mainDexRootsGlobalKey = new Key(MAIN_DEX_ROOTS, GLOBAL);
            mainDexDependenciesGlobalKey = new Key(MAIN_DEX_DEPENDENCIES, GLOBAL);
            notMainDexGlobalKey = new Key(NOT_MAIN_DEX, GLOBAL);
        }

        private static class Key {
            private final MergeGroup mergeGroup;
            private final String packageOrGlobal;

            public Key(MergeGroup mergeGroup, String packageOrGlobal) {
                this.mergeGroup = mergeGroup;
                this.packageOrGlobal = packageOrGlobal;
            }

            public MergeGroup getMergeGroup() {
                return this.mergeGroup;
            }

            public String getPackageOrGlobal() {
                return this.packageOrGlobal;
            }

            public boolean isGlobal() {
                return this.packageOrGlobal.equals(MergeGroup.GLOBAL);
            }

            public int hashCode() {
                return this.mergeGroup.ordinal() * 13 + this.packageOrGlobal.hashCode();
            }

            public boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Key o = (Key)other;
                return o.mergeGroup == this.mergeGroup && o.packageOrGlobal.equals(this.packageOrGlobal);
            }
        }
    }
}

