/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.Keep;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.List;
import java.util.Objects;

@Keep
public final class MethodReference {
    private final ClassReference holderClass;
    private final String methodName;
    private final ImmutableList<TypeReference> formalTypes;
    private final TypeReference returnType;

    MethodReference(ClassReference holderClass, String methodName, ImmutableList<TypeReference> formalTypes, TypeReference returnType) {
        assert (holderClass != null);
        assert (methodName != null);
        assert (formalTypes != null);
        this.holderClass = holderClass;
        this.methodName = methodName;
        this.formalTypes = formalTypes;
        this.returnType = returnType;
    }

    public ClassReference getHolderClass() {
        return this.holderClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<TypeReference> getFormalTypes() {
        return this.formalTypes;
    }

    public TypeReference getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodReference)) {
            return false;
        }
        MethodReference other = (MethodReference)o;
        return this.holderClass.equals(other.holderClass) && this.methodName.equals(other.methodName) && this.formalTypes.equals(other.formalTypes) && Objects.equals(this.returnType, other.returnType);
    }

    public int hashCode() {
        return Objects.hash(this.holderClass, this.methodName, this.formalTypes, this.returnType);
    }

    public String getMethodDescriptor() {
        return StringUtils.join(ListUtils.map(this.getFormalTypes(), TypeReference::getDescriptor), "", StringUtils.BraceType.PARENS) + (this.getReturnType() == null ? "V" : this.getReturnType().getDescriptor());
    }

    public String toString() {
        return this.getHolderClass().toString() + this.getMethodName() + this.getMethodDescriptor();
    }
}

