/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.InterfaceMethodNameMinifier;
import com.android.tools.r8.naming.MemberNameMinifier;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class MethodNameMinifier
extends MemberNameMinifier<DexMethod, DexProto> {
    private final Equivalence<DexMethod> equivalence;
    private final FrontierState frontierState = new FrontierState();

    MethodNameMinifier(AppView<Enqueuer.AppInfoWithLiveness> appView, RootSetBuilder.RootSet rootSet) {
        super(appView, rootSet);
        this.equivalence = this.overloadAggressively ? MethodSignatureEquivalence.get() : MethodJavaSignatureEquivalence.get();
    }

    @Override
    Function<DexProto, ?> getKeyTransform() {
        if (this.overloadAggressively) {
            return a -> a;
        }
        return proto -> proto.parameters;
    }

    MethodRenaming computeRenaming(Set<DexCallSite> desugaredCallSites, Timing timing) {
        timing.begin("Phase 1");
        this.reserveNamesInClasses();
        timing.end();
        timing.begin("Phase 2");
        InterfaceMethodNameMinifier interfaceMethodNameMinifier = new InterfaceMethodNameMinifier(this.appInfo, desugaredCallSites, this.equivalence, this.frontierState, this.minifierState, this.options);
        interfaceMethodNameMinifier.assignNamesToInterfaceMethods(timing);
        timing.end();
        timing.begin("Phase 3");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, false);
        timing.end();
        timing.begin("Phase 4");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, true);
        timing.end();
        return new MethodRenaming(this.renaming, interfaceMethodNameMinifier.getCallSiteRenamings());
    }

    private void assignNamesToClassesMethods(DexType type, boolean doPrivates) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder != null && !holder.isLibraryClass()) {
            HashMap<Equivalence.Wrapper<DexMethod>, DexString> renamingAtThisLevel = new HashMap<Equivalence.Wrapper<DexMethod>, DexString>();
            NamingState state = this.computeStateIfAbsent(type, k -> this.minifierState.getState(holder.superType).createChild());
            for (DexEncodedMethod method : holder.allMethodsSorted()) {
                this.assignNameToMethod(method, state, renamingAtThisLevel, doPrivates);
            }
            if (!doPrivates && !this.useUniqueMemberNames) {
                renamingAtThisLevel.forEach((key, candidate) -> {
                    DexMethod method = (DexMethod)key.get();
                    state.addRenaming(method.name, method.proto, (DexString)candidate);
                });
            }
        }
        type.forAllExtendsSubtypes(subtype -> this.assignNamesToClassesMethods((DexType)subtype, doPrivates));
    }

    private void assignNameToMethod(DexEncodedMethod encodedMethod, NamingState<DexProto, ?> state, Map<Equivalence.Wrapper<DexMethod>, DexString> renamingAtThisLevel, boolean doPrivates) {
        if (encodedMethod.accessFlags.isPrivate() != doPrivates) {
            return;
        }
        DexMethod method = encodedMethod.method;
        if (!state.isReserved(method.name, method.proto) && !encodedMethod.accessFlags.isConstructor()) {
            DexString renamedName = renamingAtThisLevel.computeIfAbsent(this.equivalence.wrap(method), key -> state.assignNewNameFor(method.name, method.proto, this.useUniqueMemberNames));
            this.renaming.put(method, renamedName);
        }
    }

    private void reserveNamesInClasses() {
        this.reserveNamesInClasses(this.appInfo.dexItemFactory.objectType, this.appInfo.dexItemFactory.objectType, null);
    }

    private void reserveNamesInClasses(DexType type, DexType libraryFrontier, NamingState<DexProto, ?> parent) {
        assert (!type.isInterface());
        NamingState<DexProto, ?> state = this.frontierState.allocateNamingStateAndReserve(type, libraryFrontier, parent);
        DexClass holder = this.appInfo.definitionFor(type);
        for (DexType subtype : type.allExtendsSubtypes()) {
            assert (!subtype.isInterface());
            this.reserveNamesInClasses(subtype, holder == null || holder.isLibraryClass() ? subtype : libraryFrontier, state);
        }
    }

    static Iterable<DexEncodedMethod> shuffleMethods(Iterable<DexEncodedMethod> methods, InternalOptions options) {
        return options.testing.irOrdering.order(methods);
    }

    static class MethodNamingState {
        private final NamingState<DexProto, ?> parent;
        private final DexString name;
        private final DexProto proto;

        MethodNamingState(NamingState<DexProto, ?> parent, DexString name, DexProto proto) {
            assert (parent != null);
            this.parent = parent;
            this.name = name;
            this.proto = proto;
        }

        DexString assignNewName() {
            return this.parent.assignNewNameFor(this.name, this.proto, false);
        }

        void reserveName() {
            this.parent.reserveName(this.name, this.proto);
        }

        boolean isReserved() {
            return this.parent.isReserved(this.name, this.proto);
        }

        boolean isAvailable(DexString candidate) {
            return this.parent.isAvailable(this.name, this.proto, candidate);
        }

        void addRenaming(DexString newName) {
            this.parent.addRenaming(this.name, this.proto, newName);
        }

        DexString getName() {
            return this.name;
        }

        DexProto getProto() {
            return this.proto;
        }

        void print(String indentation, Function<NamingState<DexProto, ?>, DexType> stateKeyGetter, PrintStream out) {
            DexType stateKey = stateKeyGetter.apply(this.parent);
            out.print(indentation);
            out.print(stateKey != null ? stateKey.toSourceString() : "<?>");
            out.print(".");
            out.print(this.name.toSourceString());
            out.println(this.proto.toSmaliString());
            this.parent.printState(this.proto, indentation + "  ", out);
        }
    }

    class FrontierState {
        private final Map<DexType, DexType> frontiers = new IdentityHashMap<DexType, DexType>();

        FrontierState() {
        }

        NamingState<DexProto, ?> allocateNamingStateAndReserve(DexType type, DexType frontier, NamingState<DexProto, ?> parent) {
            if (frontier != type) {
                this.frontiers.put(type, frontier);
            }
            NamingState state = MethodNameMinifier.this.computeStateIfAbsent(frontier, ignore -> parent == null ? NamingState.createRoot(MethodNameMinifier.this.appInfo.dexItemFactory, MethodNameMinifier.this.dictionary, MethodNameMinifier.this.getKeyTransform(), MethodNameMinifier.this.useUniqueMemberNames) : parent.createChild());
            DexClass holder = MethodNameMinifier.this.appInfo.definitionFor(type);
            if (holder != null) {
                boolean keepAll = holder.isLibraryClass() || holder.accessFlags.isAnnotation();
                for (DexEncodedMethod method : MethodNameMinifier.shuffleMethods(holder.methods(), MethodNameMinifier.this.options)) {
                    if (!keepAll && !MethodNameMinifier.this.rootSet.noObfuscation.contains(method.method)) continue;
                    this.reserveNamesForMethod(method.method, state);
                }
            }
            return state;
        }

        private void reserveNamesForMethod(DexMethod method, NamingState<DexProto, ?> state) {
            state.reserveName(method.name, method.proto);
            MethodNameMinifier.this.globalState.reserveName(method.name, method.proto);
        }

        public DexType get(DexType type) {
            return this.frontiers.getOrDefault(type, type);
        }

        public DexType put(DexType type, DexType frontier) {
            assert (frontier != type);
            return this.frontiers.put(type, frontier);
        }
    }

    static class MethodRenaming {
        final Map<DexMethod, DexString> renaming;
        final Map<DexCallSite, DexString> callSiteRenaming;

        private MethodRenaming(Map<DexMethod, DexString> renaming, Map<DexCallSite, DexString> callSiteRenaming) {
            this.renaming = renaming;
            this.callSiteRenaming = callSiteRenaming;
        }

        public static MethodRenaming empty() {
            return new MethodRenaming(ImmutableMap.of(), ImmutableMap.of());
        }
    }
}

