/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfMonitor;
import com.android.tools.r8.code.MonitorEnter;
import com.android.tools.r8.code.MonitorExit;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class Monitor
extends Instruction {
    private final Type type;

    public Monitor(Type type, Value object) {
        super(null, object);
        this.type = type;
    }

    public Value object() {
        return (Value)this.inValues.get(0);
    }

    public boolean isEnter() {
        return this.type == Type.ENTER;
    }

    public boolean isExit() {
        return this.type == Type.EXIT;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int object = builder.argumentOrAllocateRegister(this.object(), this.getNumber());
        if (object > this.maxInValueRegister()) {
            object = builder.allocatedRegister(this.object(), this.getNumber());
        }
        if (this.type == Type.ENTER) {
            builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new MonitorEnter(object));
        } else {
            builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new MonitorExit(object));
        }
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isMonitor() && other.asMonitor().type == this.type;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Monitor defines no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isMonitor() {
        return true;
    }

    @Override
    public Monitor asMonitor() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forMonitor();
    }

    @Override
    public String getInstructionName() {
        switch (this.type) {
            case ENTER: {
                return "MonitorEnter";
            }
            case EXIT: {
                return "MonitorExit";
            }
        }
        throw new Unreachable("Unknown monitor type:" + (Object)((Object)this.type));
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfMonitor(this.type));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.object() == value;
    }

    public static enum Type {
        ENTER,
        EXIT;

    }
}

