/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfArrayLoad;
import com.android.tools.r8.code.Aget;
import com.android.tools.r8.code.AgetBoolean;
import com.android.tools.r8.code.AgetByte;
import com.android.tools.r8.code.AgetChar;
import com.android.tools.r8.code.AgetObject;
import com.android.tools.r8.code.AgetShort;
import com.android.tools.r8.code.AgetWide;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.Arrays;

public class ArrayGet
extends Instruction
implements ImpreciseMemberTypeInstruction {
    private MemberType type;

    public ArrayGet(MemberType type, Value dest, Value array, Value index) {
        super(dest, Arrays.asList(array, index));
        this.type = type;
    }

    public Value dest() {
        return this.outValue;
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    public Value index() {
        return (Value)this.inValues.get(1);
    }

    @Override
    public MemberType getMemberType() {
        return this.type;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: {
                instruction = new Aget(dest, array, index);
                break;
            }
            case LONG: 
            case DOUBLE: {
                assert (builder.getOptions().canUseSameArrayAndResultRegisterInArrayGetWide() || dest != array);
                instruction = new AgetWide(dest, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AgetObject(dest, array, index);
                break;
            }
            case BOOLEAN: {
                instruction = new AgetBoolean(dest, array, index);
                break;
            }
            case BYTE: {
                instruction = new AgetByte(dest, array, index);
                break;
            }
            case CHAR: {
                instruction = new AgetChar(dest, array, index);
                break;
            }
            case SHORT: {
                instruction = new AgetShort(dest, array, index);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.type));
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isArrayGet() && other.asArrayGet().type == this.type;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isArrayGet() {
        return true;
    }

    @Override
    public ArrayGet asArrayGet() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forArrayGet();
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        assert (this.outValue.getTypeLattice().isReference());
        DexType arrayType = helper.getDexType(this.array());
        if (arrayType == DexItemFactory.nullValueType) {
            return arrayType;
        }
        return arrayType.toArrayElementType(helper.getFactory());
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfArrayLoad(this.type));
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        ArrayTypeLatticeElement arrayTypeLattice = this.array().getTypeLattice().isArrayType() ? this.array().getTypeLattice().asArrayTypeLatticeElement() : null;
        switch (this.getMemberType()) {
            case OBJECT: {
                TypeLatticeElement valueType;
                TypeLatticeElement typeLatticeElement = valueType = arrayTypeLattice == null ? TypeLatticeElement.NULL : arrayTypeLattice.getArrayMemberTypeAsValueType();
                assert (valueType.isReference());
                return valueType;
            }
            case INT: 
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getArrayMemberTypeAsValueType().isInt());
                return TypeLatticeElement.INT;
            }
            case FLOAT: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getArrayMemberTypeAsValueType().isFloat());
                return TypeLatticeElement.FLOAT;
            }
            case LONG: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getArrayMemberTypeAsValueType().isLong());
                return TypeLatticeElement.LONG;
            }
            case DOUBLE: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getArrayMemberTypeAsValueType().isDouble());
                return TypeLatticeElement.DOUBLE;
            }
            case INT_OR_FLOAT: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getArrayMemberTypeAsValueType().isSingle());
                return ArrayGet.checkConstraint(this.dest(), ValueTypeConstraint.INT_OR_FLOAT);
            }
            case LONG_OR_DOUBLE: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getArrayMemberTypeAsValueType().isWide());
                return ArrayGet.checkConstraint(this.dest(), ValueTypeConstraint.LONG_OR_DOUBLE);
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)this.getMemberType()));
    }

    private static TypeLatticeElement checkConstraint(Value value, ValueTypeConstraint constraint) {
        TypeLatticeElement latticeElement = value.constrainedType(constraint);
        if (latticeElement != null) {
            return latticeElement;
        }
        throw new CompilationError("Failure to constrain value: " + value + " by constraint: " + (Object)((Object)constraint));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.array() == value;
    }

    @Override
    public void constrainType(TypeConstraintResolver constraintResolver) {
        constraintResolver.constrainArrayMemberType(this.type, this.dest(), this.array(), t -> {
            this.type = t;
        });
    }
}

