/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.origin.Origin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;

public class DexProgramClass
extends DexClass
implements Supplier<DexProgramClass> {
    private static final DexEncodedArray SENTINEL_NOT_YET_COMPUTED = new DexEncodedArray(new DexValue[0]);
    private final ProgramResource.Kind originKind;
    private DexEncodedArray staticValues = SENTINEL_NOT_YET_COMPUTED;
    private final Collection<DexProgramClass> synthesizedFrom;
    private int initialClassFileVersion = -1;
    private KotlinInfo kotlinInfo = null;

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, EnclosingMethodAttribute enclosingMember, List<InnerClassAttribute> innerClasses, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, boolean skipNameValidationForTesting) {
        this(type, originKind, origin, accessFlags, superType, interfaces, sourceFile, enclosingMember, innerClasses, classAnnotations, staticFields, instanceFields, directMethods, virtualMethods, skipNameValidationForTesting, Collections.emptyList());
    }

    public DexProgramClass(DexType type, ProgramResource.Kind originKind, Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, EnclosingMethodAttribute enclosingMember, List<InnerClassAttribute> innerClasses, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, boolean skipNameValidationForTesting, Collection<DexProgramClass> synthesizedDirectlyFrom) {
        super(sourceFile, interfaces, accessFlags, superType, type, staticFields, instanceFields, directMethods, virtualMethods, enclosingMember, innerClasses, classAnnotations, origin, skipNameValidationForTesting);
        assert (classAnnotations != null);
        this.originKind = originKind;
        this.synthesizedFrom = new HashSet<DexProgramClass>();
        synthesizedDirectlyFrom.forEach(this::addSynthesizedFrom);
    }

    public boolean originatesFromDexResource() {
        return this.originKind == ProgramResource.Kind.DEX;
    }

    public boolean originatesFromClassResource() {
        return this.originKind == ProgramResource.Kind.CF;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        if (indexedItems.addClass(this)) {
            this.type.collectIndexedItems(indexedItems, method, instructionOffset);
            if (this.superType != null) {
                this.superType.collectIndexedItems(indexedItems, method, instructionOffset);
            } else assert (this.type.toDescriptorString().equals("Ljava/lang/Object;"));
            if (this.sourceFile != null) {
                this.sourceFile.collectIndexedItems(indexedItems, method, instructionOffset);
            }
            if (this.annotations != null) {
                this.annotations.collectIndexedItems(indexedItems, method, instructionOffset);
            }
            if (this.interfaces != null) {
                this.interfaces.collectIndexedItems(indexedItems, method, instructionOffset);
            }
            if (this.getEnclosingMethod() != null) {
                this.getEnclosingMethod().collectIndexedItems(indexedItems);
            }
            for (InnerClassAttribute attribute : this.getInnerClasses()) {
                attribute.collectIndexedItems(indexedItems);
            }
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.staticFields);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.instanceFields);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.directMethods);
            DexProgramClass.synchronizedCollectAll((IndexedItemCollection)indexedItems, (DexItem[])this.virtualMethods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DexItem> void synchronizedCollectAll(IndexedItemCollection collection, T[] items) {
        T[] TArray = items;
        synchronized (items) {
            DexProgramClass.collectAll((IndexedItemCollection)collection, items);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Collection<DexProgramClass> getSynthesizedFrom() {
        return this.synthesizedFrom;
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        assert (this.getEnclosingMethod() == null);
        assert (this.getInnerClasses().isEmpty());
        if (this.hasAnnotations()) {
            mixedItems.setAnnotationsDirectoryForClass(this, new DexAnnotationDirectory(this));
        }
    }

    @Override
    public void addDependencies(MixedSectionCollection collector) {
        assert (this.getEnclosingMethod() == null);
        assert (this.getInnerClasses().isEmpty());
        if (this.hasMethodsOrFields()) {
            collector.add(this);
            this.sortMembers();
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.directMethods);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.virtualMethods);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.staticFields);
            DexProgramClass.synchronizedCollectAll((MixedSectionCollection)collector, (DexItem[])this.instanceFields);
        }
        if (this.annotations != null) {
            this.annotations.collectMixedSectionItems(collector);
        }
        if (this.interfaces != null) {
            this.interfaces.collectMixedSectionItems(collector);
        }
        this.annotations.collectMixedSectionItems(collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DexItem> void synchronizedCollectAll(MixedSectionCollection collection, T[] items) {
        T[] TArray = items;
        synchronized (items) {
            DexProgramClass.collectAll((MixedSectionCollection)collection, items);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString();
    }

    @Override
    public boolean isProgramClass() {
        return true;
    }

    @Override
    public DexProgramClass asProgramClass() {
        return this;
    }

    @Override
    public KotlinInfo getKotlinInfo() {
        return this.kotlinInfo;
    }

    public void setKotlinInfo(KotlinInfo kotlinInfo) {
        assert (this.kotlinInfo == null || kotlinInfo == null);
        this.kotlinInfo = kotlinInfo;
    }

    public boolean hasMethodsOrFields() {
        int numberOfMethods;
        int numberOfFields = this.staticFields().size() + this.instanceFields().size();
        return numberOfFields + (numberOfMethods = this.directMethods().size() + this.virtualMethods().size()) > 0;
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty() || this.hasAnnotations(this.virtualMethods) || this.hasAnnotations(this.directMethods) || this.hasAnnotations(this.staticFields) || this.hasAnnotations(this.instanceFields);
    }

    boolean hasOnlyInternalizableAnnotations() {
        return !this.hasAnnotations(this.virtualMethods) && !this.hasAnnotations(this.directMethods) && !this.hasAnnotations(this.staticFields) && !this.hasAnnotations(this.instanceFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(DexEncodedField[] fields) {
        DexEncodedField[] dexEncodedFieldArray = fields;
        synchronized (fields) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.stream(fields).anyMatch(DexEncodedField::hasAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnnotations(DexEncodedMethod[] methods) {
        DexEncodedMethod[] dexEncodedMethodArray = methods;
        synchronized (methods) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.stream(methods).anyMatch(DexEncodedMethod::hasAnnotation);
        }
    }

    public void addSynthesizedFrom(DexProgramClass clazz) {
        if (clazz.synthesizedFrom.isEmpty()) {
            this.synthesizedFrom.add(clazz);
        } else {
            clazz.synthesizedFrom.forEach(this::addSynthesizedFrom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeStaticValues() {
        if (this.staticValues != SENTINEL_NOT_YET_COMPUTED) return;
        DexEncodedField[] dexEncodedFieldArray = this.staticFields;
        synchronized (this.staticFields) {
            assert (PresortedComparable.isSorted(Arrays.asList(this.staticFields)));
            DexEncodedField[] fields = this.staticFields;
            int length = 0;
            ArrayList<DexValue> values2 = new ArrayList<DexValue>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                DexEncodedField field = fields[i];
                DexValue staticValue = field.getStaticValue();
                assert (staticValue != null);
                values2.add(staticValue);
                if (staticValue.isDefault(field.field.type)) continue;
                length = i + 1;
            }
            this.staticValues = length > 0 ? new DexEncodedArray(values2.subList(0, length).toArray(new DexValue[length])) : null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isSorted() {
        return DexProgramClass.isSorted((KeyedDexItem[])this.virtualMethods) && DexProgramClass.isSorted((KeyedDexItem[])this.directMethods) && DexProgramClass.isSorted((KeyedDexItem[])this.staticFields) && DexProgramClass.isSorted((KeyedDexItem[])this.instanceFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends KeyedDexItem<S>, S extends PresortedComparable<S>> boolean isSorted(T[] items) {
        T[] TArray = items;
        synchronized (items) {
            Object[] sorted2 = (KeyedDexItem[])items.clone();
            Arrays.sort(sorted2, Comparator.comparing(KeyedDexItem::getKey));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.equals(items, sorted2);
        }
    }

    public DexEncodedArray getStaticValues() {
        if (this.staticValues == SENTINEL_NOT_YET_COMPUTED) {
            assert (!this.hasMethodsOrFields());
            return null;
        }
        return this.staticValues;
    }

    public void addMethod(DexEncodedMethod method) {
        if (method.accessFlags.isStatic() || method.accessFlags.isPrivate() || method.accessFlags.isConstructor()) {
            this.addDirectMethod(method);
        } else {
            this.addVirtualMethod(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        assert (!virtualMethod.accessFlags.isStatic());
        assert (!virtualMethod.accessFlags.isPrivate());
        assert (!virtualMethod.accessFlags.isConstructor());
        DexEncodedMethod[] dexEncodedMethodArray = this.virtualMethods;
        synchronized (this.virtualMethods) {
            this.virtualMethods = Arrays.copyOf(this.virtualMethods, this.virtualMethods.length + 1);
            this.virtualMethods[this.virtualMethods.length - 1] = virtualMethod;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectMethod(DexEncodedMethod staticMethod) {
        assert (staticMethod.accessFlags.isStatic() || staticMethod.accessFlags.isPrivate() || staticMethod.accessFlags.isConstructor());
        DexEncodedMethod[] dexEncodedMethodArray = this.directMethods;
        synchronized (this.directMethods) {
            this.directMethods = Arrays.copyOf(this.directMethods, this.directMethods.length + 1);
            this.directMethods[this.directMethods.length - 1] = staticMethod;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void sortMembers() {
        this.sortEncodedFields(this.staticFields);
        this.sortEncodedFields(this.instanceFields);
        this.sortEncodedMethods(this.directMethods);
        this.sortEncodedMethods(this.virtualMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortEncodedFields(DexEncodedField[] fields) {
        DexEncodedField[] dexEncodedFieldArray = fields;
        synchronized (fields) {
            Arrays.sort(fields, Comparator.comparing(a -> a.field));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortEncodedMethods(DexEncodedMethod[] methods) {
        DexEncodedMethod[] dexEncodedMethodArray = methods;
        synchronized (methods) {
            Arrays.sort(methods, Comparator.comparing(a -> a.method));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public DexProgramClass get() {
        return this;
    }

    public void setInitialClassFileVersion(int initialClassFileVersion) {
        assert (this.initialClassFileVersion == -1 && initialClassFileVersion > 0);
        this.initialClassFileVersion = initialClassFileVersion;
    }

    public boolean hasClassFileVersion() {
        return this.initialClassFileVersion > -1;
    }

    public int getInitialClassFileVersion() {
        assert (this.initialClassFileVersion > -1);
        return this.initialClassFileVersion;
    }

    public boolean hasReachabilitySensitiveAnnotation(DexItemFactory factory) {
        for (DexEncodedMethod dexEncodedMethod : this.directMethods) {
            for (DexAnnotation annotation : dexEncodedMethod.annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        for (DexEncodedMethod dexEncodedMethod : this.virtualMethods) {
            for (DexAnnotation annotation : dexEncodedMethod.annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        for (KeyedDexItem keyedDexItem : this.staticFields) {
            for (DexAnnotation annotation : ((DexEncodedField)keyedDexItem).annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        for (KeyedDexItem keyedDexItem : this.instanceFields) {
            for (DexAnnotation annotation : ((DexEncodedField)keyedDexItem).annotations.annotations) {
                if (annotation.annotation.type != factory.annotationReachabilitySensitive) continue;
                return true;
            }
        }
        return false;
    }
}

