/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.dex.DexParser;
import com.android.tools.r8.dex.DexSection;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.LinkedHashMap;

public class DexSegments {
    public static void main(String[] args) throws IOException, CompilationFailedException, ResourceException {
        Command.Builder builder = Command.parse(args);
        Command command = (Command)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(Command.USAGE_MESSAGE);
            return;
        }
        AndroidApp app = command.getInputApp();
        LinkedHashMap<String, SegmentInfo> result = new LinkedHashMap<String, SegmentInfo>();
        try (Closer closer = Closer.create();){
            for (ProgramResource resource : app.computeAllProgramResources()) {
                if (resource.getKind() != ProgramResource.Kind.DEX) continue;
                for (DexSection dexSection : DexParser.parseMapFrom(closer.register(resource.getByteStream()), resource.getOrigin())) {
                    SegmentInfo info = result.computeIfAbsent(dexSection.typeName(), key -> new SegmentInfo());
                    info.increment(dexSection.length, dexSection.size());
                }
            }
        }
        System.out.println("Segments in dex application (name: size / items):");
        result.forEach((key, value) -> System.out.println(" - " + key + ": " + ((SegmentInfo)value).size + " / " + ((SegmentInfo)value).items));
    }

    private static class SegmentInfo {
        private int items = 0;
        private int size = 0;

        SegmentInfo() {
        }

        void increment(int items, int size) {
            this.items += items;
            this.size += size;
        }
    }

    private static class Command
    extends BaseCommand {
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: dexsegments [options] <input-files>", " where <input-files> are dex files", "  --version               # Print the version of r8.", "  --help                  # Print this message."));

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) {
            Builder builder = Command.builder();
            Command.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private Command(AndroidApp inputApp) {
            super(inputApp);
        }

        private Command(boolean printHelp) {
            super(printHelp, false);
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }

        public static class Builder
        extends BaseCommand.Builder<Command, Builder> {
            @Override
            Builder self() {
                return this;
            }

            @Override
            protected Command makeCommand() {
                if (this.isPrintHelp()) {
                    return new Command(this.isPrintHelp());
                }
                return new Command(this.getAppBuilder().build());
            }
        }
    }
}

