/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.Reporter;
import java.nio.file.Path;
import java.util.ArrayList;

@Keep
public abstract class BaseCompilerCommand
extends BaseCommand {
    private final CompilationMode mode;
    private final ProgramConsumer programConsumer;
    private final StringConsumer mainDexListConsumer;
    private final int minApiLevel;
    private final Reporter reporter;
    private final boolean enableDesugaring;
    private final boolean optimizeMultidexForLinearAlloc;

    BaseCompilerCommand(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.programConsumer = null;
        this.mainDexListConsumer = null;
        this.mode = null;
        this.minApiLevel = 0;
        this.reporter = new Reporter();
        this.enableDesugaring = true;
        this.optimizeMultidexForLinearAlloc = false;
    }

    BaseCompilerCommand(AndroidApp app, CompilationMode mode, ProgramConsumer programConsumer2, StringConsumer mainDexListConsumer, int minApiLevel, Reporter reporter, boolean enableDesugaring, boolean optimizeMultidexForLinearAlloc) {
        super(app);
        assert (minApiLevel > 0);
        assert (mode != null);
        this.mode = mode;
        this.programConsumer = programConsumer2;
        this.mainDexListConsumer = mainDexListConsumer;
        this.minApiLevel = minApiLevel;
        this.reporter = reporter;
        this.enableDesugaring = enableDesugaring;
        this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
    }

    public CompilationMode getMode() {
        return this.mode;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    public ProgramConsumer getProgramConsumer() {
        return this.programConsumer;
    }

    public StringConsumer getMainDexListConsumer() {
        return this.mainDexListConsumer;
    }

    public boolean getEnableDesugaring() {
        return this.enableDesugaring;
    }

    public boolean isOptimizeMultidexForLinearAlloc() {
        return this.optimizeMultidexForLinearAlloc;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    @Keep
    public static abstract class Builder<C extends BaseCompilerCommand, B extends Builder<C, B>>
    extends BaseCommand.Builder<C, B> {
        private ProgramConsumer programConsumer = null;
        private StringConsumer mainDexListConsumer = null;
        private Path outputPath = null;
        private OutputMode outputMode = OutputMode.DexIndexed;
        private CompilationMode mode = this.defaultCompilationMode();
        private int minApiLevel = 0;
        private boolean disableDesugaring = false;
        private boolean optimizeMultidexForLinearAlloc = false;

        abstract CompilationMode defaultCompilationMode();

        Builder() {
        }

        Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        Builder(AndroidApp app) {
            super(AndroidApp.builder(app));
        }

        Builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
            super(AndroidApp.builder(app, new Reporter(diagnosticsHandler)));
        }

        public CompilationMode getMode() {
            return this.mode;
        }

        public B setMode(CompilationMode mode) {
            assert (mode != null);
            this.mode = mode;
            return (B)((Builder)this.self());
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public OutputMode getOutputMode() {
            return this.outputMode;
        }

        public ProgramConsumer getProgramConsumer() {
            return this.programConsumer;
        }

        public StringConsumer getMainDexListConsumer() {
            return this.mainDexListConsumer;
        }

        public B setOptimizeMultidexForLinearAlloc(boolean optimizeMultidexForLinearAlloc) {
            this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
            return (B)((Builder)this.self());
        }

        protected boolean isOptimizeMultidexForLinearAlloc() {
            return this.optimizeMultidexForLinearAlloc;
        }

        public B setProgramConsumer(ProgramConsumer programConsumer2) {
            this.outputPath = null;
            this.outputMode = null;
            this.programConsumer = programConsumer2;
            return (B)((Builder)this.self());
        }

        public B setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListConsumer = new StringConsumer.FileConsumer(mainDexListOutputPath);
            return (B)((Builder)this.self());
        }

        public B setMainDexListConsumer(StringConsumer mainDexListConsumer) {
            this.mainDexListConsumer = mainDexListConsumer;
            return (B)((Builder)this.self());
        }

        public B setOutput(Path outputPath, OutputMode outputMode) {
            return this.setOutput(outputPath, outputMode, false);
        }

        protected B setOutput(Path outputPath, OutputMode outputMode, boolean includeDataResources) {
            assert (outputPath != null);
            assert (outputMode != null);
            this.outputPath = outputPath;
            this.outputMode = outputMode;
            this.programConsumer = this.createProgramOutputConsumer(outputPath, outputMode, includeDataResources);
            return (B)((Builder)this.self());
        }

        protected InternalProgramOutputPathConsumer createProgramOutputConsumer(Path path, OutputMode mode, boolean consumeDataResources) {
            if (mode == OutputMode.DexIndexed) {
                return FileUtils.isArchive(path) ? new DexIndexedConsumer.ArchiveConsumer(path, consumeDataResources) : new DexIndexedConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            if (mode == OutputMode.DexFilePerClass) {
                if (FileUtils.isArchive(path)) {
                    return new DexFilePerClassFileConsumer.ArchiveConsumer(path, consumeDataResources){

                        @Override
                        public boolean combineSyntheticClassesWithPrimaryClass() {
                            return false;
                        }
                    };
                }
                return new DexFilePerClassFileConsumer.DirectoryConsumer(path, consumeDataResources){

                    @Override
                    public boolean combineSyntheticClassesWithPrimaryClass() {
                        return false;
                    }
                };
            }
            if (mode == OutputMode.DexFilePerClassFile) {
                return FileUtils.isArchive(path) ? new DexFilePerClassFileConsumer.ArchiveConsumer(path, consumeDataResources) : new DexFilePerClassFileConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            if (mode == OutputMode.ClassFile) {
                return FileUtils.isArchive(path) ? new ClassFileConsumer.ArchiveConsumer(path, consumeDataResources) : new ClassFileConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            throw new Unreachable("Unexpected output mode: " + (Object)((Object)mode));
        }

        public int getMinApiLevel() {
            return this.isMinApiLevelSet() ? this.minApiLevel : AndroidApiLevel.getDefault().getLevel();
        }

        boolean isMinApiLevelSet() {
            return this.minApiLevel != 0;
        }

        public B setMinApiLevel(int minApiLevel) {
            if (minApiLevel <= 0) {
                this.getReporter().error("Invalid minApiLevel: " + minApiLevel);
            } else {
                this.minApiLevel = minApiLevel;
            }
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B setEnableDesugaring(boolean enableDesugaring) {
            this.disableDesugaring = !enableDesugaring;
            return (B)((Builder)this.self());
        }

        public B setDisableDesugaring(boolean disableDesugaring) {
            this.disableDesugaring = disableDesugaring;
            return (B)((Builder)this.self());
        }

        public boolean getDisableDesugaring() {
            return this.disableDesugaring;
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.mode == null) {
                reporter.error("Expected valid compilation mode, was null");
            }
            FileUtils.validateOutputFile(this.outputPath, reporter);
            if (this.getProgramConsumer() == null) {
                reporter.error("A ProgramConsumer or Output is required for compilation");
            }
            ArrayList<Class<ClassFileConsumer>> programConsumerClasses = new ArrayList<Class<ClassFileConsumer>>(3);
            if (this.programConsumer instanceof DexIndexedConsumer) {
                programConsumerClasses.add(DexIndexedConsumer.class);
            }
            if (this.programConsumer instanceof DexFilePerClassFileConsumer) {
                programConsumerClasses.add(DexFilePerClassFileConsumer.class);
            }
            if (this.programConsumer instanceof ClassFileConsumer) {
                programConsumerClasses.add(ClassFileConsumer.class);
            }
            if (programConsumerClasses.size() > 1) {
                StringBuilder builder = new StringBuilder().append("Invalid program consumer.").append(" A program consumer can implement at most one consumer type but ").append(this.programConsumer.getClass().getName()).append(" implements types:");
                for (Class clazz : programConsumerClasses) {
                    builder.append(" ").append(clazz.getName());
                }
                reporter.error(builder.toString());
            }
            super.validate();
        }
    }
}

