/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.ProguardMap;
import com.android.tools.r8.naming.ProguardMapReader;
import com.android.tools.r8.utils.DescriptorUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ClassNameMapper
implements ProguardMap {
    private final ImmutableMap<String, ClassNamingForNameMapper> classNameMappings;
    private ImmutableBiMap<String, String> nameMapping;
    private final Map<MemberNaming.Signature, MemberNaming.Signature> signatureMap = new HashMap<MemberNaming.Signature, MemberNaming.Signature>();

    public static Builder builder() {
        return new Builder();
    }

    public static ClassNameMapper mapperFromInputStream(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try (ProguardMapReader proguardReader = new ProguardMapReader(reader);){
            Builder builder = ClassNameMapper.builder();
            proguardReader.parse(builder);
            ClassNameMapper classNameMapper = builder.build();
            return classNameMapper;
        }
    }

    public static ClassNameMapper mapperFromFile(Path path) throws IOException {
        return ClassNameMapper.mapperFromInputStream(Files.newInputStream(path, new OpenOption[0]));
    }

    public static ClassNameMapper mapperFromString(String contents) throws IOException {
        return ClassNameMapper.mapperFromInputStream(new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8)));
    }

    private ClassNameMapper(Map<String, ClassNamingForNameMapper.Builder> classNameMappings) {
        ImmutableMap.Builder<String, ClassNamingForNameMapper> builder = ImmutableMap.builder();
        for (Map.Entry<String, ClassNamingForNameMapper.Builder> entry : classNameMappings.entrySet()) {
            builder.put(entry.getKey(), entry.getValue().build());
        }
        this.classNameMappings = builder.build();
    }

    private MemberNaming.Signature canonicalizeSignature(MemberNaming.Signature signature) {
        MemberNaming.Signature result = this.signatureMap.get(signature);
        if (result != null) {
            return result;
        }
        this.signatureMap.put(signature, signature);
        return signature;
    }

    public MemberNaming.MethodSignature getRenamedMethodSignature(DexMethod method) {
        DexType[] parameters = method.proto.parameters.values;
        String[] parameterTypes = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = this.deobfuscateType(parameters[i].toDescriptorString());
        }
        String returnType = this.deobfuscateType(method.proto.returnType.toDescriptorString());
        MemberNaming.MethodSignature signature = new MemberNaming.MethodSignature(method.name.toString(), returnType, parameterTypes);
        return (MemberNaming.MethodSignature)this.canonicalizeSignature(signature);
    }

    public MemberNaming.FieldSignature getRenamedFieldSignature(DexField field) {
        String type = this.deobfuscateType(field.type.toDescriptorString());
        return (MemberNaming.FieldSignature)this.canonicalizeSignature(new MemberNaming.FieldSignature(field.name.toString(), type));
    }

    public String deobfuscateClassName(String obfuscatedName) {
        ClassNamingForNameMapper classNaming = this.classNameMappings.get(obfuscatedName);
        if (classNaming == null) {
            return obfuscatedName;
        }
        return classNaming.originalName;
    }

    private String deobfuscateType(String asString) {
        return DescriptorUtils.descriptorToJavaType(asString, this);
    }

    @Override
    public boolean hasMapping(DexType type) {
        String decoded = DescriptorUtils.descriptorToJavaType(type.descriptor.toString());
        return this.classNameMappings.containsKey(decoded);
    }

    @Override
    public ClassNamingForNameMapper getClassNaming(DexType type) {
        String decoded = DescriptorUtils.descriptorToJavaType(type.descriptor.toString());
        return this.classNameMappings.get(decoded);
    }

    public ClassNamingForNameMapper getClassNaming(String obfuscatedName) {
        return this.classNameMappings.get(obfuscatedName);
    }

    public void write(Writer writer) throws IOException {
        for (ClassNamingForNameMapper naming : this.classNameMappings.values()) {
            naming.write(writer);
        }
    }

    public void forAllClassNamings(Consumer<ClassNaming> consumer) {
        this.classNameMappings.values().forEach(consumer);
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public BiMap<String, String> getObfuscatedToOriginalMapping() {
        if (this.nameMapping == null) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (String name : this.classNameMappings.keySet()) {
                builder.put(name, this.classNameMappings.get((Object)name).originalName);
            }
            this.nameMapping = builder.build();
        }
        return this.nameMapping;
    }

    public boolean equals(Object o) {
        return o instanceof ClassNameMapper && this.classNameMappings.equals(((ClassNameMapper)o).classNameMappings);
    }

    public int hashCode() {
        return 31 * this.classNameMappings.hashCode();
    }

    public String originalNameOf(IndexedDexItem item) {
        if (item instanceof DexField) {
            return this.lookupName(this.getRenamedFieldSignature((DexField)item), ((DexField)item).clazz);
        }
        if (item instanceof DexMethod) {
            return this.lookupName(this.getRenamedMethodSignature((DexMethod)item), ((DexMethod)item).holder);
        }
        if (item instanceof DexType) {
            return DescriptorUtils.descriptorToJavaType(((DexType)item).toDescriptorString(), this);
        }
        return item.toString();
    }

    private String lookupName(MemberNaming.Signature signature, DexType clazz) {
        String decoded = DescriptorUtils.descriptorToJavaType(clazz.descriptor.toString());
        ClassNamingForNameMapper classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return decoded + " " + signature.toString();
        }
        MemberNaming memberNaming = classNaming.lookup(signature);
        if (memberNaming == null) {
            return classNaming.originalName + " " + signature.toString();
        }
        return classNaming.originalName + " " + memberNaming.signature.toString();
    }

    public MemberNaming.Signature originalSignatureOf(DexMethod method) {
        String decoded = DescriptorUtils.descriptorToJavaType(method.holder.descriptor.toString());
        MemberNaming.MethodSignature memberSignature = this.getRenamedMethodSignature(method);
        ClassNamingForNameMapper classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return memberSignature;
        }
        MemberNaming memberNaming = classNaming.lookup(memberSignature);
        if (memberNaming == null) {
            return memberSignature;
        }
        return memberNaming.signature;
    }

    public MemberNaming.FieldSignature originalSignatureOf(DexField field) {
        String decoded = DescriptorUtils.descriptorToJavaType(field.clazz.descriptor.toString());
        MemberNaming.FieldSignature memberSignature = this.getRenamedFieldSignature(field);
        ClassNamingForNameMapper classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return memberSignature;
        }
        MemberNaming memberNaming = classNaming.lookup(memberSignature);
        if (memberNaming == null) {
            return memberSignature;
        }
        return (MemberNaming.FieldSignature)memberNaming.signature;
    }

    public String originalNameOf(DexType clazz) {
        return this.deobfuscateType(clazz.descriptor.toString());
    }

    public static class Builder
    extends ProguardMap.Builder {
        final ImmutableMap.Builder<String, ClassNamingForNameMapper.Builder> mapBuilder = ImmutableMap.builder();

        private Builder() {
        }

        @Override
        public ClassNamingForNameMapper.Builder classNamingBuilder(String renamedName, String originalName) {
            ClassNamingForNameMapper.Builder classNamingBuilder = ClassNamingForNameMapper.builder(renamedName, originalName);
            this.mapBuilder.put(renamedName, classNamingBuilder);
            return classNamingBuilder;
        }

        @Override
        public ClassNameMapper build() {
            return new ClassNameMapper(this.mapBuilder.build());
        }
    }
}

