/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.builder.internal.aapt.AaptQueueThreadContext;
import com.android.builder.internal.aapt.QueuedResourceProcessor;
import com.android.builder.png.AaptProcess;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.android.ide.common.internal.ResourceCompilationException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueuedCruncher
extends QueuedResourceProcessor {
    private QueuedCruncher(String aaptLocation, ILogger iLogger, int cruncherProcesses) {
        super(aaptLocation, iLogger, cruncherProcesses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<File> compile(int key, final CompileResourceRequest request, ProcessOutputHandler processOutputHandler) throws ResourceCompilationException {
        final File outputFile = QueuedCruncher.compileOutputFor(request);
        final SettableFuture result = SettableFuture.create();
        try {
            AaptQueueThreadContext.QueuedJob aaptProcessJob = new AaptQueueThreadContext.QueuedJob(key, "Crunching " + request.getInputFile().getName(), new Task<AaptProcess>(){

                @Override
                public void run(Job<AaptProcess> job, JobContext<AaptProcess> context) throws IOException {
                    AaptProcess aapt = context.getPayload();
                    if (aapt == null) {
                        QueuedCruncher.this.logger.error(null, "Thread(%1$s) has a null payload", new Object[]{Thread.currentThread().getName()});
                        return;
                    }
                    aapt.crunch(request.getInputFile(), outputFile, job);
                }

                @Override
                public void finished() {
                    result.set((Object)outputFile);
                }

                @Override
                public void error(Throwable e) {
                    result.setException(e);
                }

                public String toString() {
                    return MoreObjects.toStringHelper((Object)this).add("from", (Object)request.getInputFile().getAbsolutePath()).add("to", (Object)outputFile.getAbsolutePath()).toString();
                }
            }, (ListenableFuture<File>)result);
            Map map = this.outstandingJobs;
            synchronized (map) {
                this.outstandingJobs.computeIfAbsent(key, k -> new ConcurrentLinkedQueue());
            }
            this.processingRequests.push(aaptProcessJob);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ResourceCompilationException((Throwable)e);
        }
        return result;
    }

    private static File compileOutputFor(CompileResourceRequest request) {
        if (request.getOutputDirectory().isDirectory()) {
            File parentDir = new File(request.getOutputDirectory(), request.getInputDirectoryName());
            FileUtils.mkdirs((File)parentDir);
            return new File(parentDir, request.getInputFile().getName());
        }
        return request.getOutputDirectory();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String aaptLocation;
        private ILogger logger;
        private int processesNumber = 0;

        public Builder executablePath(String aaptLocation) {
            this.aaptLocation = aaptLocation;
            return this;
        }

        public Builder logger(ILogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder numberOfProcesses(int processesNumber) {
            this.processesNumber = processesNumber;
            return this;
        }

        public QueuedCruncher build() {
            return Creator.INSTANCE.newCruncher(this.aaptLocation, this.logger, this.processesNumber);
        }
    }

    private static enum Creator {
        INSTANCE;

        private final Map<String, QueuedCruncher> sInstances = new ConcurrentHashMap<String, QueuedCruncher>();
        private final Object sLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueuedCruncher newCruncher(String aaptLocation, ILogger logger, int cruncherProcesses) {
            Object object = this.sLock;
            synchronized (object) {
                logger.verbose("QueuedCruncher is using %1$s%n", new Object[]{aaptLocation});
                if (!this.sInstances.containsKey(aaptLocation)) {
                    QueuedCruncher queuedCruncher = new QueuedCruncher(aaptLocation, logger, cruncherProcesses);
                    this.sInstances.put(aaptLocation, queuedCruncher);
                }
                return this.sInstances.get(aaptLocation);
            }
        }
    }
}

