/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip.compress;

import com.android.apkzlib.zip.CompressionResult;
import com.android.apkzlib.zip.Compressor;
import com.android.apkzlib.zip.utils.CloseableByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public abstract class ExecutorCompressor
implements Compressor {
    @Nonnull
    private final Executor executor;

    public ExecutorCompressor(@Nonnull Executor executor) {
        this.executor = executor;
    }

    @Override
    @Nonnull
    public ListenableFuture<CompressionResult> compress(@Nonnull CloseableByteSource source) {
        SettableFuture future = SettableFuture.create();
        this.executor.execute(() -> {
            try {
                future.set((Object)this.immediateCompress(source));
            }
            catch (Throwable e) {
                future.setException(e);
            }
        });
        return future;
    }

    @Nonnull
    protected abstract CompressionResult immediateCompress(@Nonnull CloseableByteSource var1) throws Exception;
}

