/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.builder.png.AaptProcess;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.QueueThreadContext;
import com.android.builder.tasks.Task;
import com.android.builder.tasks.WorkQueue;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.internal.PngException;
import com.android.utils.ILogger;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class QueuedCruncher
implements PngCruncher {
    private static final int DEFAULT_NUMBER_CRUNCHER_PROCESSES = Integer.max(5, Runtime.getRuntime().availableProcessors());
    private final String mAaptLocation;
    private final ILogger mLogger;
    private final WorkQueue<AaptProcess> mCrunchingRequests;
    private final Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> mOutstandingJobs = new ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>>();
    private final Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> mDoneJobs = new ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>>();
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final AtomicInteger keyProvider = new AtomicInteger(0);

    private QueuedCruncher(String aaptLocation, ILogger iLogger, int cruncherProcesses) {
        this.mAaptLocation = aaptLocation;
        this.mLogger = iLogger;
        QueueThreadContext<AaptProcess> queueThreadContext = new QueueThreadContext<AaptProcess>(){
            private final Map<String, AaptProcess> mAaptProcesses = new ConcurrentHashMap<String, AaptProcess>();

            @Override
            public void creation(Thread t) throws IOException {
                try {
                    AaptProcess aaptProcess = new AaptProcess.Builder(QueuedCruncher.this.mAaptLocation, QueuedCruncher.this.mLogger).start();
                    assert (aaptProcess != null);
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): created aapt slave, Process(%2$s)", new Object[]{Thread.currentThread().getName(), aaptProcess.hashCode()});
                    aaptProcess.waitForReady();
                    this.mAaptProcesses.put(t.getName(), aaptProcess);
                }
                catch (InterruptedException e) {
                    QueuedCruncher.this.mLogger.error((Throwable)e, "Cannot start slave process", new Object[0]);
                    e.printStackTrace();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runTask(Job<AaptProcess> job) throws Exception {
                job.runTask(new JobContext<AaptProcess>(this.mAaptProcesses.get(Thread.currentThread().getName())));
                ((ConcurrentLinkedQueue)QueuedCruncher.this.mOutstandingJobs.get(((QueuedJob)job).key)).remove(job);
                ConcurrentLinkedQueue<Job<AaptProcess>> jobs = (ConcurrentLinkedQueue<Job<AaptProcess>>)QueuedCruncher.this.mDoneJobs.get(((QueuedJob)job).key);
                Map map = QueuedCruncher.this.mDoneJobs;
                synchronized (map) {
                    if (jobs == null) {
                        jobs = new ConcurrentLinkedQueue<Job<AaptProcess>>();
                        QueuedCruncher.this.mDoneJobs.put(((QueuedJob)job).key, jobs);
                    }
                }
                jobs.add(job);
            }

            @Override
            public void destruction(Thread t) throws IOException, InterruptedException {
                AaptProcess aaptProcess = this.mAaptProcesses.get(Thread.currentThread().getName());
                if (aaptProcess != null) {
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): notify aapt slave shutdown, Process(%2$s)", new Object[]{Thread.currentThread().getName(), aaptProcess.hashCode()});
                    aaptProcess.shutdown();
                    this.mAaptProcesses.remove(t.getName());
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): Process(%2$d), after shutdown queue_size=%3$d", new Object[]{Thread.currentThread().getName(), aaptProcess.hashCode(), this.mAaptProcesses.size()});
                }
            }

            @Override
            public void shutdown() {
                if (!this.mAaptProcesses.isEmpty()) {
                    QueuedCruncher.this.mLogger.warning("Process list not empty", new Object[0]);
                    for (Map.Entry<String, AaptProcess> aaptProcessEntry : this.mAaptProcesses.entrySet()) {
                        QueuedCruncher.this.mLogger.warning("Thread(%1$s): queue not cleaned", new Object[]{aaptProcessEntry.getKey()});
                        try {
                            aaptProcessEntry.getValue().shutdown();
                        }
                        catch (Exception e) {
                            QueuedCruncher.this.mLogger.error((Throwable)e, "while shutting down" + aaptProcessEntry.getKey(), new Object[0]);
                        }
                    }
                }
                this.mAaptProcesses.clear();
            }
        };
        int cruncherProcessToUse = cruncherProcesses > 0 ? cruncherProcesses : DEFAULT_NUMBER_CRUNCHER_PROCESSES;
        this.mCrunchingRequests = new WorkQueue<AaptProcess>(this.mLogger, queueThreadContext, "png-cruncher", cruncherProcessToUse, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<File> crunchPng(int key, final File from, final File to) throws PngException {
        final SettableFuture result = SettableFuture.create();
        try {
            QueuedJob aaptProcessJob = new QueuedJob(key, "Cruncher " + from.getName(), new Task<AaptProcess>(){

                @Override
                public void run(Job<AaptProcess> job, JobContext<AaptProcess> context) throws IOException {
                    AaptProcess aapt = context.getPayload();
                    if (aapt == null) {
                        QueuedCruncher.this.mLogger.error(null, "Thread(%1$s) has a null payload", new Object[]{Thread.currentThread().getName()});
                        return;
                    }
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): submitting job %2$s to %3$d", new Object[]{Thread.currentThread().getName(), job.getJobTitle(), aapt.hashCode()});
                    aapt.crunch(from, to, job);
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): submitted job %2$s", new Object[]{Thread.currentThread().getName(), job.getJobTitle()});
                }

                @Override
                public void finished() {
                    result.set((Object)to);
                }

                @Override
                public void error(Exception e) {
                    result.setException((Throwable)e);
                }

                public String toString() {
                    return MoreObjects.toStringHelper((Object)this).add("from", (Object)from.getAbsolutePath()).add("to", (Object)to.getAbsolutePath()).toString();
                }
            }, (ListenableFuture<File>)result);
            ConcurrentLinkedQueue<Job<AaptProcess>> jobs = this.mOutstandingJobs.get(key);
            Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> map = this.mOutstandingJobs;
            synchronized (map) {
                if (jobs == null) {
                    jobs = new ConcurrentLinkedQueue();
                    this.mOutstandingJobs.put(key, jobs);
                }
            }
            this.mCrunchingRequests.push(aaptProcessJob);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PngException((Throwable)e);
        }
        return result;
    }

    private void waitForAll(int key) throws InterruptedException {
        this.mLogger.verbose("Thread(%1$s): begin waitForAll", new Object[]{Thread.currentThread().getName()});
        ConcurrentLinkedQueue<Job<AaptProcess>> jobs = this.mOutstandingJobs.get(key);
        Job<AaptProcess> aaptProcessJob = jobs.poll();
        boolean hasExceptions = false;
        while (aaptProcessJob != null) {
            this.mLogger.verbose("Thread(%1$s) : wait for {%2$s)", new Object[]{Thread.currentThread().getName(), aaptProcessJob.toString()});
            try {
                aaptProcessJob.awaitRethrowExceptions();
            }
            catch (ExecutionException e) {
                this.mLogger.verbose("Exception while crunching png : " + aaptProcessJob.toString() + " : " + e.getCause(), new Object[0]);
                hasExceptions = true;
            }
            aaptProcessJob = jobs.poll();
        }
        jobs = this.mDoneJobs.get(key);
        while ((aaptProcessJob = jobs.poll()) != null) {
            try {
                aaptProcessJob.awaitRethrowExceptions();
            }
            catch (ExecutionException e) {
                this.mLogger.verbose("Exception while crunching png : " + aaptProcessJob.toString() + " : " + e.getCause(), new Object[0]);
                hasExceptions = true;
            }
        }
        if (hasExceptions) {
            throw new RuntimeException("Some file crunching failed, see logs for details");
        }
        this.mLogger.verbose("Thread(%1$s): end waitForAll", new Object[]{Thread.currentThread().getName()});
    }

    public synchronized int start() {
        this.refCount.incrementAndGet();
        int key = this.keyProvider.incrementAndGet();
        this.mOutstandingJobs.put(key, new ConcurrentLinkedQueue());
        this.mDoneJobs.put(key, new ConcurrentLinkedQueue());
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void end(int key) throws InterruptedException {
        block7: {
            long startTime = System.currentTimeMillis();
            try {
                this.waitForAll(key);
                this.mOutstandingJobs.get(key).clear();
                this.mLogger.verbose("Job finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
                if (this.refCount.decrementAndGet() != 0) break block7;
            }
            catch (Throwable throwable) {
                if (this.refCount.decrementAndGet() == 0) {
                    try {
                        this.mCrunchingRequests.shutdown();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        this.mLogger.warning("Error while shutting down crunching queue : %s", new Object[]{e.getMessage()});
                    }
                    this.mLogger.verbose("Shutdown finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
                }
                throw throwable;
            }
            try {
                this.mCrunchingRequests.shutdown();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.mLogger.warning("Error while shutting down crunching queue : %s", new Object[]{e.getMessage()});
            }
            this.mLogger.verbose("Shutdown finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
        }
    }

    private static final class QueuedJob
    extends Job<AaptProcess> {
        private final int key;

        public QueuedJob(int key, String jobTile, Task<AaptProcess> task, ListenableFuture<File> resultFuture) {
            super(jobTile, task, resultFuture);
            this.key = key;
        }
    }

    public static enum Builder {
        INSTANCE;

        private final Map<String, QueuedCruncher> sInstances = new ConcurrentHashMap<String, QueuedCruncher>();
        private final Object sLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueuedCruncher newCruncher(String aaptLocation, ILogger logger, int cruncherProcesses) {
            Object object = this.sLock;
            synchronized (object) {
                logger.verbose("QueuedCruncher is using %1$s", new Object[]{aaptLocation});
                if (!this.sInstances.containsKey(aaptLocation)) {
                    QueuedCruncher queuedCruncher = new QueuedCruncher(aaptLocation, logger, cruncherProcesses);
                    this.sInstances.put(aaptLocation, queuedCruncher);
                }
                return this.sInstances.get(aaptLocation);
            }
        }
    }
}

