/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;

public enum VariantType {
    DEFAULT(false, GradleBuildVariant.VariantType.APPLICATION),
    INSTANTAPP(false, GradleBuildVariant.VariantType.INSTANTAPP),
    LIBRARY(true, GradleBuildVariant.VariantType.LIBRARY),
    ATOM(true, GradleBuildVariant.VariantType.ATOM),
    ANDROID_TEST("androidTest", "AndroidTest", true, "_android_test_", 1, GradleBuildVariant.VariantType.ANDROID_TEST),
    UNIT_TEST("test", "UnitTest", false, "_unit_test_", 2, GradleBuildVariant.VariantType.UNIT_TEST);

    private final boolean mIsForTesting;
    private final String mPrefix;
    private final String mSuffix;
    private final boolean isSingleBuildType;
    private final String mArtifactName;
    private final int mArtifactType;
    private final boolean exportsDataBindingClassList;
    private final GradleBuildVariant.VariantType mAnalyticsVariantType;

    public static ImmutableList<VariantType> getTestingTypes() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (VariantType variantType : VariantType.values()) {
            if (!variantType.isForTesting()) continue;
            result.add((Object)variantType);
        }
        return result.build();
    }

    private VariantType(boolean exportsDataBindingClassList, GradleBuildVariant.VariantType analyticsVariantType) {
        this.mIsForTesting = false;
        this.mPrefix = "";
        this.mSuffix = "";
        this.mArtifactName = "_main_";
        this.mArtifactType = 1;
        this.isSingleBuildType = false;
        this.exportsDataBindingClassList = exportsDataBindingClassList;
        this.mAnalyticsVariantType = analyticsVariantType;
    }

    private VariantType(String prefix, String suffix, boolean isSingleBuildType, String artifactName, int artifactType, GradleBuildVariant.VariantType analyticsVariantType) {
        this.mArtifactName = artifactName;
        this.mArtifactType = artifactType;
        this.mIsForTesting = true;
        this.mPrefix = prefix;
        this.mSuffix = suffix;
        this.isSingleBuildType = isSingleBuildType;
        this.exportsDataBindingClassList = false;
        this.mAnalyticsVariantType = analyticsVariantType;
    }

    public boolean isForTesting() {
        return this.mIsForTesting;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public String getArtifactName() {
        return this.mArtifactName;
    }

    public int getArtifactType() {
        return this.mArtifactType;
    }

    public boolean isSingleBuildType() {
        return this.isSingleBuildType;
    }

    public boolean isExportDataBindingClassList() {
        return this.exportsDataBindingClassList;
    }

    public GradleBuildVariant.VariantType getAnalyticsVariantType() {
        return this.mAnalyticsVariantType;
    }
}

