/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip;

import com.android.apkzlib.zip.GPFlags;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class EncodeUtils {
    private EncodeUtils() {
    }

    @Nonnull
    public static String decode(@Nonnull ByteBuffer bytes, int length, @Nonnull GPFlags flags) throws IOException {
        if (bytes.remaining() < length) {
            throw new IOException("Only " + bytes.remaining() + " bytes exist in the buffer, but length is " + length + ".");
        }
        Charset charset = EncodeUtils.flagsCharset(flags);
        byte[] stringBytes = new byte[length];
        bytes.get(stringBytes);
        return charset.decode(ByteBuffer.wrap(stringBytes)).toString();
    }

    @Nonnull
    public static String decode(@Nonnull byte[] data, @Nonnull GPFlags flags) {
        Charset charset = EncodeUtils.flagsCharset(flags);
        return charset.decode(ByteBuffer.wrap(data)).toString();
    }

    @Nonnull
    public static byte[] encode(@Nonnull String name, @Nonnull GPFlags flags) {
        Charset charset = EncodeUtils.flagsCharset(flags);
        ByteBuffer bytes = charset.encode(name);
        byte[] result = new byte[bytes.remaining()];
        bytes.get(result);
        return result;
    }

    @Nonnull
    private static Charset flagsCharset(@Nonnull GPFlags flags) {
        if (flags.isUtf8FileName()) {
            return Charsets.UTF_8;
        }
        return Charsets.US_ASCII;
    }

    public static boolean canAsciiEncode(String text) {
        return Charsets.US_ASCII.newEncoder().canEncode(text);
    }
}

