/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.tasks;

import com.android.builder.tasks.Job;
import com.android.builder.tasks.QueueThreadContext;
import com.android.utils.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkQueue<T>
implements Runnable {
    private static final boolean VERBOSE = System.getenv("GRADLE_WORK_QUEUE_VERBOSE") != null;
    private final ILogger mLogger;
    private final String mName;
    private final LinkedBlockingQueue<QueueTask<T>> mPendingJobs = new LinkedBlockingQueue();
    private final List<Thread> mWorkThreads = new ArrayList<Thread>();
    private final float mGrowthTriggerRation;
    private final int mMWorkforceIncrement;
    private final AtomicInteger mThreadId = new AtomicInteger(0);
    private final QueueThreadContext<T> mQueueThreadContext;
    private static final int MAX_WORKFORCE_SIZE = 20;

    public WorkQueue(ILogger logger, QueueThreadContext<T> queueThreadContext, String queueName, int workforce) {
        this(logger, queueThreadContext, queueName, workforce, Float.MAX_VALUE);
    }

    public WorkQueue(ILogger logger, QueueThreadContext<T> queueThreadContext, String queueName, int workforce, float growthTriggerRatio) {
        this.mLogger = logger;
        this.mName = queueName;
        this.mGrowthTriggerRation = growthTriggerRatio;
        this.mMWorkforceIncrement = workforce;
        this.mQueueThreadContext = queueThreadContext;
    }

    public void push(Job<T> job) throws InterruptedException {
        this._push(new QueueTask(QueueTask.ActionType.Normal, job));
        this.checkWorkforce();
    }

    private void _push(QueueTask<T> task) throws InterruptedException {
        this.mPendingJobs.put(task);
    }

    private synchronized void checkWorkforce() {
        if (this.mWorkThreads.isEmpty() || (float)(this.mPendingJobs.size() / this.mWorkThreads.size()) > this.mGrowthTriggerRation) {
            this.verbose("Request to incrementing workforce from %1$d", this.mWorkThreads.size());
            if (this.mWorkThreads.size() >= 20) {
                this.verbose("Already at max workforce %1$d, denied.", 20);
                return;
            }
            for (int i = 0; i < this.mMWorkforceIncrement; ++i) {
                Thread t = new Thread((Runnable)this, this.mName + "_" + this.mThreadId.incrementAndGet());
                t.setDaemon(true);
                this.mWorkThreads.add(t);
                t.start();
            }
            this.verbose("thread-pool size=%1$d", this.mWorkThreads.size());
        }
    }

    private synchronized void reduceWorkforce() throws InterruptedException {
        this.verbose("Decrementing workforce from " + this.mWorkThreads.size(), new Object[0]);
        for (int i = 0; i < this.mMWorkforceIncrement; ++i) {
            this._push(new QueueTask(QueueTask.ActionType.Death, null));
        }
    }

    public synchronized void shutdown() throws InterruptedException {
        for (Thread t : this.mWorkThreads) {
            this._push(new QueueTask(QueueTask.ActionType.Death, null));
        }
        for (Thread t : this.mWorkThreads) {
            t.join();
        }
        this.mWorkThreads.clear();
        this.mQueueThreadContext.shutdown();
    }

    public String getName() {
        return this.mName;
    }

    public int size() {
        return this.mPendingJobs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        threadName = Thread.currentThread().getName();
        try {
            try {
                this.verbose("Creating a new working thread %1$s", new Object[]{threadName});
                this.mQueueThreadContext.creation(Thread.currentThread());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
lbl9:
            // 3 sources

            while (true) {
                queueTask = this.mPendingJobs.take();
                if (queueTask.actionType == QueueTask.ActionType.Death) {
                    this.verbose("Thread(%1$s): Death requested", new Object[]{threadName});
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (InterruptedException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): Interrupted", new Object[]{threadName});
            try {
                this.verbose("Thread(%1$s): destruction", new Object[]{threadName});
                this.mQueueThreadContext.destruction(Thread.currentThread());
                return;
            }
            catch (IOException | InterruptedException e) {
                this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
                return;
            }
        }
        catch (Throwable var6_12) {
            try {
                this.verbose("Thread(%1$s): destruction", new Object[]{threadName});
                this.mQueueThreadContext.destruction(Thread.currentThread());
                throw var6_12;
            }
            catch (IOException | InterruptedException e) {
                this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
            }
            throw var6_12;
        }
        try {
            this.verbose("Thread(%1$s): destruction", new Object[]{threadName});
            this.mQueueThreadContext.destruction(Thread.currentThread());
            return;
        }
        catch (IOException | InterruptedException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
        }
        return;
lbl-1000:
        // 1 sources

        {
            job = queueTask.job;
            if (job != null) ** GOTO lbl-1000
            this.mLogger.error(null, "I got a null pending job out of the priority queue", new Object[0]);
        }
        try {
            this.verbose("Thread(%1$s): destruction", new Object[]{threadName});
            this.mQueueThreadContext.destruction(Thread.currentThread());
            return;
        }
        catch (IOException | InterruptedException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
        }
        return;
lbl-1000:
        // 1 sources

        {
            this.verbose("Thread(%1$s): scheduling %2$s", new Object[]{threadName, job.getJobTitle()});
            try {
                this.mQueueThreadContext.runTask(job);
            }
            catch (Exception e) {
                this.mLogger.warning("Exception while processing task %1$s", new Object[]{e});
                job.error(e);
                try {
                    this.verbose("Thread(%1$s): destruction", new Object[]{threadName});
                    this.mQueueThreadContext.destruction(Thread.currentThread());
                    return;
                }
                catch (IOException | InterruptedException e) {
                    this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
                }
                return;
            }
        }
        {
            result = job.await();
            this.verbose("Thread(%1$s): job %2$s finished, result=%3$b", new Object[]{threadName, job.getJobTitle(), result});
            this.verbose("Thread(%1$s): queue size %2$d", new Object[]{threadName, this.mPendingJobs.size()});
            ** continue;
        }
    }

    private void verbose(String format, Object ... args) {
        if (VERBOSE) {
            this.mLogger.verbose(format, args);
        }
    }

    private static class QueueTask<T> {
        final ActionType actionType;
        final Job<T> job;

        private QueueTask(ActionType actionType, Job<T> job) {
            this.actionType = actionType;
            this.job = job;
        }

        static enum ActionType {
            Death,
            Normal;

        }
    }
}

