/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.builder.packaging.ApkCreator;
import com.android.builder.packaging.NativeLibrariesPackagingMode;
import com.android.builder.packaging.PackagerException;
import com.google.common.base.Preconditions;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Predicate;

public interface ApkCreatorFactory {
    public ApkCreator make(CreationData var1) throws PackagerException;

    public static class CreationData {
        private final File mApkPath;
        private final PrivateKey mKey;
        private final X509Certificate mCertificate;
        private final boolean mV1SigningEnabled;
        private final boolean mV2SigningEnabled;
        private final String mBuiltBy;
        private final String mCreatedBy;
        private final int mMinSdkVersion;
        private final NativeLibrariesPackagingMode mNativeLibrariesPackagingMode;
        private final Predicate<String> mNoCompressPredicate;

        public CreationData(File apkPath, PrivateKey key, X509Certificate certificate, boolean v1SigningEnabled, boolean v2SigningEnabled, String builtBy, String createdBy, int minSdkVersion, NativeLibrariesPackagingMode nativeLibrariesPackagingMode, Predicate<String> noCompressPredicate) {
            Preconditions.checkArgument((key == null == (certificate == null) ? 1 : 0) != 0, (Object)"(key == null) != (certificate == null)");
            Preconditions.checkArgument((minSdkVersion >= 0 ? 1 : 0) != 0, (Object)"minSdkVersion < 0");
            this.mApkPath = apkPath;
            this.mKey = key;
            this.mCertificate = certificate;
            this.mV1SigningEnabled = v1SigningEnabled;
            this.mV2SigningEnabled = v2SigningEnabled;
            this.mBuiltBy = builtBy;
            this.mCreatedBy = createdBy;
            this.mMinSdkVersion = minSdkVersion;
            this.mNativeLibrariesPackagingMode = (NativeLibrariesPackagingMode)((Object)Preconditions.checkNotNull((Object)((Object)nativeLibrariesPackagingMode)));
            this.mNoCompressPredicate = (Predicate)Preconditions.checkNotNull(noCompressPredicate);
        }

        public File getApkPath() {
            return this.mApkPath;
        }

        public PrivateKey getPrivateKey() {
            return this.mKey;
        }

        public X509Certificate getCertificate() {
            return this.mCertificate;
        }

        public boolean isV1SigningEnabled() {
            return this.mV1SigningEnabled;
        }

        public boolean isV2SigningEnabled() {
            return this.mV2SigningEnabled;
        }

        public String getBuiltBy() {
            return this.mBuiltBy;
        }

        public String getCreatedBy() {
            return this.mCreatedBy;
        }

        public int getMinSdkVersion() {
            return this.mMinSdkVersion;
        }

        public NativeLibrariesPackagingMode getNativeLibrariesPackagingMode() {
            return this.mNativeLibrariesPackagingMode;
        }

        public Predicate<String> getNoCompressPredicate() {
            return this.mNoCompressPredicate;
        }
    }
}

