/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.FileUseMapEntry;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

class FileUseMap {
    private long mSize;
    private TreeSet<FileUseMapEntry<?>> mMap;
    private TreeSet<FileUseMapEntry<?>> mFree;
    private int mMinFreeSize;

    FileUseMap(long size, int minFreeSize) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size < 0");
        Preconditions.checkArgument((minFreeSize >= 0 ? 1 : 0) != 0, (Object)"minFreeSize < 0");
        this.mSize = size;
        this.mMap = new TreeSet(FileUseMapEntry.COMPARE_BY_START);
        this.mFree = new TreeSet(FileUseMapEntry.COMPARE_BY_SIZE);
        this.mMinFreeSize = minFreeSize;
        if (size > 0L) {
            this.internalAdd(FileUseMapEntry.makeFree(0L, size));
        }
    }

    private void internalAdd(FileUseMapEntry<?> entry) {
        this.mMap.add(entry);
        if (entry.isFree()) {
            this.mFree.add(entry);
        }
    }

    private void internalRemove(FileUseMapEntry<?> entry) {
        boolean wasRemoved = this.mMap.remove(entry);
        Preconditions.checkState((boolean)wasRemoved, (Object)"entry not in mMap");
        if (entry.isFree()) {
            this.mFree.remove(entry);
        }
    }

    private void add(FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((entry.getStart() < this.mSize ? 1 : 0) != 0, (Object)"entry.getStart() >= mSize");
        Preconditions.checkArgument((entry.getEnd() <= this.mSize ? 1 : 0) != 0, (Object)"entry.getEnd() > mSize");
        Preconditions.checkArgument((!entry.isFree() ? 1 : 0) != 0, (Object)"entry.isFree()");
        FileUseMapEntry<?> container = this.findContainer(entry);
        Verify.verify((boolean)container.isFree(), (String)"!container.isFree()", (Object[])new Object[0]);
        Set<FileUseMapEntry<?>> replacements = FileUseMap.split(container, entry);
        this.internalRemove(container);
        for (FileUseMapEntry<?> r : replacements) {
            this.internalAdd(r);
        }
    }

    void remove(FileUseMapEntry<?> entry) {
        Preconditions.checkState((boolean)this.mMap.contains(entry), (Object)"!mMap.contains(entry)");
        Preconditions.checkArgument((!entry.isFree() ? 1 : 0) != 0, (Object)"entry.isFree()");
        this.internalRemove(entry);
        FileUseMapEntry<Object> replacement = FileUseMapEntry.makeFree(entry.getStart(), entry.getEnd());
        this.internalAdd(replacement);
        this.coalesce(replacement);
    }

    <T> FileUseMapEntry<T> add(long start, long end, T store) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start < 0");
        Preconditions.checkArgument((end > start ? 1 : 0) != 0, (Object)"end < start");
        FileUseMapEntry<T> entry = FileUseMapEntry.makeUsed(start, end, store);
        this.add(entry);
        return entry;
    }

    private FileUseMapEntry<?> findContainer(FileUseMapEntry<?> entry) {
        FileUseMapEntry<?> container = this.mMap.floor(entry);
        Verify.verifyNotNull(container);
        Verify.verify((container.getStart() <= entry.getStart() ? 1 : 0) != 0);
        Verify.verify((container.getEnd() >= entry.getEnd() ? 1 : 0) != 0);
        return container;
    }

    private static Set<FileUseMapEntry<?>> split(FileUseMapEntry<?> container, FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((boolean)container.isFree(), (Object)"!container.isFree()");
        long farStart = container.getStart();
        long start = entry.getStart();
        long end = entry.getEnd();
        long farEnd = container.getEnd();
        Verify.verify((farStart <= start ? 1 : 0) != 0, (String)"farStart > start", (Object[])new Object[0]);
        Verify.verify((start < end ? 1 : 0) != 0, (String)"start >= end", (Object[])new Object[0]);
        Verify.verify((farEnd >= end ? 1 : 0) != 0, (String)"farEnd < end", (Object[])new Object[0]);
        HashSet result = Sets.newHashSet();
        if (farStart < start) {
            result.add(FileUseMapEntry.makeFree(farStart, start));
        }
        result.add(entry);
        if (end < farEnd) {
            result.add(FileUseMapEntry.makeFree(end, farEnd));
        }
        return result;
    }

    private void coalesce(FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((boolean)entry.isFree(), (Object)"!entry.isFree()");
        FileUseMapEntry<Object> prevToMerge = null;
        long start = entry.getStart();
        if (start > 0L) {
            prevToMerge = this.mMap.floor(FileUseMapEntry.makeFree(start - 1L, start));
            Verify.verifyNotNull(prevToMerge);
            if (!prevToMerge.isFree()) {
                prevToMerge = null;
            }
        }
        FileUseMapEntry<Object> nextToMerge = null;
        long end = entry.getEnd();
        if (end < this.mSize) {
            nextToMerge = this.mMap.ceiling(FileUseMapEntry.makeFree(end, end + 1L));
            Verify.verifyNotNull(nextToMerge);
            if (!nextToMerge.isFree()) {
                nextToMerge = null;
            }
        }
        if (prevToMerge == null && nextToMerge == null) {
            return;
        }
        long newStart = start;
        if (prevToMerge != null) {
            newStart = prevToMerge.getStart();
            this.internalRemove(prevToMerge);
        }
        long newEnd = end;
        if (nextToMerge != null) {
            newEnd = nextToMerge.getEnd();
            this.internalRemove(nextToMerge);
        }
        this.internalRemove(entry);
        this.internalAdd(FileUseMapEntry.makeFree(newStart, newEnd));
    }

    void truncate() {
        if (this.mSize == 0L) {
            return;
        }
        FileUseMapEntry<?> last = this.mMap.last();
        Verify.verifyNotNull(last, (String)"last == null", (Object[])new Object[0]);
        if (last.isFree()) {
            this.internalRemove(last);
            this.mSize = last.getStart();
        }
    }

    long size() {
        return this.mSize;
    }

    long usedSize() {
        if (this.mSize == 0L) {
            return 0L;
        }
        FileUseMapEntry<?> last = this.mMap.last();
        Verify.verifyNotNull(last, (String)"last == null", (Object[])new Object[0]);
        if (last.isFree()) {
            return last.getStart();
        }
        Verify.verify((last.getEnd() == this.mSize ? 1 : 0) != 0);
        return this.mSize;
    }

    void extend(long size) {
        Preconditions.checkArgument((size >= this.mSize ? 1 : 0) != 0, (Object)"size < mSize");
        if (this.mSize == size) {
            return;
        }
        FileUseMapEntry<Object> newBlock = FileUseMapEntry.makeFree(this.mSize, size);
        this.internalAdd(newBlock);
        this.mSize = size;
        this.coalesce(newBlock);
    }

    long locateFree(long size, long alignOffset, long align) {
        FileUseMapEntry<?> last;
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"size <= 0");
        FileUseMapEntry<Object> minimumSizedEntry = FileUseMapEntry.makeFree(0L, size);
        SortedSet<FileUseMapEntry<Object>> matches = this.mFree.tailSet(minimumSizedEntry);
        FileUseMapEntry best = null;
        long bestExtraSize = 0L;
        for (FileUseMapEntry fileUseMapEntry : matches) {
            FileUseMapEntry next;
            if (!fileUseMapEntry.isFree()) continue;
            long extraSize = align == 0L ? 0L : (align - (fileUseMapEntry.getStart() + alignOffset) % align) % align;
            if (fileUseMapEntry.getSize() < size + extraSize || extraSize > 0L && extraSize < (long)this.mMinFreeSize || this.mMinFreeSize > 0 && (next = this.mMap.higher(fileUseMapEntry)) != null && !next.isFree() && fileUseMapEntry.getSize() - (size + extraSize) < (long)this.mMinFreeSize || best != null && best.getSize() < fileUseMapEntry.getSize()) continue;
            best = fileUseMapEntry;
            bestExtraSize = extraSize;
        }
        long firstFree = this.mSize;
        if (best == null && !this.mMap.isEmpty() && (last = this.mMap.last()).isFree()) {
            firstFree = last.getStart();
        }
        if (best == null) {
            long extra = (align - (firstFree + alignOffset) % align) % align;
            if (extra > 0L && extra < (long)this.mMinFreeSize) {
                extra += align * (((long)this.mMinFreeSize - extra + (align - 1L)) / align);
            }
            return firstFree + extra;
        }
        return best.getStart() + bestExtraSize;
    }

    List<FileUseMapEntry<?>> getFreeAreas() {
        ArrayList freeAreas = Lists.newArrayList();
        for (FileUseMapEntry<?> area : this.mMap) {
            if (!area.isFree() || area.getEnd() == this.mSize) continue;
            freeAreas.add(area);
        }
        return freeAreas;
    }

    FileUseMapEntry<?> before(FileUseMapEntry<?> entry) {
        Preconditions.checkNotNull(entry, (Object)"entry == null");
        return this.mMap.lower(entry);
    }
}

