/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.sign.v2;

import com.android.builder.internal.packaging.sign.v2.DigestSource;
import com.google.common.base.Preconditions;
import java.security.MessageDigest;

public class ByteArrayDigestSource
implements DigestSource {
    private final byte[] mBuf;

    public ByteArrayDigestSource(byte[] buf) {
        this.mBuf = buf;
    }

    @Override
    public long size() {
        return this.mBuf.length;
    }

    @Override
    public void feedDigests(long offset, int size, MessageDigest[] digests) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset: %s", (Object[])new Object[]{offset});
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"size: %s", (Object[])new Object[]{size});
        Preconditions.checkArgument((offset <= (long)this.mBuf.length ? 1 : 0) != 0, (String)"offset too large: %s", (Object[])new Object[]{offset});
        int offsetInBuf = (int)offset;
        Preconditions.checkPositionIndex((int)offsetInBuf, (int)this.mBuf.length, (String)"offset out of range");
        int availableSize = this.mBuf.length - offsetInBuf;
        Preconditions.checkArgument((size <= availableSize ? 1 : 0) != 0, (String)"offset (%s) + size (%s) > array length (%s)", (Object[])new Object[]{offset, size, this.mBuf.length});
        for (MessageDigest md : digests) {
            md.update(this.mBuf, offsetInBuf, size);
        }
    }
}

