/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.sign.v2;

import com.android.builder.internal.packaging.sign.v2.ContentDigestAlgorithm;
import com.android.builder.internal.packaging.sign.v2.DigestSource;
import com.android.builder.internal.packaging.sign.v2.SignatureAlgorithm;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ApkSignerV2 {
    private static final int CONTENT_DIGESTED_CHUNK_MAX_SIZE_BYTES = 0x100000;
    private static final byte[] APK_SIGNING_BLOCK_MAGIC = new byte[]{65, 80, 75, 32, 83, 105, 103, 32, 66, 108, 111, 99, 107, 32, 52, 50};
    private static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;

    private ApkSignerV2() {
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey signingKey, int minSdkVersion) throws InvalidKeyException {
        String keyAlgorithm = signingKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            int modulusLengthBits = ((RSAKey)((Object)signingKey)).getModulus().bitLength();
            if (modulusLengthBits <= 3072) {
                return ImmutableList.of((Object)((Object)SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256));
            }
            return ImmutableList.of((Object)((Object)SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512));
        }
        if ("DSA".equalsIgnoreCase(keyAlgorithm)) {
            return ImmutableList.of((Object)((Object)SignatureAlgorithm.DSA_WITH_SHA256));
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            int keySizeBits = ((ECKey)((Object)signingKey)).getParams().getOrder().bitLength();
            if (keySizeBits <= 256) {
                return ImmutableList.of((Object)((Object)SignatureAlgorithm.ECDSA_WITH_SHA256));
            }
            return ImmutableList.of((Object)((Object)SignatureAlgorithm.ECDSA_WITH_SHA512));
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + keyAlgorithm);
    }

    public static byte[] generateApkSigningBlock(DigestSource beforeCentralDir, DigestSource centralDir, DigestSource eocd, List<SignerConfig> signerConfigs) throws InvalidKeyException, SignatureException {
        Map<ContentDigestAlgorithm, byte[]> contentDigests;
        if (signerConfigs.isEmpty()) {
            throw new IllegalArgumentException("No signer configs provided. At least one is required");
        }
        HashSet contentDigestAlgorithms = Sets.newHashSetWithExpectedSize((int)1);
        for (SignerConfig signerConfig : signerConfigs) {
            for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
                contentDigestAlgorithms.add(signatureAlgorithm.getContentDigestAlgorithm());
            }
        }
        try {
            contentDigests = ApkSignerV2.computeContentDigests(contentDigestAlgorithms, new DigestSource[]{beforeCentralDir, centralDir, eocd});
        }
        catch (DigestException e) {
            throw new SignatureException("Failed to compute digests of APK", e);
        }
        return ApkSignerV2.generateApkSigningBlock(signerConfigs, contentDigests);
    }

    private static Map<ContentDigestAlgorithm, byte[]> computeContentDigests(Set<ContentDigestAlgorithm> digestAlgorithms, DigestSource[] contents) throws DigestException {
        long chunkCountLong = 0L;
        for (DigestSource input : contents) {
            chunkCountLong += ApkSignerV2.getChunkCount(input.size(), 0x100000);
        }
        if (chunkCountLong >= Integer.MAX_VALUE) {
            throw new DigestException("Input too long: " + chunkCountLong + " chunks");
        }
        int chunkCount = (int)chunkCountLong;
        ContentDigestAlgorithm[] digestAlgorithmsArray = digestAlgorithms.toArray(new ContentDigestAlgorithm[digestAlgorithms.size()]);
        MessageDigest[] mds = new MessageDigest[digestAlgorithmsArray.length];
        byte[][] digestsOfChunks = new byte[digestAlgorithmsArray.length][];
        int[] digestOutputSizes = new int[digestAlgorithmsArray.length];
        for (int i = 0; i < digestAlgorithmsArray.length; ++i) {
            int digestOutputSizeBytes;
            ContentDigestAlgorithm digestAlgorithm = digestAlgorithmsArray[i];
            digestOutputSizes[i] = digestOutputSizeBytes = digestAlgorithm.getChunkDigestOutputSizeBytes();
            byte[] concatenationOfChunkCountAndChunkDigests = new byte[5 + chunkCount * digestOutputSizeBytes];
            concatenationOfChunkCountAndChunkDigests[0] = 90;
            ApkSignerV2.setUnsignedInt32LittleEndian(chunkCount, concatenationOfChunkCountAndChunkDigests, 1);
            digestsOfChunks[i] = concatenationOfChunkCountAndChunkDigests;
            String jcaAlgorithmName = digestAlgorithm.getJcaMessageDigestAlgorithmName();
            try {
                mds[i] = MessageDigest.getInstance(jcaAlgorithmName);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(jcaAlgorithmName + " MessageDigest not supported", e);
            }
        }
        byte[] chunkContentPrefix = new byte[5];
        chunkContentPrefix[0] = -91;
        int chunkIndex = 0;
        for (DigestSource input : contents) {
            long inputOffset = 0L;
            long inputRemaining = input.size();
            while (inputRemaining > 0L) {
                int i;
                int chunkSize = (int)Math.min(inputRemaining, 0x100000L);
                ApkSignerV2.setUnsignedInt32LittleEndian(chunkSize, chunkContentPrefix, 1);
                for (i = 0; i < mds.length; ++i) {
                    mds[i].update(chunkContentPrefix);
                }
                try {
                    input.feedDigests(inputOffset, chunkSize, mds);
                }
                catch (IOException e) {
                    throw new DigestException("Failed to digest chunk #" + chunkIndex, e);
                }
                for (i = 0; i < digestAlgorithmsArray.length; ++i) {
                    MessageDigest md = mds[i];
                    byte[] concatenationOfChunkCountAndChunkDigests = digestsOfChunks[i];
                    int expectedDigestSizeBytes = digestOutputSizes[i];
                    int actualDigestSizeBytes = md.digest(concatenationOfChunkCountAndChunkDigests, 5 + chunkIndex * expectedDigestSizeBytes, expectedDigestSizeBytes);
                    if (actualDigestSizeBytes == expectedDigestSizeBytes) continue;
                    throw new RuntimeException("Unexpected output size of " + md.getAlgorithm() + " digest: " + actualDigestSizeBytes);
                }
                inputOffset += (long)chunkSize;
                inputRemaining -= (long)chunkSize;
                ++chunkIndex;
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)digestAlgorithmsArray.length);
        for (int i = 0; i < digestAlgorithmsArray.length; ++i) {
            ContentDigestAlgorithm digestAlgorithm = digestAlgorithmsArray[i];
            byte[] concatenationOfChunkCountAndChunkDigests = digestsOfChunks[i];
            MessageDigest md = mds[i];
            byte[] digest = md.digest(concatenationOfChunkCountAndChunkDigests);
            result.put(digestAlgorithm, digest);
        }
        return result;
    }

    private static final long getChunkCount(long inputSize, int chunkSize) {
        return (inputSize + (long)chunkSize - 1L) / (long)chunkSize;
    }

    private static void setUnsignedInt32LittleEndian(int value, byte[] result, int offset) {
        result[offset] = (byte)(value & 0xFF);
        result[offset + 1] = (byte)(value >> 8 & 0xFF);
        result[offset + 2] = (byte)(value >> 16 & 0xFF);
        result[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    private static byte[] generateApkSigningBlock(List<SignerConfig> signerConfigs, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws InvalidKeyException, SignatureException {
        byte[] apkSignatureSchemeV2Block = ApkSignerV2.generateApkSignatureSchemeV2Block(signerConfigs, contentDigests);
        return ApkSignerV2.generateApkSigningBlock(apkSignatureSchemeV2Block);
    }

    private static byte[] generateApkSigningBlock(byte[] apkSignatureSchemeV2Block) {
        int resultSize = 20 + apkSignatureSchemeV2Block.length + 8 + 16;
        ByteBuffer result = ByteBuffer.allocate(resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        long blockSizeFieldValue = resultSize - 8;
        result.putLong(blockSizeFieldValue);
        long pairSizeFieldValue = 4 + apkSignatureSchemeV2Block.length;
        result.putLong(pairSizeFieldValue);
        result.putInt(1896449818);
        result.put(apkSignatureSchemeV2Block);
        result.putLong(blockSizeFieldValue);
        result.put(APK_SIGNING_BLOCK_MAGIC);
        return result.array();
    }

    private static byte[] generateApkSignatureSchemeV2Block(List<SignerConfig> signerConfigs, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws InvalidKeyException, SignatureException {
        ArrayList signerBlocks = Lists.newArrayListWithExpectedSize((int)signerConfigs.size());
        int signerNumber = 0;
        for (SignerConfig signerConfig : signerConfigs) {
            byte[] signerBlock;
            ++signerNumber;
            try {
                signerBlock = ApkSignerV2.generateSignerBlock(signerConfig, contentDigests);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyException("Signer #" + signerNumber + " failed", e);
            }
            catch (SignatureException e) {
                throw new SignatureException("Signer #" + signerNumber + " failed", e);
            }
            signerBlocks.add(signerBlock);
        }
        return ApkSignerV2.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{ApkSignerV2.encodeAsSequenceOfLengthPrefixedElements(signerBlocks)});
    }

    private static byte[] generateSignerBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws InvalidKeyException, SignatureException {
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        byte[] encodedPublicKey = ApkSignerV2.encodePublicKey(publicKey);
        V2SignatureSchemeBlock.SignedData signedData = new V2SignatureSchemeBlock.SignedData();
        try {
            signedData.certificates = ApkSignerV2.encodeCertificates(signerConfig.certificates);
        }
        catch (CertificateEncodingException e) {
            throw new SignatureException("Failed to encode certificates", e);
        }
        ArrayList digests = Lists.newArrayListWithExpectedSize((int)signerConfig.signatureAlgorithms.size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] contentDigest = contentDigests.get((Object)contentDigestAlgorithm);
            if (contentDigest == null) {
                throw new RuntimeException((Object)((Object)contentDigestAlgorithm) + " content digest for " + (Object)((Object)signatureAlgorithm) + " not computed");
            }
            digests.add(Pair.of((Object)signatureAlgorithm.getId(), (Object)contentDigest));
        }
        signedData.digests = digests;
        V2SignatureSchemeBlock.Signer signer = new V2SignatureSchemeBlock.Signer();
        signer.signedData = ApkSignerV2.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{ApkSignerV2.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedData.digests), ApkSignerV2.encodeAsSequenceOfLengthPrefixedElements(signedData.certificates), new byte[0]});
        signer.publicKey = encodedPublicKey;
        signer.signatures = Lists.newArrayListWithExpectedSize((int)signerConfig.signatureAlgorithms.size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            byte[] signatureBytes;
            Signature signature;
            Pair<String, ? extends AlgorithmParameterSpec> sigAlgAndParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams();
            String jcaSignatureAlgorithm = (String)sigAlgAndParams.getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = (AlgorithmParameterSpec)sigAlgAndParams.getSecond();
            try {
                signature = Signature.getInstance(jcaSignatureAlgorithm);
                signature.initSign(signerConfig.privateKey);
                if (jcaSignatureAlgorithmParams != null) {
                    signature.setParameter(jcaSignatureAlgorithmParams);
                }
                signature.update(signer.signedData);
                signatureBytes = signature.sign();
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyException("Failed sign using " + jcaSignatureAlgorithm, e);
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | SignatureException e) {
                throw new SignatureException("Failed sign using " + jcaSignatureAlgorithm, e);
            }
            try {
                signature = Signature.getInstance(jcaSignatureAlgorithm);
                signature.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    signature.setParameter(jcaSignatureAlgorithmParams);
                }
                signature.update(signer.signedData);
                if (!signature.verify(signatureBytes)) {
                    throw new SignatureException("Signature did not verify");
                }
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyException("Failed to verify generated " + jcaSignatureAlgorithm + " signature using public key from certificate", e);
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | SignatureException e) {
                throw new SignatureException("Failed to verify generated " + jcaSignatureAlgorithm + " signature using public key from certificate", e);
            }
            signer.signatures.add((Pair<Integer, byte[]>)Pair.of((Object)signatureAlgorithm.getId(), (Object)signatureBytes));
        }
        return ApkSignerV2.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{signer.signedData, ApkSignerV2.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signer.signatures), signer.publicKey});
    }

    private static byte[] encodePublicKey(PublicKey publicKey) throws InvalidKeyException {
        byte[] encodedPublicKey = null;
        if ("X.509".equals(publicKey.getFormat())) {
            encodedPublicKey = publicKey.getEncoded();
        }
        if (encodedPublicKey == null) {
            try {
                encodedPublicKey = KeyFactory.getInstance(publicKey.getAlgorithm()).getKeySpec(publicKey, X509EncodedKeySpec.class).getEncoded();
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("Failed to obtain X.509 encoded form of public key " + publicKey + " of class " + publicKey.getClass().getName(), e);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException("Failed to obtain X.509 encoded form of public key " + publicKey + " of class " + publicKey.getClass().getName(), e);
            }
        }
        if (encodedPublicKey == null || encodedPublicKey.length == 0) {
            throw new InvalidKeyException("Failed to obtain X.509 encoded form of public key " + publicKey + " of class " + publicKey.getClass().getName());
        }
        return encodedPublicKey;
    }

    private static List<byte[]> encodeCertificates(List<X509Certificate> certificates) throws CertificateEncodingException {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)certificates.size());
        for (X509Certificate certificate : certificates) {
            result.add(certificate.getEncoded());
        }
        return result;
    }

    private static byte[] encodeAsSequenceOfLengthPrefixedElements(List<byte[]> sequence) {
        return ApkSignerV2.encodeAsSequenceOfLengthPrefixedElements((byte[][])sequence.toArray((T[])new byte[sequence.size()][]));
    }

    private static byte[] encodeAsSequenceOfLengthPrefixedElements(byte[][] sequence) {
        int payloadSize = 0;
        for (byte[] element : sequence) {
            payloadSize += 4 + element.length;
        }
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        for (byte[] element : sequence) {
            result.putInt(element.length);
            result.put(element);
        }
        return result.array();
    }

    private static byte[] encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(List<Pair<Integer, byte[]>> sequence) {
        int resultSize = 0;
        for (Pair<Integer, byte[]> element : sequence) {
            resultSize += 12 + ((byte[])element.getSecond()).length;
        }
        ByteBuffer result = ByteBuffer.allocate(resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        for (Pair<Integer, byte[]> element : sequence) {
            byte[] second = (byte[])element.getSecond();
            result.putInt(8 + second.length);
            result.putInt((Integer)element.getFirst());
            result.putInt(second.length);
            result.put(second);
        }
        return result.array();
    }

    private static final class V2SignatureSchemeBlock {
        private V2SignatureSchemeBlock() {
        }

        private static final class SignedData {
            public List<Pair<Integer, byte[]>> digests;
            public List<byte[]> certificates;

            private SignedData() {
            }
        }

        private static final class Signer {
            public byte[] signedData;
            public List<Pair<Integer, byte[]>> signatures;
            public byte[] publicKey;

            private Signer() {
            }
        }
    }

    public static final class SignerConfig {
        public PrivateKey privateKey;
        public List<X509Certificate> certificates;
        public List<SignatureAlgorithm> signatureAlgorithms;
    }
}

