/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.NativeLibraryAbiPredicate;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.DexIncrementalRenameManager;
import com.android.builder.internal.packaging.PackagedFileUpdate;
import com.android.builder.internal.packaging.PackagedFileUpdates;
import com.android.builder.packaging.ApkCreator;
import com.android.builder.packaging.ApkCreatorFactory;
import com.android.builder.packaging.PackagerException;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class IncrementalPackager
implements Closeable {
    private ApkCreator mApkCreator;
    private final DexIncrementalRenameManager mDexRenamer;
    private final NativeLibraryAbiPredicate mAbiPredicate;

    public IncrementalPackager(ApkCreatorFactory.CreationData creationData, File intermediateDir, ApkCreatorFactory factory, Set<String> acceptedAbis, boolean jniDebugMode) throws PackagerException, IOException {
        Preconditions.checkArgument((boolean)intermediateDir.isDirectory(), (Object)"!intermediateDir.isDirectory()");
        IncrementalPackager.checkOutputFile(creationData.getApkPath());
        this.mApkCreator = factory.make(creationData);
        this.mDexRenamer = new DexIncrementalRenameManager(intermediateDir);
        this.mAbiPredicate = new NativeLibraryAbiPredicate(acceptedAbis, jniDebugMode);
    }

    public void updateDex(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(this.mDexRenamer.update(files));
    }

    private void updateFiles(Set<PackagedFileUpdate> updates) throws IOException {
        Preconditions.checkNotNull((Object)this.mApkCreator, (Object)"mApkCreator == null");
        Iterable deletedPaths = Iterables.transform((Iterable)Iterables.filter(updates, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)FileStatus.REMOVED), PackagedFileUpdate.EXTRACT_STATUS)), PackagedFileUpdate.EXTRACT_NAME);
        for (String deletedPath : deletedPaths) {
            this.mApkCreator.deleteFile(deletedPath);
        }
        Predicate isNewOrChanged = Predicates.compose((Predicate)Predicates.or((Predicate)Predicates.equalTo((Object)FileStatus.NEW), (Predicate)Predicates.equalTo((Object)FileStatus.CHANGED)), PackagedFileUpdate.EXTRACT_STATUS);
        Function extractBaseFile = Functions.compose(RelativeFile.EXTRACT_BASE, PackagedFileUpdate.EXTRACT_SOURCE);
        Iterable newOrChangedNonArchiveFiles = Iterables.filter(updates, (Predicate)Predicates.and((Predicate)isNewOrChanged, (Predicate)Predicates.compose((Predicate)Files.isDirectory(), (Function)extractBaseFile)));
        for (PackagedFileUpdate rf : newOrChangedNonArchiveFiles) {
            this.mApkCreator.writeFile(rf.getSource().getFile(), rf.getName());
        }
        Iterable newOrChangedArchiveFiles = Iterables.filter(updates, (Predicate)Predicates.and((Predicate)isNewOrChanged, (Predicate)Predicates.compose((Predicate)Files.isFile(), (Function)extractBaseFile)));
        Iterable archives = Iterables.transform((Iterable)newOrChangedArchiveFiles, (Function)extractBaseFile);
        HashSet names = Sets.newHashSet((Iterable)Iterables.transform((Iterable)newOrChangedArchiveFiles, PackagedFileUpdate.EXTRACT_NAME));
        HashMap pathNameMap = Maps.newHashMap();
        for (PackagedFileUpdate archiveUpdate : newOrChangedArchiveFiles) {
            pathNameMap.put(archiveUpdate.getSource().getOsIndependentRelativePath(), archiveUpdate.getName());
        }
        for (File arch : Sets.newHashSet((Iterable)archives)) {
            this.mApkCreator.writeZip(arch, pathNameMap::get, name -> !names.contains(name));
        }
    }

    public void updateJavaResources(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        Predicate<String> isNotClassFile = new Predicate<String>(){

            public boolean apply(String input) {
                return !input.endsWith(".class");
            }
        };
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(files, (Predicate)Predicates.compose((Predicate)isNotClassFile, RelativeFile.EXTRACT_PATH))));
    }

    public void updateAssets(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(files).stream().map(pfu -> new PackagedFileUpdate(pfu.getSource(), "assets/" + pfu.getName(), pfu.getStatus())).collect(Collectors.toSet()));
    }

    public void updateAndroidResources(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(files));
    }

    public void updateNativeLibraries(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        this.updateFiles(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(files, (Predicate)Predicates.compose((Predicate)this.mAbiPredicate, RelativeFile.EXTRACT_PATH))));
    }

    private static void checkOutputFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException(String.format("'%s' is a directory", file.getAbsolutePath()));
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new IOException(String.format("'%s' is not writeable", file.getAbsolutePath()));
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()));
                }
                if (!file.delete()) {
                    throw new IOException(String.format("Failed to delete newly created '%s'", file.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()), e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mApkCreator == null) {
            return;
        }
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.mApkCreator);
            closer.register((Closeable)this.mDexRenamer);
            this.mApkCreator = null;
        }
    }
}

