/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.internal.compiler.DexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.repository.Revision;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class JackDexKey
extends DexKey {
    private static final String ELEM_ADDITIONAL_PARAMETERS_ENTRY = "custom-entry";
    private static final String ELEM_ADDITIONAL_PARAMETERS = "custom-flags";
    private static final String ATTR_PARAMETER_KEY = "param-key";
    private static final String ATTR_PARAMETER_VALUE = "param-value";
    private final ImmutableSortedMap<String, String> mAdditionalParameters;
    static final PreProcessCache.KeyFactory<JackDexKey> FACTORY = (sourceFile, revision, attrMap) -> {
        Document document;
        NodeList matchingAdditionalParamsTags;
        boolean jumboMode = Boolean.parseBoolean(attrMap.getNamedItem("jumboMode").getNodeValue());
        Node optimizeAttribute = attrMap.getNamedItem("optimize");
        boolean optimize = optimizeAttribute != null ? Boolean.parseBoolean(optimizeAttribute.getNodeValue()) : true;
        HashMap additionalParameters = Maps.newHashMap();
        if (attrMap.getLength() > 0 && (matchingAdditionalParamsTags = (document = attrMap.item(0).getOwnerDocument()).getElementsByTagName(ELEM_ADDITIONAL_PARAMETERS)).getLength() > 0) {
            Node elemAdditionalParams = matchingAdditionalParamsTags.item(0);
            for (int i = 0; i < elemAdditionalParams.getChildNodes().getLength(); ++i) {
                Node paramEntry = elemAdditionalParams.getChildNodes().item(i);
                additionalParameters.put(paramEntry.getAttributes().getNamedItem(ATTR_PARAMETER_VALUE).getNodeValue(), paramEntry.getAttributes().getNamedItem(ATTR_PARAMETER_KEY).getNodeValue());
            }
        }
        return JackDexKey.of(sourceFile, revision, jumboMode, optimize, additionalParameters);
    };

    private JackDexKey(File sourceFile, Revision buildToolsRevision, boolean jumboMode, boolean optimize, Map<String, String> additionalParameters) {
        super(sourceFile, buildToolsRevision, jumboMode, optimize);
        this.mAdditionalParameters = ImmutableSortedMap.copyOf(additionalParameters);
    }

    static JackDexKey of(File sourceFile, Revision buildToolsRevision, boolean jumboMode, boolean optimize, Map<String, String> additionalParameters) {
        return new JackDexKey(sourceFile, buildToolsRevision, jumboMode, optimize, additionalParameters);
    }

    @Override
    protected void writeFieldsToXml(Node itemNode) {
        super.writeFieldsToXml(itemNode);
        Document document = itemNode.getOwnerDocument();
        Element params = document.createElement(ELEM_ADDITIONAL_PARAMETERS);
        for (String paramKey : this.mAdditionalParameters.keySet()) {
            String paramValue = (String)this.mAdditionalParameters.get((Object)paramKey);
            Element element = document.createElement(ELEM_ADDITIONAL_PARAMETERS_ENTRY);
            element.setAttribute(ATTR_PARAMETER_KEY, paramKey);
            element.setAttribute(ATTR_PARAMETER_VALUE, paramValue);
            params.appendChild(element);
        }
        document.appendChild(params);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JackDexKey dxDexKey = (JackDexKey)o;
        return this.mAdditionalParameters.equals(dxDexKey.mAdditionalParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mAdditionalParameters});
    }
}

