/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.AbstractBundleDependency;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.SkippableLibrary;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class LibraryDependency
extends AbstractBundleDependency
implements AndroidLibrary,
SkippableLibrary {
    private final AtomicBoolean mSkipped = new AtomicBoolean(false);
    private final boolean mIsProvided;

    public LibraryDependency(File bundle, File explodedBundle, List<LibraryDependency> androidDependencies, Collection<JarDependency> jarDependencies, String name, String variantName, String projectPath, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isProvided) {
        super(bundle, explodedBundle, androidDependencies, jarDependencies, name, variantName, projectPath, requestedCoordinates, resolvedCoordinates);
        this.mIsProvided = isProvided;
    }

    public boolean isProvided() {
        return this.mIsProvided;
    }

    public List<File> getLocalJars() {
        ArrayList localJars = Lists.newArrayList();
        File[] jarList = new File(this.getJarsRootFolder(), "libs").listFiles();
        if (jarList != null) {
            for (File jars : jarList) {
                if (!jars.isFile() || !jars.getName().endsWith(".jar")) continue;
                localJars.add(jars);
            }
        }
        return localJars;
    }

    public File getJarFile() {
        return new File(this.getJarsRootFolder(), "classes.jar");
    }

    public File getResFolder() {
        return new File(this.getFolder(), "res");
    }

    public File getAssetsFolder() {
        return new File(this.getFolder(), "assets");
    }

    public File getJniFolder() {
        return new File(this.getFolder(), "jni");
    }

    public File getAidlFolder() {
        return new File(this.getFolder(), "aidl");
    }

    public File getRenderscriptFolder() {
        return new File(this.getFolder(), "rs");
    }

    public File getProguardRules() {
        return new File(this.getFolder(), "proguard.txt");
    }

    public File getLintJar() {
        return new File(this.getJarsRootFolder(), "lint.jar");
    }

    public File getExternalAnnotations() {
        return new File(this.getFolder(), "annotations.zip");
    }

    public File getPublicResources() {
        return new File(this.getFolder(), "public.txt");
    }

    public File getSymbolFile() {
        return new File(this.getFolder(), "R.txt");
    }

    protected File getJarsRootFolder() {
        return new File(this.getFolder(), "jars");
    }

    public boolean isSkipped() {
        return this.mSkipped.get();
    }

    @Override
    public void skip() {
        this.mSkipped.set(true);
    }

    @Deprecated
    public boolean isOptional() {
        return this.isProvided();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibraryDependency that = (LibraryDependency)o;
        return this.mIsProvided == that.mIsProvided;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mIsProvided});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("mIsProvided", this.mIsProvided).add("super", (Object)super.toString()).toString();
    }
}

