/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.builder.internal.TemplateProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;

public class TestManifestGenerator {
    private static final String TEMPLATE = "AndroidManifest.template";
    private static final String PH_PACKAGE = "#PACKAGE#";
    private static final String PH_MIN_SDK_VERSION = "#MINSDKVERSION#";
    private static final String PH_TARGET_SDK_VERSION = "#TARGETSDKVERSION#";
    private static final String PH_TESTED_PACKAGE = "#TESTEDPACKAGE#";
    private static final String PH_TEST_RUNNER = "#TESTRUNNER#";
    private static final String PH_HANDLE_PROFILING = "#HANDLEPROFILING#";
    private static final String PH_FUNCTIONAL_TEST = "#FUNCTIONALTEST#";
    private final File mOutputFile;
    private final String mPackageName;
    private final String mMinSdkVersion;
    private final String mTargetSdkVersion;
    private final String mTestedPackageName;
    private final String mTestRunnerName;
    private final boolean mHandleProfiling;
    private final boolean mFunctionalTest;

    public TestManifestGenerator(File outputFile, String packageName, String minSdkVersion, String targetSdkVersion, String testedPackageName, String testRunnerName, Boolean handleProfiling, Boolean functionalTest) {
        this.mOutputFile = outputFile;
        this.mPackageName = packageName;
        this.mMinSdkVersion = minSdkVersion;
        this.mTargetSdkVersion = targetSdkVersion != null ? targetSdkVersion : minSdkVersion;
        this.mTestedPackageName = testedPackageName;
        this.mTestRunnerName = testRunnerName;
        this.mHandleProfiling = handleProfiling;
        this.mFunctionalTest = functionalTest;
    }

    public void generate() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PH_PACKAGE, this.mPackageName);
        map.put(PH_MIN_SDK_VERSION, this.mMinSdkVersion != null ? this.mMinSdkVersion : "1");
        map.put(PH_TARGET_SDK_VERSION, this.mTargetSdkVersion != null ? this.mTargetSdkVersion : (String)map.get(PH_MIN_SDK_VERSION));
        map.put(PH_TESTED_PACKAGE, this.mTestedPackageName);
        map.put(PH_TEST_RUNNER, this.mTestRunnerName);
        map.put(PH_HANDLE_PROFILING, Boolean.toString(this.mHandleProfiling));
        map.put(PH_FUNCTIONAL_TEST, Boolean.toString(this.mFunctionalTest));
        URL resource = TestManifestGenerator.class.getResource(TEMPLATE);
        if (resource == null) {
            throw new RuntimeException("Cannot load template, restart gradle daemons ?");
        }
        URLConnection urlConnection = resource.openConnection();
        urlConnection.setUseCaches(false);
        TemplateProcessor processor = new TemplateProcessor(urlConnection.getInputStream(), map);
        processor.generate(this.mOutputFile);
    }
}

