/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.ProcessRecorder;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.UUID;

public class ProcessRecorderFactory {
    private static boolean sENABLED = !Strings.isNullOrEmpty((String)System.getenv("RECORD_SPANS"));
    private final long startTime = System.currentTimeMillis();
    private final long gcCountAtStart;
    private final long gcTimeAtStart;
    static final Object LOCK = new Object();
    static ProcessRecorderFactory sINSTANCE = new ProcessRecorderFactory();
    @Nullable
    private ProcessRecorder processRecorder = null;
    @Nullable
    private ProcessRecorder.ExecutionRecordWriter recordWriter = null;
    @Nullable
    private ILogger iLogger = null;
    private File outputFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() throws InterruptedException {
        Object object = LOCK;
        synchronized (object) {
            List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            ThreadRecorder.get().record(ExecutionType.FINAL_METADATA, Recorder.EmptyBlock, new Recorder.Property("build_time", Long.toString(System.currentTimeMillis() - ProcessRecorderFactory.sINSTANCE.startTime)), new Recorder.Property("gc_count", Long.toString(garbageCollectorMXBeans.get(0).getCollectionCount() - ProcessRecorderFactory.sINSTANCE.gcCountAtStart)), new Recorder.Property("gc_time", Long.toString(garbageCollectorMXBeans.get(0).getCollectionTime() - ProcessRecorderFactory.sINSTANCE.gcTimeAtStart)));
            if (sINSTANCE.isInitialized()) {
                sINSTANCE.get().finish();
                sINSTANCE.uploadData();
            }
            ProcessRecorderFactory.sINSTANCE.processRecorder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(ILogger logger, File out) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized() || !ProcessRecorderFactory.isEnabled()) {
                return;
            }
            sINSTANCE.setLogger(logger);
            sINSTANCE.setOutputFile(out);
            sINSTANCE.setRecordWriter(new ProcessRecorder.JsonRecordWriter(new FileWriter(out)));
            ProcessRecorderFactory.publishInitialRecords();
        }
    }

    public static void publishInitialRecords() {
        ThreadRecorder.get().record(ExecutionType.INITIAL_METADATA, Recorder.EmptyBlock, new Recorder.Property("build_id", UUID.randomUUID().toString()), new Recorder.Property("os_name", System.getProperty("os.name")), new Recorder.Property("os_version", System.getProperty("os.version")), new Recorder.Property("java_version", System.getProperty("java.version")), new Recorder.Property("java_vm_version", System.getProperty("java.vm.version")), new Recorder.Property("max_memory", Long.toString(Runtime.getRuntime().maxMemory())));
    }

    ProcessRecorderFactory() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.gcCountAtStart = garbageCollectorMXBeans.get(0).getCollectionCount();
        this.gcTimeAtStart = garbageCollectorMXBeans.get(0).getCollectionTime();
    }

    public static void initializeForTests(ProcessRecorder.ExecutionRecordWriter recordWriter) {
        sINSTANCE = new ProcessRecorderFactory();
        ProcessRecorder.resetForTests();
        ProcessRecorderFactory.setEnabled(true);
        sINSTANCE.setRecordWriter(recordWriter);
        ProcessRecorderFactory.publishInitialRecords();
    }

    static boolean isEnabled() {
        return sENABLED;
    }

    static void setEnabled(boolean enabled) {
        sENABLED = enabled;
    }

    public synchronized void setRecordWriter(@NonNull ProcessRecorder.ExecutionRecordWriter recordWriter) {
        this.assertRecorderNotCreated();
        this.recordWriter = recordWriter;
    }

    public synchronized void setLogger(@NonNull ILogger iLogger) {
        this.assertRecorderNotCreated();
        this.iLogger = iLogger;
    }

    public static ProcessRecorderFactory getFactory() {
        return sINSTANCE;
    }

    private boolean isInitialized() {
        return this.processRecorder != null;
    }

    private void assertRecorderNotCreated() {
        if (this.isInitialized()) {
            throw new RuntimeException("ProcessRecorder already created.");
        }
    }

    private void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    synchronized ProcessRecorder get() {
        if (this.processRecorder == null) {
            if (this.recordWriter == null) {
                throw new RuntimeException("recordWriter not configured.");
            }
            if (this.iLogger == null) {
                this.iLogger = new StdLogger(StdLogger.Level.INFO);
            }
            this.processRecorder = new ProcessRecorder(this.recordWriter, this.iLogger);
        }
        return this.processRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadData() {
        block9: {
            if (this.outputFile == null) {
                return;
            }
            try {
                String line;
                URL u = new URL("http://android-devtools-logging.appspot.com/log/");
                HttpURLConnection conn = null;
                conn = (HttpURLConnection)u.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(this.outputFile.length()));
                InputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(this.outputFile));
                    OutputStream os = conn.getOutputStream();
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                    os.close();
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (this.iLogger == null) continue;
                    this.iLogger.info("From POST : " + line, new Object[0]);
                }
                reader.close();
            }
            catch (Exception e) {
                if (this.iLogger == null) break block9;
                this.iLogger.warning("An exception while generated while uploading the profiler data", new Object[0]);
                this.iLogger.error((Throwable)e, "Exception while uploading the profiler data", new Object[0]);
            }
        }
    }
}

