/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.annotations.NonNull;
import com.android.builder.profile.ExecutionRecord;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.QueueThreadContextAdapter;
import com.android.builder.tasks.Task;
import com.android.builder.tasks.WorkQueue;
import com.android.utils.ILogger;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ProcessRecorder {
    private static final AtomicLong lastRecordId = new AtomicLong(0L);
    @NonNull
    private final JobContext<ExecutionRecordWriter> singletonJobContext;
    @NonNull
    private final WorkQueue<ExecutionRecordWriter> workQueue;

    static long allocateRecordId() {
        return lastRecordId.incrementAndGet();
    }

    static void resetForTests() {
        lastRecordId.set(0L);
    }

    @NonNull
    static ProcessRecorder get() {
        return ProcessRecorderFactory.sINSTANCE.get();
    }

    ProcessRecorder(@NonNull ExecutionRecordWriter outWriter, @NonNull ILogger iLogger) {
        this.singletonJobContext = new JobContext<ExecutionRecordWriter>(outWriter);
        this.workQueue = new WorkQueue<ExecutionRecordWriter>(iLogger, new WorkQueueContext(), "execRecordWriter", 1);
    }

    void writeRecord(final @NonNull ExecutionRecord executionRecord) {
        try {
            this.workQueue.push(new Job<ExecutionRecordWriter>("recordWriter", new Task<ExecutionRecordWriter>(){

                @Override
                public void run(@NonNull Job<ExecutionRecordWriter> job, @NonNull JobContext<ExecutionRecordWriter> context) throws IOException {
                    context.getPayload().write(executionRecord);
                    job.finished();
                }
            }));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    void finish() throws InterruptedException {
        this.workQueue.shutdown();
    }

    static class JsonRecordWriter
    implements ExecutionRecordWriter {
        @NonNull
        private final Gson gson;
        @NonNull
        private final Writer writer;
        @NonNull
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public JsonRecordWriter(@NonNull Writer writer) {
            this.gson = new Gson();
            this.writer = writer;
        }

        @Override
        public synchronized void write(@NonNull ExecutionRecord executionRecord) throws IOException {
            if (this.closed.get()) {
                return;
            }
            String json = this.gson.toJson((Object)executionRecord);
            this.writer.append(json);
            this.writer.append("\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            JsonRecordWriter jsonRecordWriter = this;
            synchronized (jsonRecordWriter) {
                if (this.closed.get()) {
                    return;
                }
                this.closed.set(true);
            }
            this.writer.flush();
            this.writer.close();
        }
    }

    private class WorkQueueContext
    extends QueueThreadContextAdapter<ExecutionRecordWriter> {
        private WorkQueueContext() {
        }

        @Override
        public void runTask(@NonNull Job<ExecutionRecordWriter> job) throws Exception {
            job.runTask(ProcessRecorder.this.singletonJobContext);
        }

        @Override
        public void shutdown() {
            try {
                ((ExecutionRecordWriter)ProcessRecorder.this.singletonJobContext.getPayload()).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface ExecutionRecordWriter {
        public void write(@NonNull ExecutionRecord var1) throws IOException;

        public void close() throws IOException;
    }
}

