/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.tasks.BooleanLatch;
import com.android.builder.tasks.Job;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AaptProcess {
    private static final int DEFAULT_SLAVE_APPT_TIMEOUT_IN_SECONDS = 5;
    private static final int SLAVE_AAPT_TIMEOUT_IN_SECONDS = System.getenv("SLAVE_AAPT_TIMEOUT") == null ? 5 : Integer.parseInt(System.getenv("SLAVE_AAPT_TIMEOUT"));
    private final Process mProcess;
    private final ILogger mLogger;
    private final ProcessOutputFacade mProcessOutputFacade = new ProcessOutputFacade();
    private final List<String> mMessages = new ArrayList<String>();
    private final AtomicBoolean mReady = new AtomicBoolean(false);
    private final BooleanLatch mReadyLatch = new BooleanLatch();
    private final OutputStreamWriter mWriter;

    private AaptProcess(@NonNull Process process, @NonNull ILogger iLogger) throws InterruptedException {
        this.mProcess = process;
        this.mLogger = iLogger;
        GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)this.mProcessOutputFacade);
        this.mWriter = new OutputStreamWriter(this.mProcess.getOutputStream());
    }

    public void crunch(@NonNull File in, @NonNull File out, @NonNull Job<AaptProcess> job) throws IOException {
        this.mLogger.verbose("Process(" + this.mProcess.hashCode() + ")" + in.getName() + "job: " + job.toString(), new Object[0]);
        if (!this.mReady.get()) {
            throw new RuntimeException("AAPT process not ready to receive commands");
        }
        NotifierProcessOutput notifier = new NotifierProcessOutput(job, this.mProcessOutputFacade, this.mLogger);
        this.mProcessOutputFacade.setNotifier(notifier);
        this.mWriter.write("s\n");
        this.mWriter.write(in.getAbsolutePath());
        this.mWriter.write("\n");
        this.mWriter.write(out.getAbsolutePath());
        this.mWriter.write("\n");
        this.mWriter.flush();
        this.mLogger.verbose("Processed(" + this.mProcess.hashCode() + ")" + in.getName() + "job: " + job.toString(), new Object[0]);
        this.mMessages.add("Process(" + this.mProcess.hashCode() + ") processed " + in.getName() + "job: " + job.toString());
    }

    public void waitForReady() throws InterruptedException {
        if (!this.mReadyLatch.await(TimeUnit.NANOSECONDS.convert(SLAVE_AAPT_TIMEOUT_IN_SECONDS, TimeUnit.SECONDS))) {
            throw new RuntimeException("Timed out while waiting for slave aapt process, try setting environment variable SLAVE_AAPT_TIMEOUT to a value bigger than " + SLAVE_AAPT_TIMEOUT_IN_SECONDS + " seconds");
        }
        this.mLogger.info("Slave %1$s is ready", new Object[]{this.hashCode()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("ready", this.mReady.get()).add("process", this.mProcess.hashCode()).toString();
    }

    public void shutdown() throws IOException, InterruptedException {
        this.mReady.set(false);
        this.mWriter.write("quit\n");
        this.mWriter.flush();
        this.mProcess.waitFor();
        this.mLogger.verbose("Process (%1$s) processed %2$s files", new Object[]{this.mProcess.hashCode(), this.mMessages.size()});
        for (String message : this.mMessages) {
            this.mLogger.verbose(message, new Object[0]);
        }
    }

    private static class NotifierProcessOutput
    implements GrabProcessOutput.IProcessOutput {
        @NonNull
        private final Job<AaptProcess> mJob;
        @NonNull
        private final ProcessOutputFacade mOwner;
        @NonNull
        private final ILogger mLogger;

        NotifierProcessOutput(@NonNull Job<AaptProcess> job, @NonNull ProcessOutputFacade owner, @NonNull ILogger iLogger) {
            this.mOwner = owner;
            this.mJob = job;
            this.mLogger = iLogger;
        }

        public void out(@Nullable String line) {
            if (line != null) {
                this.mLogger.verbose("AAPT notify(%1$s): %2$s", new Object[]{this.mJob, line});
                if (line.equalsIgnoreCase("Done")) {
                    this.mOwner.reset();
                    this.mJob.finished();
                } else if (line.equalsIgnoreCase("Error")) {
                    this.mOwner.reset();
                    this.mJob.error();
                } else {
                    this.mLogger.verbose("AAPT(%1$s) discarded: %2$s", new Object[]{this.mJob, line});
                }
            }
        }

        public void err(@Nullable String line) {
            if (line != null) {
                this.mLogger.verbose("AAPT warning(%1$s), Job(%2$s): %3$s", new Object[]{this.mOwner.getProcess().hashCode(), this.mJob, line});
                this.mLogger.warning("AAPT: %3$s", new Object[]{this.mOwner.getProcess().hashCode(), this.mJob, line});
            }
        }
    }

    private class ProcessOutputFacade
    implements GrabProcessOutput.IProcessOutput {
        @Nullable
        NotifierProcessOutput notifier = null;
        AtomicBoolean ready = new AtomicBoolean(false);

        private ProcessOutputFacade() {
        }

        synchronized void setNotifier(@NonNull NotifierProcessOutput notifierProcessOutput) {
            if (this.notifier != null) {
                throw new RuntimeException("Notifier already set, threading issue");
            }
            this.notifier = notifierProcessOutput;
        }

        synchronized void reset() {
            this.notifier = null;
        }

        @Nullable
        synchronized NotifierProcessOutput getNotifier() {
            return this.notifier;
        }

        public synchronized void out(@Nullable String line) {
            if (Strings.isNullOrEmpty((String)line)) {
                return;
            }
            if (line.equals("Ready")) {
                AaptProcess.this.mReady.set(true);
                AaptProcess.this.mReadyLatch.signal();
                return;
            }
            NotifierProcessOutput delegate = this.getNotifier();
            AaptProcess.this.mLogger.verbose("AAPT out(%1$s): %2$s", new Object[]{AaptProcess.this.mProcess.hashCode(), line});
            if (delegate != null) {
                AaptProcess.this.mLogger.verbose("AAPT out(%1$s): -> %2$s", new Object[]{AaptProcess.this.mProcess.hashCode(), delegate.mJob});
                delegate.out(line);
            } else {
                AaptProcess.this.mLogger.error(null, "AAPT out(%1$s) : No Delegate set : lost message:%2$s", new Object[]{AaptProcess.this.mProcess.hashCode(), line});
            }
        }

        public synchronized void err(@Nullable String line) {
            if (Strings.isNullOrEmpty((String)line)) {
                return;
            }
            NotifierProcessOutput delegate = this.getNotifier();
            if (delegate != null) {
                AaptProcess.this.mLogger.verbose("AAPT err(%1$s): %2$s -> %3$s", new Object[]{AaptProcess.this.mProcess.hashCode(), line, delegate.mJob});
                delegate.err(line);
            } else if (!AaptProcess.this.mReady.get()) {
                if (line.equals("ERROR: Unknown command 'm'")) {
                    throw new RuntimeException("Invalid aapt version, version 21 or above is required");
                }
                AaptProcess.this.mLogger.error(null, "AAPT err(%1$s): %2$s", new Object[]{AaptProcess.this.mProcess.hashCode(), line});
            } else {
                AaptProcess.this.mLogger.error(null, "AAPT err(%1$s) : No Delegate set : lost message:%2$s", new Object[]{AaptProcess.this.mProcess.hashCode(), line});
            }
        }

        Process getProcess() {
            return AaptProcess.this.mProcess;
        }
    }

    public static class Builder {
        private final String mAaptLocation;
        private final ILogger mLogger;

        public Builder(@NonNull String aaptPath, @NonNull ILogger iLogger) {
            this.mAaptLocation = aaptPath;
            this.mLogger = iLogger;
        }

        public AaptProcess start() throws IOException, InterruptedException {
            String[] command = new String[]{this.mAaptLocation, "m"};
            this.mLogger.verbose("Trying to start %1$s", new Object[]{command[0]});
            Process process = new ProcessBuilder(command).start();
            this.mLogger.verbose("Started %1$d", new Object[]{process.hashCode()});
            return new AaptProcess(process, this.mLogger);
        }
    }
}

