/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.core.DexOptions;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class DexProcessBuilder
extends ProcessEnvBuilder<DexProcessBuilder> {
    private static final FullRevision MIN_BUILD_TOOLS_REVISION_FOR_DEX_INPUT_LIST = new FullRevision(21, 0, 0);
    private static final FullRevision MIN_MULTIDEX_BUILD_TOOLS_REV = new FullRevision(21, 0, 0);
    private static final FullRevision MIN_MULTI_THREADED_DEX_BUILD_TOOLS_REV = new FullRevision(22, 0, 2);
    @NonNull
    private final File mOutputFile;
    private boolean mVerbose = false;
    private boolean mIncremental = false;
    private boolean mNoOptimize = false;
    private boolean mMultiDex = false;
    private File mMainDexList = null;
    private Set<File> mInputs = Sets.newHashSet();
    private File mTempInputFolder = null;
    private List<String> mAdditionalParams = null;

    public DexProcessBuilder(@NonNull File outputFile) {
        this.mOutputFile = outputFile;
    }

    @NonNull
    public DexProcessBuilder setVerbose(boolean verbose) {
        this.mVerbose = verbose;
        return this;
    }

    @NonNull
    public DexProcessBuilder setIncremental(boolean incremental) {
        this.mIncremental = incremental;
        return this;
    }

    @NonNull
    public DexProcessBuilder setNoOptimize(boolean noOptimize) {
        this.mNoOptimize = noOptimize;
        return this;
    }

    @NonNull
    public DexProcessBuilder setMultiDex(boolean multiDex) {
        this.mMultiDex = multiDex;
        return this;
    }

    @NonNull
    public DexProcessBuilder setMainDexList(File mainDexList) {
        this.mMainDexList = mainDexList;
        return this;
    }

    @NonNull
    public DexProcessBuilder addInput(File input) {
        this.mInputs.add(input);
        return this;
    }

    @NonNull
    public DexProcessBuilder addInputs(@NonNull Collection<File> inputs) {
        this.mInputs.addAll(inputs);
        return this;
    }

    @NonNull
    public DexProcessBuilder setTempInputFolder(File tempInputFolder) {
        this.mTempInputFolder = tempInputFolder;
        return this;
    }

    @NonNull
    public DexProcessBuilder additionalParameters(@NonNull List<String> params) {
        if (this.mAdditionalParams == null) {
            this.mAdditionalParams = Lists.newArrayListWithExpectedSize((int)params.size());
        }
        this.mAdditionalParams.addAll(params);
        return this;
    }

    @NonNull
    public JavaProcessInfo build(@NonNull BuildToolInfo buildToolInfo, @NonNull DexOptions dexOptions) throws ProcessException {
        Preconditions.checkState((!this.mMultiDex || buildToolInfo.getRevision().compareTo(MIN_MULTIDEX_BUILD_TOOLS_REV) >= 0 ? 1 : 0) != 0, (Object)("Multi dex requires Build Tools " + MIN_MULTIDEX_BUILD_TOOLS_REV.toString() + " / Current: " + buildToolInfo.getRevision().toShortString()));
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx.jar is missing");
        }
        builder.setClasspath(dx);
        builder.setMain("com.android.dx.command.Main");
        if (dexOptions.getJavaMaxHeapSize() != null) {
            builder.addJvmArg("-Xmx" + dexOptions.getJavaMaxHeapSize());
        } else {
            builder.addJvmArg("-Xmx1024M");
        }
        builder.addArgs("--dex");
        if (this.mVerbose) {
            builder.addArgs("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            builder.addArgs("--force-jumbo");
        }
        if (this.mIncremental) {
            builder.addArgs("--incremental", "--no-strict");
        }
        if (this.mNoOptimize) {
            builder.addArgs("--no-optimize");
        }
        if (buildToolInfo.getRevision().compareTo(MIN_MULTI_THREADED_DEX_BUILD_TOOLS_REV) >= 0) {
            Integer threadCount = dexOptions.getThreadCount();
            if (threadCount == null) {
                builder.addArgs("--num-threads=4");
            } else {
                builder.addArgs("--num-threads=" + threadCount);
            }
        }
        if (this.mMultiDex) {
            builder.addArgs("--multi-dex");
            if (this.mMainDexList != null) {
                builder.addArgs("--main-dex-list", this.mMainDexList.getAbsolutePath());
            }
        }
        if (this.mAdditionalParams != null) {
            for (String arg : this.mAdditionalParams) {
                builder.addArgs(arg);
            }
        }
        builder.addArgs("--output", this.mOutputFile.getAbsolutePath());
        builder.addArgs(this.getFilesToAdd(buildToolInfo));
        return builder.createJavaProcess();
    }

    @NonNull
    private List<String> getFilesToAdd(@NonNull BuildToolInfo buildToolInfo) throws ProcessException {
        Set existingFiles = Sets.filter(this.mInputs, (Predicate)new Predicate<File>(){

            public boolean apply(@Nullable File input) {
                return input != null && input.exists();
            }
        });
        if (existingFiles.isEmpty()) {
            throw new ProcessException("No files to pass to dex.");
        }
        ArrayList sortedList = Lists.newArrayList((Iterable)existingFiles);
        Collections.sort(sortedList, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                boolean file2IsDir = file2.isDirectory();
                if (file.isDirectory()) {
                    return file2IsDir ? 0 : -1;
                }
                if (file2IsDir) {
                    return 1;
                }
                long diff = file.length() - file2.length();
                return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
            }
        });
        ArrayList filePathList = Lists.newArrayListWithCapacity((int)sortedList.size());
        for (File f : sortedList) {
            filePathList.add(f.getAbsolutePath());
        }
        if (this.mTempInputFolder != null && buildToolInfo.getRevision().compareTo(MIN_BUILD_TOOLS_REVISION_FOR_DEX_INPUT_LIST) >= 0) {
            File inputListFile = new File(this.mTempInputFolder, "inputList.txt");
            try {
                Files.asCharSink((File)inputListFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)filePathList);
            }
            catch (IOException e) {
                throw new ProcessException((Throwable)e);
            }
            return Collections.singletonList("--input-list=" + inputListFile.getAbsolutePath());
        }
        return filePathList;
    }
}

