/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class BaseConfigImpl
implements Serializable,
BaseConfig {
    private static final long serialVersionUID = 1L;
    private final Map<String, ClassField> mBuildConfigFields = Maps.newTreeMap();
    private final Map<String, ClassField> mResValues = Maps.newTreeMap();
    private final List<File> mProguardFiles = Lists.newArrayList();
    private final List<File> mConsumerProguardFiles = Lists.newArrayList();

    public void addBuildConfigField(@NonNull ClassField field) {
        this.mBuildConfigFields.put(field.getName(), field);
    }

    public void addResValue(@NonNull ClassField field) {
        this.mResValues.put(field.getName(), field);
    }

    @NonNull
    public Map<String, ClassField> getBuildConfigFields() {
        return this.mBuildConfigFields;
    }

    @NonNull
    public Map<String, ClassField> getResValues() {
        return this.mResValues;
    }

    @NonNull
    public List<File> getProguardFiles() {
        return this.mProguardFiles;
    }

    @NonNull
    public List<File> getConsumerProguardFiles() {
        return this.mConsumerProguardFiles;
    }

    protected void _initWith(@NonNull BaseConfig that) {
        this.setBuildConfigFields(that.getBuildConfigFields());
        this.setResValues(that.getResValues());
        this.mProguardFiles.clear();
        this.mProguardFiles.addAll(that.getProguardFiles());
        this.mConsumerProguardFiles.clear();
        this.mConsumerProguardFiles.addAll(that.getConsumerProguardFiles());
    }

    private void setBuildConfigFields(@NonNull Map<String, ClassField> fields) {
        this.mBuildConfigFields.clear();
        this.mBuildConfigFields.putAll(fields);
    }

    private void setResValues(@NonNull Map<String, ClassField> fields) {
        this.mResValues.clear();
        this.mResValues.putAll(fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseConfigImpl that = (BaseConfigImpl)o;
        if (!((Object)this.mBuildConfigFields).equals(that.mBuildConfigFields)) {
            return false;
        }
        if (!((Object)this.mResValues).equals(that.mResValues)) {
            return false;
        }
        if (!((Object)this.mProguardFiles).equals(that.mProguardFiles)) {
            return false;
        }
        return ((Object)this.mConsumerProguardFiles).equals(that.mConsumerProguardFiles);
    }

    public int hashCode() {
        int result = ((Object)this.mBuildConfigFields).hashCode();
        result = 31 * result + ((Object)this.mResValues).hashCode();
        result = 31 * result + ((Object)this.mProguardFiles).hashCode();
        result = 31 * result + ((Object)this.mConsumerProguardFiles).hashCode();
        return result;
    }
}

