/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.incremental;

import com.android.annotations.NonNull;
import com.android.builder.internal.incremental.DependencyData;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DependencyDataStore {
    private static final byte TAG_HEADER = 127;
    private static final byte TAG_START = 112;
    private static final byte TAG_2NDARY_FILE = 113;
    private static final byte TAG_OUTPUT = 115;
    private static final byte TAG_END = 119;
    private static final int CURRENT_VERSION = 1;
    private final Map<String, DependencyData> mMainFileMap = Maps.newHashMap();

    public void addData(List<DependencyData> dataList) {
        for (DependencyData data : dataList) {
            this.mMainFileMap.put(data.getMainFile(), data);
        }
    }

    public void addData(DependencyData data) {
        this.mMainFileMap.put(data.getMainFile(), data);
    }

    public void remove(DependencyData data) {
        this.mMainFileMap.remove(data.getMainFile());
    }

    public void updateAll(List<DependencyData> dataList) {
        for (DependencyData data : dataList) {
            this.mMainFileMap.put(data.getMainFile(), data);
        }
    }

    @NonNull
    public Collection<DependencyData> getData() {
        return this.mMainFileMap.values();
    }

    DependencyData getByMainFile(String path) {
        return this.mMainFileMap.get(path);
    }

    @NonNull
    public Map<String, DependencyData> getMainFileMap() {
        return this.mMainFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(127);
            this.writeInt(fos, 1);
            for (DependencyData data : this.getData()) {
                fos.write(112);
                this.writePath(fos, data.getMainFile());
                for (String path : data.getSecondaryFiles()) {
                    fos.write(113);
                    this.writePath(fos, path);
                }
                for (String path : data.getOutputFiles()) {
                    fos.write(115);
                    this.writePath(fos, path);
                }
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<String, DependencyData> loadFrom(File file) throws IOException {
        ArrayListMultimap inputMap = ArrayListMultimap.create();
        FileInputStream fis = new FileInputStream(file);
        ReusableBuffer buffers = new ReusableBuffer();
        if (this.readByte(fis, buffers) != 127) {
            throw new IllegalStateException("Wrong first byte on " + file.getAbsolutePath());
        }
        int version = this.readInt(fis, buffers);
        if (version != 1) {
            throw new IOException("Unsupported file version: " + version);
        }
        try {
            byte currentTag = this.readByte(fis, buffers);
            if (currentTag != 112) {
                throw new IllegalStateException("Wrong first tag on " + file.getAbsolutePath());
            }
            DependencyData currentData = new DependencyData();
            while (currentTag != 119) {
                String path = this.readPath(fis, buffers);
                switch (currentTag) {
                    case 112: {
                        currentData.setMainFile(path);
                        this.mMainFileMap.put(path, currentData);
                        inputMap.put((Object)path, (Object)currentData);
                        break;
                    }
                    case 113: {
                        currentData.addSecondaryFile(path);
                        inputMap.put((Object)path, (Object)currentData);
                        break;
                    }
                    case 115: {
                        currentData.addOutputFile(path);
                    }
                }
                if ((currentTag = this.readByte(fis, buffers)) != 112) continue;
                currentData = new DependencyData();
            }
            ArrayListMultimap arrayListMultimap = inputMap;
            return arrayListMultimap;
        }
        finally {
            Closeables.closeQuietly((Closeable)fis);
        }
    }

    private void writeInt(FileOutputStream fos, int value) throws IOException {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(value);
        fos.write(b.array());
    }

    private void writePath(FileOutputStream fos, String path) throws IOException {
        byte[] pathBytes = path.getBytes(Charsets.UTF_8);
        this.writeInt(fos, pathBytes.length);
        fos.write(pathBytes);
    }

    private byte readByte(FileInputStream fis, ReusableBuffer buffers) throws IOException {
        int read = fis.read(buffers.intBuffer, 0, 1);
        if (read != 1) {
            return 119;
        }
        return buffers.intBuffer[0];
    }

    private int readInt(FileInputStream fis, ReusableBuffer buffers) throws IOException {
        int read = fis.read(buffers.intBuffer);
        if (read != 4) {
            throw new IOException("Failed to read path length");
        }
        ByteBuffer b = ByteBuffer.wrap(buffers.intBuffer);
        return b.getInt();
    }

    private String readPath(FileInputStream fis, ReusableBuffer buffers) throws IOException {
        int read;
        int length = this.readInt(fis, buffers);
        if (buffers.pathBuffer == null || buffers.pathBuffer.length < length) {
            buffers.pathBuffer = new byte[length];
        }
        if ((read = fis.read(buffers.pathBuffer, 0, length)) != length) {
            throw new IOException("Failed to read path");
        }
        return new String(buffers.pathBuffer, 0, length, Charsets.UTF_8);
    }

    private static class ReusableBuffer {
        byte[] intBuffer = new byte[4];
        byte[] pathBuffer = null;

        private ReusableBuffer() {
        }
    }
}

