/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler.android;

import com.android.aaptcompiler.android.ChunkType;
import com.android.aaptcompiler.android.ResChunkHeader;
import com.android.aaptcompiler.android.ResStringPoolHeader;
import com.android.aaptcompiler.android.ResStringPoolRef;
import com.android.aaptcompiler.android.ResStringPoolSpan;
import com.android.aaptcompiler.android.UtilKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BI\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0\t\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/android/aaptcompiler/android/ResStringPool;", "", "data", "Ljava/nio/ByteBuffer;", "header", "Lcom/android/aaptcompiler/android/ResStringPoolHeader;", "stringPoolSize", "", "strings", "", "", "stylesPoolSize", "styles", "Lcom/android/aaptcompiler/android/ResStringPoolSpan;", "(Ljava/nio/ByteBuffer;Lcom/android/aaptcompiler/android/ResStringPoolHeader;ILjava/util/List;ILjava/util/List;)V", "getData", "()Ljava/nio/ByteBuffer;", "getHeader", "()Lcom/android/aaptcompiler/android/ResStringPoolHeader;", "getStringPoolSize", "()I", "getStrings", "()Ljava/util/List;", "getStyles", "getStylesPoolSize", "Companion", "aaptcompiler"})
public final class ResStringPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer data;
    @NotNull
    private final ResStringPoolHeader header;
    private final int stringPoolSize;
    @NotNull
    private final List<String> strings;
    private final int stylesPoolSize;
    @NotNull
    private final List<List<ResStringPoolSpan>> styles;

    private ResStringPool(ByteBuffer data, ResStringPoolHeader header, int stringPoolSize, List<String> strings, int stylesPoolSize, List<? extends List<ResStringPoolSpan>> styles) {
        this.data = data;
        this.header = header;
        this.stringPoolSize = stringPoolSize;
        this.strings = strings;
        this.stylesPoolSize = stylesPoolSize;
        this.styles = styles;
    }

    @NotNull
    public final ByteBuffer getData() {
        return this.data;
    }

    @NotNull
    public final ResStringPoolHeader getHeader() {
        return this.header;
    }

    public final int getStringPoolSize() {
        return this.stringPoolSize;
    }

    @NotNull
    public final List<String> getStrings() {
        return this.strings;
    }

    public final int getStylesPoolSize() {
        return this.stylesPoolSize;
    }

    @NotNull
    public final List<List<ResStringPoolSpan>> getStyles() {
        return this.styles;
    }

    public /* synthetic */ ResStringPool(ByteBuffer data, ResStringPoolHeader header, int stringPoolSize, List strings, int stylesPoolSize, List styles, DefaultConstructorMarker $constructor_marker) {
        this(data, header, stringPoolSize, strings, stylesPoolSize, styles);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Lcom/android/aaptcompiler/android/ResStringPool$Companion;", "", "()V", "decodeString", "", "buffer", "Ljava/nio/ByteBuffer;", "location", "", "utf8", "", "decodeStyle", "", "Lcom/android/aaptcompiler/android/ResStringPoolSpan;", "get", "Lcom/android/aaptcompiler/android/ResStringPool;", "length", "aaptcompiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResStringPool get(@NotNull ByteBuffer buffer, int length) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.order(ByteOrder.nativeOrder());
            if (length < 28) {
                throw new IllegalStateException("Invalid StringPool: buffer too small to store a string pool.".toString());
            }
            short typeId = UtilKt.deviceToHost(buffer.getShort(0));
            int headerSize = UtilKt.deviceToHost(buffer.getShort(2));
            int resourceSize = UtilKt.deviceToHost(buffer.getInt(4));
            if (typeId != ChunkType.STRING_POOL_TYPE.getId() || headerSize != 28 || resourceSize < headerSize || resourceSize > length) {
                throw new IllegalStateException("Invalid StringPool: Header has invalid format.".toString());
            }
            ResChunkHeader chunkHeader = new ResChunkHeader(typeId, (short)headerSize);
            chunkHeader.setSize(resourceSize);
            ResStringPoolHeader header = new ResStringPoolHeader(chunkHeader, UtilKt.deviceToHost(buffer.getInt(8)), UtilKt.deviceToHost(buffer.getInt(12)));
            header.setFlags(UtilKt.deviceToHost(buffer.getInt(16)));
            header.setStringsStart(UtilKt.deviceToHost(buffer.getInt(20)));
            header.setStylesStart(UtilKt.deviceToHost(buffer.getInt(24)));
            int stringPoolSize = 0;
            List strings = new ArrayList();
            if (header.getStringCount() != 0) {
                int charSize;
                if (header.getStringCount() * 4 < header.getStringCount() || header.getHeader().getHeaderSize() + header.getStringCount() * 4 > resourceSize) {
                    throw new IllegalStateException("Invalid StringPool: Buffer not large enough for string indices.".toString());
                }
                int n = charSize = (header.getFlags() & 0x100) != 0 ? 1 : 2;
                if (header.getStringsStart() + 2 >= resourceSize) {
                    throw new IllegalStateException("Invalid StringPool: Buffer not large enough for strings.".toString());
                }
                if (header.getStyleCount() == 0) {
                    stringPoolSize = (resourceSize - header.getStringsStart()) / charSize;
                } else {
                    if (header.getStylesStart() >= resourceSize - 2) {
                        throw new IllegalStateException("Invalid StringPool: Style start specified in header too large.".toString());
                    }
                    if (header.getStylesStart() <= header.getStringsStart()) {
                        throw new IllegalStateException("Invalid StringPool: ".toString());
                    }
                    stringPoolSize = (header.getStylesStart() - header.getStringsStart()) / charSize;
                }
                if (stringPoolSize == 0) {
                    throw new IllegalStateException("Invalid StringPool: Space for strings in header is too small.".toString());
                }
                int currentStringIndex = headerSize;
                int n2 = header.getStringCount();
                for (int i = 0; i < n2; ++i) {
                    int stringLocation = UtilKt.deviceToHost(buffer.getInt(currentStringIndex)) + header.getStringsStart();
                    currentStringIndex += 4;
                    String string = this.decodeString(buffer, stringLocation, charSize == 1);
                    strings.add(string);
                }
            }
            int stylePoolSize = 0;
            List styles = new ArrayList();
            if (header.getStyleCount() != 0) {
                int currentStyleIndex = headerSize + header.getStringCount() * 4;
                if (currentStyleIndex < headerSize) {
                    throw new IllegalStateException("Invalid StringPool: Integer overflow encountered while decoding styles.".toString());
                }
                stylePoolSize = (resourceSize - header.getStylesStart()) / 4;
                int n = header.getStyleCount();
                for (int i = 0; i < n; ++i) {
                    int styleLocation = UtilKt.deviceToHost(buffer.getInt(currentStyleIndex)) + header.getStylesStart();
                    currentStyleIndex += 4;
                    List<ResStringPoolSpan> style = this.decodeStyle(buffer, styleLocation);
                    styles.add(style);
                }
            }
            return new ResStringPool(buffer, header, stringPoolSize, strings, stylePoolSize, styles, null);
        }

        private final String decodeString(ByteBuffer buffer, int location, boolean utf8) {
            int n;
            int stringPosition = location;
            if (utf8) {
                int n2;
                int n3;
                int firstByteUTF16 = buffer.get(stringPosition);
                ++stringPosition;
                if ((firstByteUTF16 & 0x80) != 0) {
                    int secondByte = buffer.get(stringPosition) & 0xFF;
                    ++stringPosition;
                    n3 = (firstByteUTF16 << 8) + secondByte & Short.MAX_VALUE;
                } else {
                    n3 = firstByteUTF16;
                }
                int utf16Length = n3;
                int firstByteUTF8 = buffer.get(stringPosition);
                ++stringPosition;
                if ((firstByteUTF8 & 0x80) != 0) {
                    int secondByte = buffer.get(stringPosition) & 0xFF;
                    ++stringPosition;
                    n2 = (firstByteUTF8 << 8) + secondByte & Short.MAX_VALUE;
                } else {
                    n2 = firstByteUTF8;
                }
                int utf8Length = n2;
                byte[] array = new byte[utf8Length];
                for (int i = 0; i < utf8Length; ++i) {
                    array[i] = buffer.get(stringPosition);
                    ++stringPosition;
                }
                if (buffer.get(stringPosition) != 0) {
                    throw new IllegalStateException("Invalid StringPool: UTF8 string value is not null-terminated.".toString());
                }
                String utf16String = new String(array, Charsets.UTF_8);
                if (utf16String.length() != utf16Length) {
                    throw new IllegalStateException("Invalid StringPool: specified UTF16 does not match actual string length.".toString());
                }
                return utf16String;
            }
            int firstShort = UtilKt.deviceToHost(buffer.getShort(stringPosition));
            stringPosition += 2;
            if ((firstShort & 0x8000) != 0) {
                int secondShort = UtilKt.deviceToHost(buffer.getShort(stringPosition)) & 0xFFFF;
                stringPosition += 2;
                n = (firstShort << 16) + secondShort & Integer.MAX_VALUE;
            } else {
                n = firstShort;
            }
            int utf16Length = n;
            char[] array = new char[utf16Length];
            for (int i = 0; i < utf16Length; ++i) {
                array[i] = UtilKt.deviceToHost(buffer.getChar(stringPosition));
                stringPosition += 2;
            }
            if (buffer.getChar(stringPosition) != '\u0000') {
                throw new IllegalStateException("Invalid StringPool: UTF16 string value is not null-terminated.".toString());
            }
            return new String(array);
        }

        private final List<ResStringPoolSpan> decodeStyle(ByteBuffer buffer, int location) {
            int refIndex;
            int currentIndex = location;
            List result = new ArrayList();
            while ((refIndex = UtilKt.deviceToHost(buffer.getInt(currentIndex))) != -1) {
                int firstChar = UtilKt.deviceToHost(buffer.getInt(currentIndex + 4));
                int lastChar = UtilKt.deviceToHost(buffer.getInt(currentIndex + 8));
                currentIndex += 12;
                result.add(new ResStringPoolSpan(new ResStringPoolRef(refIndex), firstChar, lastChar));
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

