/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001/B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020 H\u0016J\b\u0010$\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0019H\u0016J\b\u0010'\u001a\u00020 H\u0002J\b\u0010(\u001a\u00020 H\u0002J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020 H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/analytics/JournalingUsageTracker;", "Lcom/android/tools/analytics/UsageTrackerWriter;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "spoolLocation", "Ljava/nio/file/Path;", "(Ljava/util/concurrent/ScheduledExecutorService;Ljava/nio/file/Path;)V", "channel", "Ljava/nio/channels/FileChannel;", "currentLogCount", "", "flushLock", "Ljava/util/concurrent/locks/ReentrantLock;", "flushScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "gate", "", "journalTimeout", "Ljava/util/concurrent/ScheduledFuture;", "lock", "Ljava/nio/channels/FileLock;", "outputStream", "Ljava/io/OutputStream;", "pendingEvents", "Ljava/util/Queue;", "Lcom/google/wireless/android/play/playlog/proto/ClientAnalytics$LogEvent$Builder;", "scheduleVersion", "getScheduler", "()Ljava/util/concurrent/ScheduledExecutorService;", "state", "Lcom/android/tools/analytics/JournalingUsageTracker$State;", "close", "", "closeAsBroken", "closeTrackFile", "flush", "flushImpl", "logDetails", "logEvent", "newTrackFile", "scheduleFlush", "scheduleJournalTimeout", "maxJournalTime", "", "switchTrackFile", "", "tryFlush", "State", "tracker"})
@SourceDebugExtension(value={"SMAP\nJournalingUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JournalingUsageTracker.kt\ncom/android/tools/analytics/JournalingUsageTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public final class JournalingUsageTracker
extends UsageTrackerWriter {
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final Path spoolLocation;
    @NotNull
    private final ReentrantLock flushLock;
    @NotNull
    private final Object gate;
    @Nullable
    private FileLock lock;
    @Nullable
    private FileChannel channel;
    @Nullable
    private OutputStream outputStream;
    private int currentLogCount;
    @Nullable
    private ScheduledFuture<?> journalTimeout;
    private int scheduleVersion;
    @NotNull
    private volatile State state;
    @NotNull
    private final AtomicBoolean flushScheduled;
    @NotNull
    private final Queue<ClientAnalytics.LogEvent.Builder> pendingEvents;

    public JournalingUsageTracker(@NotNull ScheduledExecutorService scheduler, @NotNull Path spoolLocation) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)spoolLocation, (String)"spoolLocation");
        this.scheduler = scheduler;
        this.spoolLocation = spoolLocation;
        this.flushLock = new ReentrantLock();
        this.gate = new Object();
        this.state = State.Open;
        this.flushScheduled = new AtomicBoolean(false);
        this.pendingEvents = new ConcurrentLinkedQueue();
        try {
            this.newTrackFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize first usage tracking spool file", e);
        }
    }

    @NotNull
    public final ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    private final void newTrackFile() throws IOException {
        Object[] objectArray = new String[]{UUID.randomUUID().toString() + ".trk"};
        Path spoolFile = Paths.get(((Object)this.spoolLocation).toString(), (String[])objectArray);
        Files.createDirectories(spoolFile.getParent(), new FileAttribute[0]);
        objectArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC};
        FileChannel fileChannel = this.channel = FileChannel.open(spoolFile, (OpenOption[])objectArray);
        Intrinsics.checkNotNull((Object)fileChannel);
        this.outputStream = Channels.newOutputStream(fileChannel);
        try {
            FileChannel fileChannel2 = this.channel;
            Intrinsics.checkNotNull((Object)fileChannel2);
            this.lock = fileChannel2.tryLock();
        }
        catch (OverlappingFileLockException e) {
            this.closeTrackFile();
            throw new IOException("Unable to lock usage tracking spool file", e);
        }
        if (this.lock == null) {
            this.closeTrackFile();
            throw new IOException("Unable to lock usage tracking spool file, file already locked");
        }
        this.currentLogCount = 0;
    }

    private final void closeTrackFile() throws IOException {
        IOException ex = null;
        try {
            FileLock fileLock = this.lock;
            if (fileLock != null) {
                fileLock.release();
            }
        }
        catch (IOException e) {
            ex = e;
        }
        this.lock = null;
        try {
            FileChannel fileChannel = this.channel;
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
        catch (IOException e) {
            if (ex == null) {
                ex = e;
            }
            ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)e);
        }
        this.channel = null;
        try {
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            if (ex == null) {
                ex = e;
            }
            ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)e);
        }
        this.outputStream = null;
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void logDetails(@NotNull ClientAnalytics.LogEvent.Builder logEvent) {
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        if (this.state != State.Open) {
            return;
        }
        this.pendingEvents.add(logEvent);
        this.scheduleFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Lock lock = this.flushLock;
        lock.lock();
        try {
            boolean bl = false;
            this.flushImpl();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (!((Collection)this.pendingEvents).isEmpty()) {
            this.scheduleFlush();
        }
    }

    private final void scheduleFlush() {
        if (!this.flushLock.isLocked() && this.flushScheduled.compareAndSet(false, true)) {
            this.scheduler.submit(new Runnable(this){
                final /* synthetic */ JournalingUsageTracker this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        JournalingUsageTracker.access$tryFlush(this.this$0);
                    }
                    finally {
                        JournalingUsageTracker.access$getFlushScheduled$p(this.this$0).set(false);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryFlush() {
        if (!this.flushLock.tryLock()) {
            return;
        }
        try {
            this.flushImpl();
        }
        finally {
            this.flushLock.unlock();
        }
        if (!((Collection)this.pendingEvents).isEmpty()) {
            this.scheduleFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushImpl() {
        while (true) {
            Object object = this.gate;
            synchronized (object) {
                ClientAnalytics.LogEvent.Builder builder;
                boolean bl = false;
                ClientAnalytics.LogEvent.Builder builder2 = builder = this.pendingEvents.poll();
                if (builder2 == null) {
                    return;
                }
                Intrinsics.checkNotNull((Object)builder2);
                ClientAnalytics.LogEvent.Builder logEvent = builder;
                if (this.state != State.Open) {
                    return;
                }
                try {
                    ClientAnalytics.LogEvent logEvent2 = logEvent.build();
                    OutputStream outputStream = this.outputStream;
                    Intrinsics.checkNotNull((Object)outputStream);
                    logEvent2.writeDelimitedTo(outputStream);
                }
                catch (IOException exception) {
                    this.closeAsBroken();
                    throw new IOException("Failed to write log event", exception);
                }
                int n = this.currentLogCount;
                n = this.currentLogCount = n + 1;
                int n2 = UsageTracker.getMaxJournalSize();
                boolean bl2 = 1 <= n2 ? n2 <= n : false;
                if (bl2) {
                    this.switchTrackFile();
                    if (this.journalTimeout != null) {
                        this.scheduleJournalTimeout(UsageTracker.getMaxJournalTime());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final void closeAsBroken() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state = State.Broken;
    }

    private final boolean switchTrackFile() {
        try {
            this.closeTrackFile();
            this.newTrackFile();
            return true;
        }
        catch (IOException e) {
            this.closeAsBroken();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.gate;
        synchronized (object) {
            boolean bl = false;
            this.state = State.Closed;
            ScheduledFuture<?> scheduledFuture = this.journalTimeout;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            this.closeTrackFile();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void scheduleJournalTimeout(long maxJournalTime) {
        ++this.scheduleVersion;
        int currentScheduleVersion = this.scheduleVersion;
        ScheduledFuture<?> scheduledFuture = this.journalTimeout;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.journalTimeout = this.scheduler.schedule(new Runnable(this, currentScheduleVersion, maxJournalTime){
            final /* synthetic */ JournalingUsageTracker this$0;
            final /* synthetic */ int $currentScheduleVersion;
            final /* synthetic */ long $maxJournalTime;
            {
                this.this$0 = $receiver;
                this.$currentScheduleVersion = $currentScheduleVersion;
                this.$maxJournalTime = $maxJournalTime;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Object object = JournalingUsageTracker.access$getGate$p(this.this$0);
                JournalingUsageTracker journalingUsageTracker = this.this$0;
                int n = this.$currentScheduleVersion;
                long l = this.$maxJournalTime;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    if (JournalingUsageTracker.access$getState$p(journalingUsageTracker) != State.Open) {
                        return;
                    }
                    if (JournalingUsageTracker.access$getCurrentLogCount$p(journalingUsageTracker) > 0) {
                        JournalingUsageTracker.access$switchTrackFile(journalingUsageTracker);
                    }
                    if (JournalingUsageTracker.access$getScheduleVersion$p(journalingUsageTracker) == n) {
                        journalingUsageTracker.scheduleJournalTimeout(l);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }, maxJournalTime, TimeUnit.NANOSECONDS);
    }

    public static final /* synthetic */ void access$tryFlush(JournalingUsageTracker $this) {
        $this.tryFlush();
    }

    public static final /* synthetic */ AtomicBoolean access$getFlushScheduled$p(JournalingUsageTracker $this) {
        return $this.flushScheduled;
    }

    public static final /* synthetic */ Object access$getGate$p(JournalingUsageTracker $this) {
        return $this.gate;
    }

    public static final /* synthetic */ State access$getState$p(JournalingUsageTracker $this) {
        return $this.state;
    }

    public static final /* synthetic */ int access$getCurrentLogCount$p(JournalingUsageTracker $this) {
        return $this.currentLogCount;
    }

    public static final /* synthetic */ boolean access$switchTrackFile(JournalingUsageTracker $this) {
        return $this.switchTrackFile();
    }

    public static final /* synthetic */ int access$getScheduleVersion$p(JournalingUsageTracker $this) {
        return $this.scheduleVersion;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/analytics/JournalingUsageTracker$State;", "", "(Ljava/lang/String;I)V", "Open", "Closed", "Broken", "tracker"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Open = new State();
        public static final /* enum */ State Closed = new State();
        public static final /* enum */ State Broken = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Open, State.Closed, State.Broken};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

