/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.UUID;

public class AnalyticsSettings {
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);
    private static final transient Object sGate = new Object();
    static AnalyticsSettings sInstance;
    static DateProvider sDateProvider;
    @SerializedName(value="userId")
    private String mUserId;
    @SerializedName(value="hasOptedIn")
    private boolean mHasOptedIn;
    @SerializedName(value="debugDisablePublishing")
    private boolean mDebugDisablePublishing;
    @SerializedName(value="saltValue")
    private BigInteger mSaltValue;
    @SerializedName(value="saltSkew")
    private int mSaltSkew = -1;

    public String getUserId() {
        return this.mUserId;
    }

    public boolean hasOptedIn() {
        return this.mHasOptedIn;
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public void setHasOptedIn(boolean mHasOptedIn) {
        this.mHasOptedIn = mHasOptedIn;
    }

    public boolean hasDebugDisablePublishing() {
        return this.mDebugDisablePublishing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSalt() throws IOException {
        Object object = sGate;
        synchronized (object) {
            byte[] blob;
            int currentSaltSkew = AnalyticsSettings.currentSaltSkew();
            if (this.mSaltSkew != currentSaltSkew) {
                this.mSaltSkew = currentSaltSkew;
                SecureRandom random = new SecureRandom();
                byte[] data = new byte[24];
                random.nextBytes(data);
                this.mSaltValue = new BigInteger(data);
                this.saveSettings();
            }
            byte[] fullBlob = blob = this.mSaltValue.toByteArray();
            if (blob.length < 24) {
                fullBlob = new byte[24];
                System.arraycopy(blob, 0, fullBlob, 0, blob.length);
            }
            return fullBlob;
        }
    }

    static int currentSaltSkew() {
        LocalDate now = LocalDate.from(Instant.ofEpochMilli(sDateProvider.now().getTime()).atZone(ZoneOffset.UTC));
        long days = ChronoUnit.DAYS.between(EPOCH, now) + 3L;
        return (int)(days / 28L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static AnalyticsSettings loadSettings() throws IOException {
        File file = AnalyticsSettings.getSettingsFile();
        if (!file.exists()) {
            return null;
        }
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        try (FileLock ignored = channel.tryLock();){
            AnalyticsSettings settings;
            InputStream inputStream = Channels.newInputStream(channel);
            Gson gson = new GsonBuilder().create();
            sInstance = settings = (AnalyticsSettings)gson.fromJson((Reader)new InputStreamReader(inputStream), AnalyticsSettings.class);
            AnalyticsSettings analyticsSettings = settings;
            return analyticsSettings;
        }
        catch (OverlappingFileLockException e) {
            throw new IOException("Unable to lock settings file " + file.toString(), e);
        }
        catch (JsonParseException e) {
            throw new IOException("Unable to parse settings file " + file.toString(), e);
        }
    }

    static AnalyticsSettings createNewAnalyticsSettings() throws IOException {
        AnalyticsSettings settings = new AnalyticsSettings();
        File uidFile = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "uid.txt").toFile();
        if (uidFile.exists()) {
            try {
                String uid = Files.readFirstLine((File)uidFile, (Charset)Charsets.UTF_8);
                settings.setUserId(uid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (settings.getUserId() == null) {
            settings.setUserId(UUID.randomUUID().toString());
        }
        settings.saveSettings();
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsSettings getInstance(ILogger logger) {
        Object object = sGate;
        synchronized (object) {
            if (sInstance != null) {
                return sInstance;
            }
            try {
                sInstance = AnalyticsSettings.loadSettings();
            }
            catch (IOException e) {
                logger.info("Unable to load analytics settings: %s", new Object[]{e.getMessage()});
            }
            if (sInstance == null) {
                try {
                    sInstance = AnalyticsSettings.createNewAnalyticsSettings();
                }
                catch (IOException e) {
                    logger.info("Unable to create new analytics settings: %s", new Object[]{e.getMessage()});
                }
            }
            if (sInstance == null) {
                sInstance = new AnalyticsSettings();
                sInstance.setUserId(UUID.randomUUID().toString());
            }
            return sInstance;
        }
    }

    public static void setInstanceForTest(AnalyticsSettings settings) {
        sInstance = settings;
    }

    private static File getSettingsFile() {
        return Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "analytics.settings").toFile();
    }

    public void saveSettings() throws IOException {
        File file = AnalyticsSettings.getSettingsFile();
        try (RandomAccessFile settingsFile = new RandomAccessFile(file, "rw");
             FileChannel channel = settingsFile.getChannel();
             FileLock lock = channel.tryLock();){
            if (lock == null) {
                throw new IOException("Unable to lock settings file " + file.toString());
            }
            channel.truncate(0L);
            OutputStream outputStream = Channels.newOutputStream(channel);
            Gson gson = new GsonBuilder().create();
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            gson.toJson((Object)this, (Appendable)writer);
            writer.flush();
            outputStream.flush();
        }
        catch (OverlappingFileLockException e) {
            throw new IOException("Unable to lock settings file " + file.toString(), e);
        }
    }

    static {
        sDateProvider = DateProvider.SYSTEM;
    }
}

