/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.graphics.Matrix;
import android.support.annotation.RequiresApi;
import android.support.transition.ImageViewUtilsImpl;
import android.support.transition.MatrixUtils;
import android.support.transition.R;
import android.widget.ImageView;

@RequiresApi(value=14)
class ImageViewUtilsApi14
implements ImageViewUtilsImpl {
    ImageViewUtilsApi14() {
    }

    @Override
    public void startAnimateTransform(ImageView view) {
        ImageView.ScaleType scaleType = view.getScaleType();
        view.setTag(R.id.save_scale_type, (Object)scaleType);
        if (scaleType == ImageView.ScaleType.MATRIX) {
            view.setTag(R.id.save_image_matrix, (Object)view.getImageMatrix());
        } else {
            view.setScaleType(ImageView.ScaleType.MATRIX);
        }
        view.setImageMatrix(MatrixUtils.IDENTITY_MATRIX);
    }

    @Override
    public void animateTransform(ImageView view, Matrix matrix) {
        view.setImageMatrix(matrix);
    }

    @Override
    public void reserveEndAnimateTransform(final ImageView view, Animator animator) {
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ImageView.ScaleType scaleType = (ImageView.ScaleType)view.getTag(R.id.save_scale_type);
                view.setScaleType(scaleType);
                view.setTag(R.id.save_scale_type, null);
                if (scaleType == ImageView.ScaleType.MATRIX) {
                    view.setImageMatrix((Matrix)view.getTag(R.id.save_image_matrix));
                    view.setTag(R.id.save_image_matrix, null);
                }
                animation.removeListener((Animator.AnimatorListener)this);
            }
        });
    }
}

